/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.array;

import com.github.aaronshan.functions.utils.Failures;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@Description(name="sequence", value="_FUNC_(start, stop) - Generate a sequence of integers from start to stop.\n_FUNC_(start, stop, step) - Generate a sequence of integers from start to stop, incrementing by step.", extended="Example:\n > select _FUNC_(1, 5) from src;\n > select _FUNC_(1, 9, 4) from src;\n > select _FUNC_('2016-04-12', '2016-04-14') from src;")
public class UDFSequence
extends UDF {
    public static final DateTimeFormatter DEFAULT_DATE_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
    private static final long MAX_RESULT_ENTRIES = 10000L;

    public Object evaluate(LongWritable start, LongWritable stop) throws HiveException {
        return UDFSequence.fixedWidthSequence(start.get(), stop.get(), stop.get() >= start.get() ? 1L : -1L, Long.class);
    }

    public Object evaluate(LongWritable start, LongWritable stop, LongWritable step) throws HiveException {
        return UDFSequence.fixedWidthSequence(start.get(), stop.get(), step.get(), Long.class);
    }

    public Object evaluate(Text start, Text stop, long step) throws HiveException {
        long startMillis = DateTime.parse((String)start.toString(), (DateTimeFormatter)DEFAULT_DATE_FORMATTER).getMillis();
        long stopMillis = DateTime.parse((String)stop.toString(), (DateTimeFormatter)DEFAULT_DATE_FORMATTER).getMillis();
        return UDFSequence.fixedWidthSequence(startMillis, stopMillis, step, String.class);
    }

    public static int toIntExact(long value) {
        if ((long)((int)value) != value) {
            throw new ArithmeticException("integer overflow");
        }
        return (int)value;
    }

    private static Object fixedWidthSequence(long start, long stop, long step, Class type) throws HiveException {
        UDFSequence.checkValidStep(start, stop, step);
        int length = UDFSequence.toIntExact((stop - start) / step + 1L);
        UDFSequence.checkMaxEntry(length);
        if (type == Long.TYPE || type == Long.class) {
            ArrayList result = Lists.newArrayList();
            long i = 0L;
            long value = start;
            while (i < (long)length) {
                result.add(value);
                ++i;
                value += step;
            }
            return result;
        }
        if (type == String.class) {
            ArrayList result = Lists.newArrayList();
            long i = 0L;
            long value = start;
            while (i < (long)length) {
                DateTime dateTime = new DateTime(value);
                result.add(dateTime.toString(DEFAULT_DATE_FORMATTER));
                ++i;
                value += step;
            }
            return result;
        }
        throw new HiveException("Don't support this class type!" + type);
    }

    private static void checkValidStep(long start, long stop, long step) throws HiveException {
        Failures.checkCondition(step != 0L, "step must not be zero", new Object[0]);
        Failures.checkCondition(step > 0L ? stop >= start : stop <= start, "sequence stop value should be greater than or equal to start value if step is greater than zero otherwise stop should be less than or equal to start", new Object[0]);
    }

    private static void checkMaxEntry(int length) throws HiveException {
        Failures.checkCondition((long)length <= 10000L, "result of sequence function must not have more than 10000 entries", new Object[0]);
    }
}

