/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.bitwise;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.io.LongWritable;

@Description(name="bit_count", value="_FUNC_(x, bits) - count the number of bits set in x (treated as bits-bit signed integer) in 2\u2019s complement representation.", extended="Example:\n > select _FUNC_(9, 64) from src;")
public class UDFBitCount
extends UDF {
    private LongWritable result = new LongWritable();

    public LongWritable evaluate(long num, long bits) throws HiveException {
        if (bits == 64L) {
            this.result.set((long)Long.bitCount(num));
            return this.result;
        }
        if (bits <= 1L || bits > 64L) {
            throw new HiveException("Bits specified in bit_count must be between 2 and 64, got " + bits);
        }
        long lowBitsMask = (1 << (int)(bits - 1L)) - 1;
        if (num > lowBitsMask || num < (lowBitsMask ^ 0xFFFFFFFFFFFFFFFFL)) {
            throw new HiveException("Number must be representable with the bits specified. " + num + " can not be represented with " + bits + " bits");
        }
        long mask = lowBitsMask | Long.MIN_VALUE;
        this.result.set((long)Long.bitCount(num & mask));
        return this.result;
    }
}

