/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.date;

import java.util.Date;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@Description(name="zodiac_cn", value="_FUNC_(date) - from the input date string or separate month and day arguments, returns the sing of the Zodiac.", extended="Example:\n > select _FUNC_(date_string) from src;\n > select _FUNC_(month, day) from src;")
public class UDFZodiacSignCn
extends UDF {
    public static final DateTimeFormatter DEFAULT_DATE_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    private Text result = new Text();

    public Text evaluate(Text birthday) {
        if (birthday == null) {
            return null;
        }
        DateTime dateTime = null;
        try {
            dateTime = DateTime.parse((String)birthday.toString(), (DateTimeFormatter)DEFAULT_DATE_FORMATTER);
        }
        catch (Exception e) {
            return null;
        }
        return this.evaluate(dateTime.toDate());
    }

    public Text evaluate(Date birthday) {
        if (birthday == null) {
            return null;
        }
        DateTime dateTime = new DateTime((Object)birthday);
        return this.evaluate(new IntWritable(dateTime.getMonthOfYear()), new IntWritable(dateTime.getDayOfMonth()));
    }

    public Text evaluate(IntWritable month, IntWritable day) {
        if (month == null || day == null) {
            return null;
        }
        this.result.set(this.getZodiac(month.get(), day.get()));
        return this.result;
    }

    private String getZodiac(int month, int day) {
        String[] zodiacArray = new String[]{"\u9b54\u7faf\u5ea7", "\u6c34\u74f6\u5ea7", "\u53cc\u9c7c\u5ea7", "\u767d\u7f8a\u5ea7", "\u91d1\u725b\u5ea7", "\u53cc\u5b50\u5ea7", "\u5de8\u87f9\u5ea7", "\u72ee\u5b50\u5ea7", "\u5904\u5973\u5ea7", "\u5929\u79e4\u5ea7", "\u5929\u874e\u5ea7", "\u5c04\u624b\u5ea7"};
        int[] splitDay = new int[]{19, 18, 20, 20, 20, 21, 22, 22, 22, 22, 21, 21};
        int index = month;
        if (day <= splitDay[month - 1]) {
            --index;
        } else if (month == 12) {
            index = 0;
        }
        return zodiacArray[index];
    }
}

