/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.fastuitl.ints;

import com.github.aaronshan.functions.fastuitl.ints.IntComparator;

public class IntArrays {
    private static void selectionSort(int[] a, int from, int to, IntComparator comp) {
        for (int i = from; i < to - 1; ++i) {
            int u;
            int m = i;
            for (u = i + 1; u < to; ++u) {
                if (comp.compare(a[u], a[m]) >= 0) continue;
                m = u;
            }
            if (m == i) continue;
            u = a[i];
            a[i] = a[m];
            a[m] = u;
        }
    }

    private static void swap(int[] x, int a, int b) {
        int t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void vecSwap(int[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            IntArrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(int[] x, int a, int b, int c, IntComparator comp) {
        int ab = comp.compare(x[a], x[b]);
        int ac = comp.compare(x[a], x[c]);
        int bc = comp.compare(x[b], x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    public static void quickSort(int[] x, int from, int to, IntComparator comp) {
        int len = to - from;
        if (len >= 7) {
            int c;
            int b;
            int a;
            int v;
            int m = from + len / 2;
            if (len > 7) {
                v = from;
                a = to - 1;
                if (len > 50) {
                    b = len / 8;
                    v = IntArrays.med3(x, from, from + b, from + 2 * b, comp);
                    m = IntArrays.med3(x, m - b, m, m + b, comp);
                    a = IntArrays.med3(x, a - 2 * b, a - b, a, comp);
                }
                m = IntArrays.med3(x, v, m, a, comp);
            }
            v = x[m];
            a = from;
            b = from;
            int d = c = to - 1;
            while (true) {
                int s;
                if (b > c || (s = comp.compare(x[b], v)) > 0) {
                    while (c >= b && (s = comp.compare(x[c], v)) >= 0) {
                        if (s == 0) {
                            IntArrays.swap(x, c, d--);
                        }
                        --c;
                    }
                    if (b > c) {
                        s = Math.min(a - from, b - a);
                        IntArrays.vecSwap(x, from, b - s, s);
                        s = Math.min(d - c, to - d - 1);
                        IntArrays.vecSwap(x, b, to - s, s);
                        s = b - a;
                        if (s > 1) {
                            IntArrays.quickSort(x, from, from + s, comp);
                        }
                        if ((s = d - c) > 1) {
                            IntArrays.quickSort(x, to - s, to, comp);
                        }
                        return;
                    }
                    IntArrays.swap(x, b++, c--);
                    continue;
                }
                if (s == 0) {
                    IntArrays.swap(x, a++, b);
                }
                ++b;
            }
        }
        IntArrays.selectionSort(x, from, to, comp);
    }
}

