/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.json;

import com.github.aaronshan.functions.utils.json.JsonExtract;
import com.github.aaronshan.functions.utils.json.JsonPath;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.Text;

@Description(name="json_extract_scalar", value="_FUNC_(json, json_path) - like json_extract, but returns the result value as a string (as opposed to being encoded as JSON). ", extended="Example:\n  > SELECT _FUNC_(json_array, json_path) FROM src LIMIT 1;")
public class UDFJsonExtractScalar
extends UDF {
    private Text result = new Text();

    public Text evaluate(Text json, Text path) {
        try {
            JsonPath jsonPath = new JsonPath(path.toString());
            String content = JsonExtract.extract(json.toString(), jsonPath.getScalarExtractor());
            this.result.set(content);
            return this.result;
        }
        catch (Exception e) {
            return null;
        }
    }
}

