/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.map;

import java.util.LinkedHashMap;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;

@Description(name="map_build", value="_FUNC_(array<K>, array<V>) - returns a map created using the given key/value arrays.", extended="Example:\n > select _FUNC_(array, array) from src;")
public class UDFMapBuild
extends GenericUDF {
    private static final int ARG_COUNT = 2;
    LinkedHashMap<Object, Object> result = new LinkedHashMap();
    private transient ListObjectInspector keyArrayOI;
    private transient ListObjectInspector valueArrayOI;

    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 2) {
            throw new UDFArgumentLengthException("The function map_build(array, array) takes exactly 2 arguments.");
        }
        for (int i = 0; i < 2; ++i) {
            if (arguments[i].getCategory().equals((Object)ObjectInspector.Category.LIST)) continue;
            throw new UDFArgumentTypeException(i, "\"array\" expected at function map_build, but \"" + arguments[i].getTypeName() + "\" is found");
        }
        this.keyArrayOI = (ListObjectInspector)arguments[0];
        this.valueArrayOI = (ListObjectInspector)arguments[1];
        ObjectInspector mapKeyOI = this.keyArrayOI.getListElementObjectInspector();
        ObjectInspector mapValueOI = this.valueArrayOI.getListElementObjectInspector();
        return ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)mapKeyOI, (ObjectInspector)mapValueOI);
    }

    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object keyArray = arguments[0].get();
        Object valueArray = arguments[1].get();
        int keyArrayLength = this.keyArrayOI.getListLength(keyArray);
        int valueArrayLength = this.valueArrayOI.getListLength(valueArray);
        if (keyArray == null || valueArray == null || keyArrayLength <= 0 || valueArrayLength <= 0) {
            return null;
        }
        if (keyArrayLength != valueArrayLength) {
            throw new HiveException("key array length not equals value array length!");
        }
        this.result.clear();
        for (int i = 0; i < keyArrayLength; ++i) {
            this.result.put(this.keyArrayOI.getListElement(keyArray, i), this.valueArrayOI.getListElement(valueArray, i));
        }
        return this.result;
    }

    public String getDisplayString(String[] strings) {
        assert (strings.length == 2);
        return "map_build(" + strings[0] + ", " + strings[1] + ")";
    }
}

