/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.map;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;

@Description(name="map_concat", value="_FUNC_(x<K, V>, y<K, V>) - returns the union of two maps. If a key is found in both x and y, that key\u2019s value in the resulting map comes from y.", extended="Example:\n > select _FUNC_(mapX, mapY) from src;")
public class UDFMapConcat
extends GenericUDF {
    private static final int ARG_COUNT = 2;
    LinkedHashMap<Object, Object> result = new LinkedHashMap();
    private transient MapObjectInspector leftMapOI;
    private transient MapObjectInspector rightMapOI;

    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 2) {
            throw new UDFArgumentLengthException("The function map_concat(map, map) takes exactly 2 arguments.");
        }
        for (int i = 0; i < 2; ++i) {
            if (arguments[i].getCategory().equals((Object)ObjectInspector.Category.MAP)) continue;
            throw new UDFArgumentTypeException(i, "\"map\" expected at function map_concat, but \"" + arguments[i].getTypeName() + "\" is found");
        }
        this.leftMapOI = (MapObjectInspector)arguments[0];
        this.rightMapOI = (MapObjectInspector)arguments[1];
        ObjectInspector leftMapKeyOI = this.leftMapOI.getMapKeyObjectInspector();
        ObjectInspector leftMapValueOI = this.leftMapOI.getMapValueObjectInspector();
        ObjectInspector rightMapKeyOI = this.rightMapOI.getMapKeyObjectInspector();
        ObjectInspector rightMapValueOI = this.rightMapOI.getMapValueObjectInspector();
        if (!ObjectInspectorUtils.compareTypes((ObjectInspector)leftMapKeyOI, (ObjectInspector)rightMapKeyOI)) {
            throw new UDFArgumentTypeException(1, "\"" + leftMapKeyOI.getTypeName() + "\" expected at function map_concat key, but \"" + rightMapKeyOI.getTypeName() + "\" is found");
        }
        if (!ObjectInspectorUtils.compareTypes((ObjectInspector)leftMapValueOI, (ObjectInspector)rightMapValueOI)) {
            throw new UDFArgumentTypeException(1, "\"" + leftMapValueOI.getTypeName() + "\" expected at function map_concat value, but \"" + rightMapValueOI.getTypeName() + "\" is found");
        }
        return ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)leftMapKeyOI, (ObjectInspector)leftMapValueOI);
    }

    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        this.result.clear();
        Object leftMapObj = arguments[0].get();
        Object rightMapObj = arguments[1].get();
        Map leftMap = this.leftMapOI.getMap(leftMapObj);
        Map rightMap = this.leftMapOI.getMap(rightMapObj);
        if (leftMap == null) {
            if (rightMap == null) {
                return null;
            }
            return rightMap;
        }
        if (rightMap == null) {
            return leftMap;
        }
        this.result.putAll(leftMap);
        this.result.putAll(rightMap);
        return this.result;
    }

    public String getDisplayString(String[] strings) {
        assert (strings.length == 2);
        return "map_concat(" + strings[0] + ", " + strings[1] + ")";
    }
}

