/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.map;

import java.util.Map;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;

@Description(name="map_element_at", value="_FUNC_(x<K, V>, key) - returns value for given key, or NULL if the key is not contained in the map.", extended="Example:\n > select _FUNC_(map, key) from src;")
public class UDFMapElementAt
extends GenericUDF {
    private static final int ARG_COUNT = 2;
    private transient MapObjectInspector mapOI;
    private transient ObjectInspector keyOI;

    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 2) {
            throw new UDFArgumentLengthException("The function map_element_at(map, key) takes exactly 2 arguments.");
        }
        if (!arguments[0].getCategory().equals((Object)ObjectInspector.Category.MAP)) {
            throw new UDFArgumentTypeException(0, "\"map\" expected at function map_element_at, but \"" + arguments[0].getTypeName() + "\" is found");
        }
        this.mapOI = (MapObjectInspector)arguments[0];
        this.keyOI = arguments[1];
        ObjectInspector mapKeyOI = this.mapOI.getMapKeyObjectInspector();
        ObjectInspector mapValueOI = this.mapOI.getMapValueObjectInspector();
        if (!ObjectInspectorUtils.compareTypes((ObjectInspector)mapKeyOI, (ObjectInspector)this.keyOI)) {
            throw new UDFArgumentTypeException(1, "\"" + mapKeyOI.getTypeName() + "\" expected at function map_element_at key, but \"" + this.keyOI.getTypeName() + "\" is found");
        }
        return mapValueOI;
    }

    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object mapObj = arguments[0].get();
        Object keyObj = arguments[1].get();
        Map map = this.mapOI.getMap(mapObj);
        if (map == null) {
            return null;
        }
        return map.get(keyObj);
    }

    public String getDisplayString(String[] strings) {
        assert (strings.length == 2);
        return "map_element_at(" + strings[0] + ", " + strings[1] + ")";
    }
}

