/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.map;

import com.github.aaronshan.functions.utils.MapUtils;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.BooleanWritable;

@Description(name="map_equals", value="_FUNC_(x<K, V>, y<K, V>) - whether map x equals with map y or not.", extended="Example:\n > select _FUNC_(mapX, mapY) from src;")
public class UDFMapEquals
extends GenericUDF {
    private static final int ARG_COUNT = 2;
    private transient MapObjectInspector leftMapOI;
    private transient MapObjectInspector rightMapOI;
    private BooleanWritable result;

    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 2) {
            throw new UDFArgumentLengthException("The function map_equals(map, map) takes exactly 2 arguments.");
        }
        for (int i = 0; i < 2; ++i) {
            if (arguments[i].getCategory().equals((Object)ObjectInspector.Category.MAP)) continue;
            throw new UDFArgumentTypeException(i, "\"map\" expected at function map_equals, but \"" + arguments[i].getTypeName() + "\" is found");
        }
        this.leftMapOI = (MapObjectInspector)arguments[0];
        this.rightMapOI = (MapObjectInspector)arguments[1];
        ObjectInspector leftMapKeyOI = this.leftMapOI.getMapKeyObjectInspector();
        ObjectInspector leftMapValueOI = this.leftMapOI.getMapValueObjectInspector();
        ObjectInspector rightMapKeyOI = this.rightMapOI.getMapKeyObjectInspector();
        ObjectInspector rightMapValueOI = this.rightMapOI.getMapValueObjectInspector();
        if (!ObjectInspectorUtils.compareTypes((ObjectInspector)leftMapKeyOI, (ObjectInspector)rightMapKeyOI)) {
            throw new UDFArgumentTypeException(1, "\"" + leftMapKeyOI.getTypeName() + "\" expected at function map_equals key, but \"" + rightMapKeyOI.getTypeName() + "\" is found");
        }
        if (!ObjectInspectorUtils.compareTypes((ObjectInspector)leftMapValueOI, (ObjectInspector)rightMapValueOI)) {
            throw new UDFArgumentTypeException(1, "\"" + leftMapValueOI.getTypeName() + "\" expected at function map_equals value, but \"" + rightMapValueOI.getTypeName() + "\" is found");
        }
        if (!ObjectInspectorUtils.compareSupported((ObjectInspector)leftMapValueOI)) {
            throw new UDFArgumentException("The function map_equals does not support comparison for \"" + leftMapValueOI.getTypeName() + "\" types");
        }
        this.result = new BooleanWritable(false);
        return PrimitiveObjectInspectorFactory.writableBooleanObjectInspector;
    }

    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        this.result.set(false);
        Object leftMapObj = arguments[0].get();
        Object rightMapObj = arguments[1].get();
        Map leftMap = this.leftMapOI.getMap(leftMapObj);
        Map rightMap = this.leftMapOI.getMap(rightMapObj);
        boolean ret = MapUtils.mapEquals(leftMap, rightMap, this.leftMapOI.getMapValueObjectInspector());
        this.result.set(ret);
        return this.result;
    }

    public String getDisplayString(String[] strings) {
        assert (strings.length == 2);
        return "map_equals(" + strings[0] + ", " + strings[1] + ")";
    }
}

