/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.math;

import com.github.aaronshan.functions.utils.MathUtils;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;

@Description(name="from_base", value="_FUNC_(string, long) - convert a number to a string in the given base.", extended="Example:\n > select _FUNC_(string, long) from src;")
public class UDFMathFromBase
extends UDF {
    private LongWritable result = new LongWritable();

    public LongWritable evaluate(Text value, LongWritable radix) throws HiveException {
        if (value == null || radix == null) {
            return null;
        }
        MathUtils.checkRadix(radix.get());
        try {
            this.result.set(Long.parseLong(value.toString(), (int)radix.get()));
        }
        catch (NumberFormatException e) {
            throw new HiveException(String.format("Not a valid base-%d number: %s", radix, value.toString()), (Throwable)e);
        }
        return this.result;
    }
}

