/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.math;

import com.github.aaronshan.functions.utils.Failures;
import org.apache.commons.math3.special.Erf;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.io.DoubleWritable;

@Description(name="inverse_normal_cdf", value="_FUNC_(mean, sd, p) - inverse of normal cdf given a mean, std, and probability.", extended="Example:\n > select _FUNC_(mean, sd, p) from src;")
public class UDFMathInverseNormalCdf
extends UDF {
    private DoubleWritable result = new DoubleWritable();

    public DoubleWritable evaluate(double mean, double sd, double p) throws HiveException {
        Failures.checkCondition(p > 0.0 && p < 1.0, "p must be 0 > p > 1", new Object[0]);
        Failures.checkCondition(sd > 0.0, "sd must > 0", new Object[0]);
        this.result.set(mean + sd * 1.4142135623730951 * Erf.erfInv((double)(2.0 * p - 1.0)));
        return this.result;
    }
}

