/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.math;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.DoubleWritable;

@Description(name="is_finite", value="_FUNC_(double) - test if value is finite.", extended="Example:\n > select _FUNC_(double) from src;")
public class UDFMathIsFinite
extends UDF {
    public static final double MAX_VALUE = Double.MAX_VALUE;
    BooleanWritable result = new BooleanWritable();

    public BooleanWritable evaluate(DoubleWritable num) {
        if (num == null) {
            this.result.set(false);
        } else {
            this.result.set(this.isFinite(num.get()));
        }
        return this.result;
    }

    private boolean isFinite(double d) {
        return Math.abs(d) <= Double.MAX_VALUE;
    }
}

