/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.math;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.DoubleWritable;

@Description(name="is_infinite", value="_FUNC_(double) - test if value is infinite.", extended="Example:\n > select _FUNC_(double) from src;")
public class UDFMathIsInfinite
extends UDF {
    public static final double POSITIVE_INFINITY = Double.POSITIVE_INFINITY;
    public static final double NEGATIVE_INFINITY = Double.NEGATIVE_INFINITY;
    BooleanWritable result = new BooleanWritable();

    public BooleanWritable evaluate(DoubleWritable num) {
        if (num == null) {
            this.result.set(false);
        } else {
            this.result.set(this.isInfinite(num.get()));
        }
        return this.result;
    }

    private boolean isInfinite(double v) {
        return v == Double.POSITIVE_INFINITY || v == Double.NEGATIVE_INFINITY;
    }
}

