/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.math;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.DoubleWritable;

@Description(name="is_nan", value="_FUNC_(double) - test if value is nan.", extended="Example:\n > select _FUNC_(double) from src;")
public class UDFMathIsNaN
extends UDF {
    BooleanWritable result = new BooleanWritable();

    public BooleanWritable evaluate(DoubleWritable num) {
        if (num == null) {
            this.result.set(false);
        } else {
            this.result.set(this.isNaN(num.get()));
        }
        return this.result;
    }

    private boolean isNaN(double v) {
        return v != v;
    }
}

