/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.math;

import com.github.aaronshan.functions.utils.Failures;
import org.apache.commons.math3.special.Erf;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.io.DoubleWritable;

@Description(name="normal_cdf", value="_FUNC_(mean, sd, v) - normal cdf given a mean, standard deviation, and value.", extended="Example:\n > select _FUNC_(mean, sd, v) from src;")
public class UDFMathNormalCdf
extends UDF {
    private DoubleWritable result = new DoubleWritable();

    public DoubleWritable evaluate(double mean, double standardDeviation, double value) throws HiveException {
        Failures.checkCondition(standardDeviation > 0.0, "standardDeviation must > 0", new Object[0]);
        this.result.set(0.5 * (1.0 + Erf.erf((double)((value - mean) / (standardDeviation * Math.sqrt(2.0))))));
        return this.result;
    }
}

