/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.math;

import com.github.aaronshan.functions.utils.MathUtils;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;

@Description(name="to_base", value="_FUNC_(long, long) - convert a number to a string in the given base.", extended="Example:\n > select _FUNC_(long, long) from src;")
public class UDFMathToBase
extends UDF {
    private Text result = new Text();

    public Text evaluate(LongWritable value, LongWritable radix) throws HiveException {
        if (value == null || radix == null) {
            return null;
        }
        MathUtils.checkRadix(radix.get());
        this.result.set(Long.toString(value.get(), (int)radix.get()));
        return this.result;
    }
}

