/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.regexp;

import com.github.aaronshan.functions.regexp.re2j.Matcher;
import com.github.aaronshan.functions.regexp.re2j.Options;
import com.github.aaronshan.functions.regexp.re2j.Pattern;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.airlift.slice.Slice;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Re2JRegexp {
    private static final Logger log = LoggerFactory.getLogger(Re2JRegexp.class);
    private static final java.util.regex.Pattern DOT_STAR_PREFIX_PATTERN = java.util.regex.Pattern.compile("(?s)^(\\.\\*\\??)?(.*)");
    private static final int CORE_PATTERN_INDEX = 2;
    public final int dfaStatesLimit;
    public final int dfaRetries;
    public final Pattern re2jPattern;
    public final Pattern re2jPatternWithoutDotStartPrefix;

    public Re2JRegexp(int dfaStatesLimit, int dfaRetries, Slice pattern) {
        this.dfaStatesLimit = dfaStatesLimit;
        this.dfaRetries = dfaRetries;
        Options options = Options.builder().setAlgorithm(Options.Algorithm.DFA_FALLBACK_TO_NFA).setMaximumNumberOfDFAStates(dfaStatesLimit).setNumberOfDFARetries(dfaRetries).setEventsListener(new RE2JEventsListener()).build();
        String patternString = pattern.toStringUtf8();
        this.re2jPattern = Pattern.compile(patternString, options);
        java.util.regex.Matcher dotStarPrefixMatcher = DOT_STAR_PREFIX_PATTERN.matcher(patternString);
        Preconditions.checkState((boolean)dotStarPrefixMatcher.matches());
        String patternStringWithoutDotStartPrefix = dotStarPrefixMatcher.group(2);
        this.re2jPatternWithoutDotStartPrefix = !patternStringWithoutDotStartPrefix.equals(patternString) ? Pattern.compile(patternStringWithoutDotStartPrefix, options) : this.re2jPattern;
    }

    private static void validateGroup(int group, int groupCount) throws HiveException {
        if (group < 0) {
            throw new HiveException("Group cannot be negative");
        }
        if (group > groupCount) {
            throw new HiveException(String.format("Pattern has %d groups. Cannot access group %d", groupCount, group));
        }
    }

    public static int toIntExact(long value) {
        if ((long)((int)value) != value) {
            throw new ArithmeticException("integer overflow");
        }
        return (int)value;
    }

    public boolean matches(Slice source) {
        return this.re2jPatternWithoutDotStartPrefix.find(source);
    }

    public Slice replace(Slice source, Slice replacement) throws HiveException {
        Matcher matcher = this.re2jPattern.matcher(source);
        try {
            return matcher.replaceAll(replacement);
        }
        catch (IndexOutOfBoundsException e) {
            throw new HiveException("Illegal replacement sequence: " + replacement.toStringUtf8());
        }
        catch (IllegalArgumentException e) {
            throw new HiveException("Illegal replacement sequence: " + replacement.toStringUtf8());
        }
    }

    public List<Object> extractAll(Slice source, long groupIndex) throws HiveException {
        Matcher matcher = this.re2jPattern.matcher(source);
        int group = (int)groupIndex;
        Re2JRegexp.validateGroup(group, matcher.groupCount());
        ArrayList list = Lists.newArrayList();
        while (matcher.find()) {
            Slice searchedGroup = matcher.group(group);
            if (searchedGroup == null) {
                list.add(null);
                continue;
            }
            list.add(searchedGroup.toStringUtf8());
        }
        return list;
    }

    public Slice extract(Slice source, long groupIndex) throws HiveException {
        Matcher matcher = this.re2jPattern.matcher(source);
        int group = (int)groupIndex;
        Re2JRegexp.validateGroup(group, matcher.groupCount());
        if (!matcher.find()) {
            return null;
        }
        return matcher.group(group);
    }

    public List<Object> split(Slice source) {
        Matcher matcher = this.re2jPattern.matcher(source);
        ArrayList list = Lists.newArrayList();
        int lastEnd = 0;
        while (matcher.find()) {
            Slice slice = source.slice(lastEnd, matcher.start() - lastEnd);
            lastEnd = matcher.end();
            list.add(slice.toString());
        }
        list.add(source.slice(lastEnd, source.length() - lastEnd).toString());
        return list;
    }

    private class RE2JEventsListener
    implements Options.EventsListener {
        private RE2JEventsListener() {
        }

        @Override
        public void fallbackToNFA() {
            log.debug("Fallback to NFA, pattern: %s, DFA states limit: %d, DFA retries: %d", new Object[]{Re2JRegexp.this.re2jPattern.pattern(), Re2JRegexp.this.dfaStatesLimit, Re2JRegexp.this.dfaRetries});
        }
    }
}

