/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.regexp;

import com.github.aaronshan.functions.regexp.Re2JRegexp;
import io.airlift.slice.Slices;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.io.Text;

@Description(name="regexp_replace", value="_FUNC_(string, string) - removes substrings matching a regular expression\n_FUNC_(string, string, string) - replaces substrings matching a regular expression by given string.", extended="Example:\n > select _FUNC_(string, pattern) from src;\nselect _FUNC_(string, pattern, replacement) from src;")
public class UDFRe2JRegexpReplace
extends UDF {
    private static Re2JRegexp re2JRegexp;
    private Text result = new Text();

    public Text evaluate(Text source, Text pattern) throws HiveException {
        return this.evaluate(source, pattern, new Text(Slices.EMPTY_SLICE.toStringUtf8()));
    }

    public Text evaluate(Text source, Text pattern, Text replacement) throws HiveException {
        if (source == null) {
            return null;
        }
        if (re2JRegexp == null) {
            re2JRegexp = new Re2JRegexp(Integer.MAX_VALUE, 5, Slices.utf8Slice((String)pattern.toString()));
        }
        this.result.set(re2JRegexp.replace(Slices.utf8Slice((String)source.toString()), Slices.utf8Slice((String)replacement.toString())).toStringUtf8());
        return this.result;
    }
}

