/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.regexp;

import com.github.aaronshan.functions.regexp.Re2JRegexp;
import io.airlift.slice.Slices;
import java.util.ArrayList;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;

@Description(name="regexp_split", value="_FUNC_(string, string) - returns array of strings split by pattern.", extended="Example:\n > select _FUNC_(string, pattern) from src;")
public class UDFRe2JRegexpSplit
extends GenericUDF {
    private static final int ARG_COUNT = 2;
    private transient ArrayList<Object> result = new ArrayList();
    private transient Re2JRegexp re2JRegexp;

    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 2) {
            throw new UDFArgumentLengthException("The function regexp_split(string, pattern) takes exactly 2 arguments.");
        }
        for (int i = 0; i < 2; ++i) {
            if (ObjectInspectorUtils.compareTypes((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)arguments[i])) continue;
            throw new UDFArgumentTypeException(i, "\"" + PrimitiveObjectInspectorFactory.javaStringObjectInspector.getTypeName() + "\" expected at function regexp_split, but \"" + arguments[i].getTypeName() + "\" is found");
        }
        JavaStringObjectInspector expectOI = PrimitiveObjectInspectorFactory.javaStringObjectInspector;
        return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)expectOI);
    }

    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        String source = (String)arguments[0].get();
        String pattern = (String)arguments[1].get();
        if (source == null) {
            return null;
        }
        if (this.re2JRegexp == null) {
            this.re2JRegexp = new Re2JRegexp(Integer.MAX_VALUE, 5, Slices.utf8Slice((String)pattern));
        }
        this.result.clear();
        this.result.addAll(this.re2JRegexp.split(Slices.utf8Slice((String)source)));
        return this.result;
    }

    public String getDisplayString(String[] strings) {
        assert (strings.length == 2);
        return "regexp_split(" + strings[0] + ", " + strings[1] + ")";
    }
}

