/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.regexp.re2j;

import com.github.aaronshan.functions.regexp.re2j.Inst;
import com.github.aaronshan.functions.regexp.re2j.Prog;
import com.github.aaronshan.functions.regexp.re2j.Regexp;
import com.github.aaronshan.functions.regexp.re2j.Unicode;
import java.util.LinkedList;
import java.util.List;

class Compiler {
    private static final int[] ANY_RUNE_NOT_NL = new int[]{0, 9, 11, 0x10FFFF};
    private static final int[] ANY_RUNE = new int[]{0, 0x10FFFF};
    private static final byte[] ANY_BYTE = new byte[]{0, -1};
    private final Prog prog = new Prog();
    private boolean reversed;

    private Compiler() {
        this.newInst(Inst.Op.FAIL);
    }

    static Prog compileRegexp(Regexp re, boolean reversed) {
        Compiler c = new Compiler();
        return c.compileToProgram(re, reversed);
    }

    private Frag newInst(Inst.Op op) {
        this.prog.addInst(op);
        return new Frag(this.prog.numInst() - 1);
    }

    private Frag nop() {
        Frag f = this.newInst(Inst.Op.NOP);
        f.out = f.i << 1;
        return f;
    }

    private Frag match() {
        return this.newInst(Inst.Op.MATCH);
    }

    private Frag fail() {
        return new Frag();
    }

    private Frag cap(int arg) {
        Frag f = this.newInst(Inst.Op.CAPTURE);
        f.out = f.i << 1;
        this.prog.getInst((int)f.i).arg = arg;
        if (this.prog.numCap < arg + 1) {
            this.prog.numCap = arg + 1;
        }
        return f;
    }

    private Frag cat(Frag f1, Frag f2) {
        if (f1.i == 0 || f2.i == 0) {
            return this.fail();
        }
        if (this.reversed) {
            this.prog.patch(f2.out, f1.i);
            return new Frag(f2.i, f1.out);
        }
        this.prog.patch(f1.out, f2.i);
        return new Frag(f1.i, f2.out);
    }

    private Frag alt(Frag f1, Frag f2) {
        if (f1.i == 0) {
            return f2;
        }
        if (f2.i == 0) {
            return f1;
        }
        Frag f = this.newInst(Inst.Op.ALT);
        Inst i = this.prog.getInst(f.i);
        i.out = f1.i;
        i.arg = f2.i;
        f.out = this.prog.append(f1.out, f2.out);
        return f;
    }

    private Frag quest(Frag f1, boolean nongreedy) {
        Frag f = this.newInst(Inst.Op.ALT);
        Inst i = this.prog.getInst(f.i);
        if (nongreedy) {
            i.arg = f1.i;
            f.out = f.i << 1;
        } else {
            i.out = f1.i;
            f.out = f.i << 1 | 1;
        }
        f.out = this.prog.append(f.out, f1.out);
        return f;
    }

    private Frag star(Frag f1, boolean nongreedy) {
        Frag f = this.newInst(Inst.Op.ALT);
        Inst i = this.prog.getInst(f.i);
        if (nongreedy) {
            i.arg = f1.i;
            f.out = f.i << 1;
        } else {
            i.out = f1.i;
            f.out = f.i << 1 | 1;
        }
        this.prog.patch(f1.out, f.i);
        return f;
    }

    private Frag plus(Frag f1, boolean nongreedy) {
        return new Frag(f1.i, this.star((Frag)f1, (boolean)nongreedy).out);
    }

    private Frag empty(int op) {
        Frag f = this.newInst(Inst.Op.EMPTY_WIDTH);
        this.prog.getInst((int)f.i).arg = op;
        f.out = f.i << 1;
        return f;
    }

    private Frag rune(int rune, int flags) {
        if ((flags & 1) == 0) {
            return this.rune(new int[]{rune}, flags);
        }
        return this.alt(this.rune(new int[]{rune}, flags), this.rune(new int[]{Unicode.simpleFold(rune)}, flags));
    }

    private Frag rune(int[] runes, int flags) {
        if (runes.length == 1) {
            return this.rune(runes[0], runes[0], flags);
        }
        if (runes.length > 1) {
            LinkedList<Integer> expandedRunes = new LinkedList<Integer>();
            for (int i = 0; i < runes.length; i += 2) {
                this.expandRuneRange(runes[i], runes[i + 1], expandedRunes);
            }
            Frag alt = this.rune((Integer)expandedRunes.get(0), (Integer)expandedRunes.get(1), flags);
            for (int i = 2; i < expandedRunes.size(); i += 2) {
                alt = this.alt(alt, this.rune((Integer)expandedRunes.get(i), (Integer)expandedRunes.get(i + 1), flags));
            }
            return alt;
        }
        return this.fail();
    }

    private void expandRuneRange(int lo, int hi, List<Integer> runes) {
        int i;
        for (i = 1; i < 4; ++i) {
            int max = Unicode.maxRune(i);
            if (lo > max || max >= hi) continue;
            this.expandRuneRange(lo, max, runes);
            this.expandRuneRange(max + 1, hi, runes);
            return;
        }
        if (hi < 128) {
            runes.add(lo);
            runes.add(hi);
            return;
        }
        for (i = 1; i < 4; ++i) {
            int m = (1 << 6 * i) - 1;
            if ((lo & ~m) == (hi & ~m)) continue;
            if ((lo & m) != 0) {
                this.expandRuneRange(lo, lo | m, runes);
                this.expandRuneRange((lo | m) + 1, hi, runes);
                return;
            }
            if ((hi & m) == m) continue;
            this.expandRuneRange(lo, (hi & ~m) - 1, runes);
            this.expandRuneRange(hi & ~m, hi, runes);
            return;
        }
        runes.add(lo);
        runes.add(hi);
    }

    private Frag rune(int lo, int hi, int flags) {
        return this.bytes(Unicode.codePointToUtf8(lo), Unicode.codePointToUtf8(hi), flags);
    }

    private Frag bytes(byte[] lo, byte[] hi, int flags) {
        Frag prefix = this.byteRange(new byte[]{lo[0], hi[0]}, flags);
        for (int i = 1; i < lo.length; ++i) {
            prefix = this.cat(prefix, this.byteRange(new byte[]{lo[i], hi[i]}, flags));
        }
        return prefix;
    }

    private Frag byteRange(byte[] byteRanges, int flags) {
        Frag f = this.newInst(Inst.Op.BYTE);
        Inst i = this.prog.getInst(f.i);
        i.byteRanges = byteRanges;
        i.arg = flags;
        f.out = f.i << 1;
        if (byteRanges.length == 1 || byteRanges.length == 2 && byteRanges[0] == byteRanges[1]) {
            i.op = Inst.Op.BYTE1;
            i.byteRanges = new byte[]{byteRanges[0]};
        }
        return f;
    }

    private Prog compileToProgram(Regexp re, boolean reversed) {
        this.reversed = reversed;
        Frag f = this.compile(re);
        this.reversed = false;
        Frag all = this.cat(f, this.match());
        this.prog.start = all.i;
        if ((this.prog.startCond() & 4) == 0) {
            Frag unanchored = this.cat(this.star(this.byteRange(ANY_BYTE, 0), true), all);
            this.prog.startUnanchored = unanchored.i;
        } else {
            this.prog.startUnanchored = this.prog.start;
        }
        return this.prog;
    }

    private Frag compile(Regexp re) {
        switch (re.op) {
            case NO_MATCH: {
                return this.fail();
            }
            case EMPTY_MATCH: {
                return this.nop();
            }
            case LITERAL: {
                if (re.runes.length == 0) {
                    return this.nop();
                }
                Frag f = null;
                for (int r : re.runes) {
                    Frag f1 = this.rune(r, re.flags);
                    f = f == null ? f1 : this.cat(f, f1);
                }
                return f;
            }
            case CHAR_CLASS: {
                return this.rune(re.runes, re.flags);
            }
            case ANY_CHAR_NOT_NL: {
                return this.rune(ANY_RUNE_NOT_NL, 0);
            }
            case ANY_CHAR: {
                return this.rune(ANY_RUNE, 0);
            }
            case BEGIN_LINE: {
                return this.empty(this.reversed ? 2 : 1);
            }
            case END_LINE: {
                return this.empty(this.reversed ? 1 : 2);
            }
            case BEGIN_TEXT: {
                return this.empty(this.reversed ? 8 : 4);
            }
            case END_TEXT: {
                return this.empty(this.reversed ? 4 : 8);
            }
            case WORD_BOUNDARY: {
                return this.empty(16);
            }
            case NO_WORD_BOUNDARY: {
                return this.empty(32);
            }
            case CAPTURE: {
                Frag bra = this.cap(re.cap << 1);
                Frag sub = this.compile(re.subs[0]);
                Frag ket = this.cap(re.cap << 1 | 1);
                return this.cat(this.cat(bra, sub), ket);
            }
            case STAR: {
                return this.star(this.compile(re.subs[0]), (re.flags & 0x20) != 0);
            }
            case PLUS: {
                return this.plus(this.compile(re.subs[0]), (re.flags & 0x20) != 0);
            }
            case QUEST: {
                return this.quest(this.compile(re.subs[0]), (re.flags & 0x20) != 0);
            }
            case CONCAT: {
                if (re.subs.length == 0) {
                    return this.nop();
                }
                Frag f = null;
                for (Regexp sub : re.subs) {
                    Frag f1 = this.compile(sub);
                    f = f == null ? f1 : this.cat(f, f1);
                }
                return f;
            }
            case ALTERNATE: {
                if (re.subs.length == 0) {
                    return this.nop();
                }
                Frag f = null;
                for (Regexp sub : re.subs) {
                    Frag f1 = this.compile(sub);
                    f = f == null ? f1 : this.alt(f, f1);
                }
                return f;
            }
        }
        throw new IllegalStateException("regexp: unhandled case in compile");
    }

    private static class Frag {
        final int i;
        int out;

        Frag() {
            this(0, 0);
        }

        Frag(int i) {
            this(i, 0);
        }

        Frag(int i, int out) {
            this.i = i;
            this.out = out;
        }
    }
}

