/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.regexp.re2j;

import com.github.aaronshan.functions.regexp.re2j.DFA;
import com.github.aaronshan.functions.regexp.re2j.DFAState;
import com.github.aaronshan.functions.regexp.re2j.DFAStateKey;
import com.github.aaronshan.functions.regexp.re2j.Machine;
import com.github.aaronshan.functions.regexp.re2j.MachineInput;
import com.github.aaronshan.functions.regexp.re2j.Prog;
import com.github.aaronshan.functions.regexp.re2j.RE2;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

class DFAMachine
implements Machine {
    private static final int MAX_DFA_KEY = 4;
    private final ConcurrentHashMap<DFAStateKey, DFAState>[] stateCache = new ConcurrentHashMap[4];
    private final AtomicInteger availableStates;
    private final ThreadLocal<DFA>[] dfaCache = new ThreadLocal[4];
    private final RE2 re2;

    DFAMachine(RE2 re2, int maximumNumberOfDFAStates) {
        this.re2 = re2;
        this.availableStates = new AtomicInteger(maximumNumberOfDFAStates);
        for (int i = 0; i < 4; ++i) {
            this.stateCache[i] = new ConcurrentHashMap();
        }
        this.setDfaThreadLocal(RE2.MatchKind.LONGEST_MATCH, true);
        this.setDfaThreadLocal(RE2.MatchKind.LONGEST_MATCH, false);
        this.setDfaThreadLocal(RE2.MatchKind.FIRST_MATCH, true);
        this.setDfaThreadLocal(RE2.MatchKind.FIRST_MATCH, false);
    }

    @Override
    public boolean match(MachineInput in, int pos, RE2.Anchor anchor, int[] submatches) {
        int matchStart;
        int matchEnd;
        boolean wantMatchPosition = true;
        if (submatches.length == 0) {
            wantMatchPosition = false;
        }
        switch (anchor) {
            case UNANCHORED: {
                matchEnd = this.searchDFA(in, pos, in.endPos(), anchor, wantMatchPosition, this.re2.matchKind, false);
                if (matchEnd == -1) {
                    return false;
                }
                if (!wantMatchPosition) {
                    return true;
                }
                matchStart = this.searchDFA(in, pos, matchEnd, RE2.Anchor.ANCHOR_START, true, RE2.MatchKind.LONGEST_MATCH, true);
                if (matchStart != -1) break;
                throw new IllegalStateException("reverse DFA did not found a match");
            }
            case ANCHOR_BOTH: 
            case ANCHOR_START: {
                matchEnd = this.searchDFA(in, pos, in.endPos(), anchor, wantMatchPosition, this.re2.matchKind, false);
                if (matchEnd == -1) {
                    return false;
                }
                matchStart = 0;
                break;
            }
            default: {
                throw new IllegalStateException("bad anchor");
            }
        }
        if (submatches.length == 2) {
            submatches[0] = matchStart;
            submatches[1] = matchEnd;
        } else if (!this.re2.nfaMachine.get().match(in, matchStart, anchor, submatches)) {
            throw new IllegalStateException("NFA inconsistency");
        }
        return true;
    }

    private int searchDFA(MachineInput in, int startPos, int endPos, RE2.Anchor anchor, boolean wantMatchPosition, RE2.MatchKind matchKind, boolean reversed) {
        DFA dfa;
        int match;
        boolean hasCarat;
        boolean bl = hasCarat = reversed ? anchor.isAnchorEnd() : anchor.isAnchorStart();
        if (hasCarat && startPos != 0) {
            return -1;
        }
        boolean anchored = anchor.isAnchorStart();
        boolean endMatch = false;
        if (anchor.isAnchorEnd()) {
            endMatch = true;
            matchKind = RE2.MatchKind.LONGEST_MATCH;
        }
        boolean wantEarliestMatch = false;
        if (!wantMatchPosition && !endMatch) {
            wantEarliestMatch = true;
            matchKind = RE2.MatchKind.LONGEST_MATCH;
        }
        if ((match = (dfa = this.getDfa(matchKind, reversed)).search(in, startPos, endPos, anchored, wantEarliestMatch)) == -1) {
            return -1;
        }
        if (endMatch && (reversed && match != startPos || !reversed && match != endPos)) {
            return -1;
        }
        return match;
    }

    private DFA getDfa(RE2.MatchKind matchKind, boolean reversed) {
        return this.dfaCache[this.dfaKey(matchKind, reversed)].get();
    }

    private int dfaKey(RE2.MatchKind matchKind, boolean reversed) {
        int longestInt = matchKind == RE2.MatchKind.LONGEST_MATCH ? 1 : 0;
        int reversedInt = reversed ? 1 : 0;
        return longestInt | reversedInt << 1;
    }

    private void setDfaThreadLocal(final RE2.MatchKind matchKind, final boolean reversed) {
        final int dfaKey = this.dfaKey(matchKind, reversed);
        final Prog prog = reversed ? this.re2.reverseProg : this.re2.prog;
        this.dfaCache[dfaKey] = new ThreadLocal<DFA>(){

            @Override
            public DFA initialValue() {
                return new DFA(prog, matchKind, reversed, DFAMachine.this.stateCache[dfaKey], DFAMachine.this.availableStates);
            }
        };
    }
}

