/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.regexp.re2j;

class Inst {
    Op op;
    int out;
    int arg;
    byte[] byteRanges;

    Inst(Op op) {
        this.op = op;
    }

    Op op() {
        switch (this.op) {
            case BYTE1: {
                return Op.BYTE;
            }
        }
        return this.op;
    }

    boolean matchByte(byte b) {
        if (this.byteRanges.length == 1) {
            byte b0 = this.byteRanges[0];
            return b == b0;
        }
        int byteInt = b & 0xFF;
        for (int j = 0; j < this.byteRanges.length; j += 2) {
            if (byteInt < (this.byteRanges[j] & 0xFF)) {
                return false;
            }
            if (byteInt > (this.byteRanges[j + 1] & 0xFF)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        switch (this.op) {
            case ALT: {
                return "alt -> " + this.out + ", " + this.arg;
            }
            case ALT_MATCH: {
                return "altmatch -> " + this.out + ", " + this.arg;
            }
            case CAPTURE: {
                return "cap " + this.arg + " -> " + this.out;
            }
            case EMPTY_WIDTH: {
                return "empty " + this.arg + " -> " + this.out;
            }
            case MATCH: {
                return "match";
            }
            case FAIL: {
                return "fail";
            }
            case NOP: {
                return "nop -> " + this.out;
            }
            case BYTE: {
                return "byte " + this.appendBytes() + " -> " + this.out;
            }
            case BYTE1: {
                return "byte1 " + this.appendBytes() + " -> " + this.out;
            }
        }
        throw new IllegalStateException("unhandled case in Inst.toString");
    }

    private String appendBytes() {
        StringBuilder out = new StringBuilder();
        if (this.byteRanges.length == 1) {
            out.append(this.byteRanges[0] & 0xFF);
        } else {
            for (int i = 0; i < this.byteRanges.length; i += 2) {
                out.append("[").append(this.byteRanges[i] & 0xFF).append(",").append(this.byteRanges[i + 1] & 0xFF).append("]");
                if (i >= this.byteRanges.length - 2) continue;
                out.append(";");
            }
        }
        return out.toString();
    }

    static enum Op {
        ALT,
        ALT_MATCH,
        CAPTURE,
        EMPTY_WIDTH,
        FAIL,
        MATCH,
        NOP,
        BYTE,
        BYTE1;

    }
}

