/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.regexp.re2j;

import com.github.aaronshan.functions.regexp.re2j.Inst;
import com.github.aaronshan.functions.regexp.re2j.Machine;
import com.github.aaronshan.functions.regexp.re2j.MachineInput;
import com.github.aaronshan.functions.regexp.re2j.Prog;
import com.github.aaronshan.functions.regexp.re2j.RE2;
import com.github.aaronshan.functions.regexp.re2j.Utils;
import java.util.Arrays;

class NFAMachine
implements Machine {
    private static final int INITIAL_POOL_SIZE = 10;
    private final Prog prog;
    private final Inst[] instructions;
    private final Queue q0;
    private final Queue q1;
    private RE2 re2;
    private Thread[] pool = new Thread[10];
    private int poolSize = 0;
    private boolean matched;
    private int[] matchcap;

    NFAMachine(RE2 re2) {
        this.prog = re2.prog;
        this.instructions = this.prog.getInst();
        this.re2 = re2;
        this.q0 = new Queue(this.prog.numInst());
        this.q1 = new Queue(this.prog.numInst());
        this.matchcap = new int[0];
    }

    private Thread alloc(Inst inst) {
        Thread t = this.poolSize > 0 ? this.pool[--this.poolSize] : new Thread(this.matchcap.length);
        t.inst = inst;
        return t;
    }

    private void free(Thread t) {
        if (this.poolSize >= this.pool.length) {
            Thread[] newPool = new Thread[this.pool.length * 2];
            System.arraycopy(this.pool, 0, newPool, 0, this.pool.length);
            this.pool = newPool;
        }
        this.pool[this.poolSize++] = t;
    }

    @Override
    public boolean match(MachineInput in, int pos, RE2.Anchor anchor, int[] submatches) {
        this.init(submatches.length);
        int startCond = this.re2.cond;
        if (startCond == -1) {
            return false;
        }
        if (anchor.isAnchorStart() && pos != 0) {
            return false;
        }
        this.matched = false;
        Arrays.fill(this.matchcap, -1);
        Queue runq = this.q0;
        Queue nextq = this.q1;
        byte b = in.getByte(pos);
        byte b1 = in.getByte(pos + 1);
        int flag = pos == 0 ? Utils.emptyOpContext((byte)-1, b) : Utils.emptyOpContext(in.getByte(pos - 1), b);
        while (true) {
            if (runq.isEmpty()) {
                if ((startCond & 4) != 0 && pos != 0 || this.matched) break;
                if (this.re2.prefixUTF8.length() > 0) {
                    int advance = in.index(this.re2, pos);
                    if (advance < 0) break;
                    b = in.getByte(pos += advance);
                    b1 = in.getByte(pos + 1);
                }
            }
            if (!(this.matched || pos != 0 && !anchor.isUnanchored() || b != -1 && !Utils.isRuneStart(b))) {
                if (this.matchcap.length > 0) {
                    this.matchcap[0] = pos;
                }
                this.add(runq, this.prog.start, pos, this.matchcap, flag, null);
            }
            flag = Utils.emptyOpContext(b, b1);
            this.step(runq, nextq, pos, pos + 1, b, flag, anchor, pos == in.endPos());
            if (b == -1 || this.matchcap.length == 0 && this.matched) break;
            b = b1;
            b1 = in.getByte(++pos + 1);
            Queue tmpq = runq;
            runq = nextq;
            nextq = tmpq;
        }
        nextq.clear();
        System.arraycopy(this.matchcap, 0, submatches, 0, submatches.length);
        return this.matched;
    }

    private void init(int ncap) {
        if (this.matchcap.length >= ncap) {
            return;
        }
        for (int i = 0; i < this.poolSize; ++i) {
            this.pool[i].cap = new int[ncap];
        }
        this.matchcap = new int[ncap];
    }

    private void step(Queue runq, Queue nextq, int pos, int nextPos, byte b, int nextCond, RE2.Anchor anchor, boolean atEnd) {
        boolean longest = this.re2.matchKind == RE2.MatchKind.LONGEST_MATCH;
        for (int j = 0; j < runq.size; ++j) {
            Thread t;
            Queue.Entry entry = runq.dense[j];
            if (entry == null || (t = entry.thread) == null) continue;
            if (longest && this.matched && t.cap.length > 0 && this.matchcap[0] < t.cap[0]) {
                this.free(t);
                continue;
            }
            Inst i = t.inst;
            boolean add = false;
            switch (i.op) {
                case MATCH: {
                    if (anchor.isAnchorBoth() && !atEnd) break;
                    if (!(t.cap.length <= 0 || longest && this.matched && this.matchcap[1] >= pos)) {
                        t.cap[1] = pos;
                        System.arraycopy(t.cap, 0, this.matchcap, 0, t.cap.length);
                    }
                    if (!longest) {
                        for (int k = j + 1; k < runq.size; ++k) {
                            Queue.Entry d = runq.dense[k];
                            if (d.thread == null) continue;
                            this.free(d.thread);
                        }
                        runq.size = 0;
                    }
                    this.matched = true;
                    break;
                }
                case BYTE: {
                    add = i.matchByte(b);
                    break;
                }
                case BYTE1: {
                    add = b == i.byteRanges[0];
                    break;
                }
                default: {
                    throw new IllegalStateException("bad inst");
                }
            }
            if (add) {
                t = this.add(nextq, i.out, nextPos, t.cap, nextCond, t);
            }
            if (t == null) continue;
            this.free(t);
        }
        runq.size = 0;
    }

    private Thread add(Queue q, int pc, int pos, int[] cap, int cond, Thread t) {
        if (pc == 0) {
            return t;
        }
        if (q.contains(pc)) {
            return t;
        }
        Queue.Entry d = q.add(pc);
        Inst inst = this.instructions[pc];
        switch (inst.op()) {
            default: {
                throw new IllegalStateException("unhandled");
            }
            case FAIL: {
                break;
            }
            case ALT: 
            case ALT_MATCH: {
                t = this.add(q, inst.out, pos, cap, cond, t);
                t = this.add(q, inst.arg, pos, cap, cond, t);
                break;
            }
            case EMPTY_WIDTH: {
                if ((inst.arg & ~cond) != 0) break;
                t = this.add(q, inst.out, pos, cap, cond, t);
                break;
            }
            case NOP: {
                t = this.add(q, inst.out, pos, cap, cond, t);
                break;
            }
            case CAPTURE: {
                if (inst.arg < cap.length) {
                    int opos = cap[inst.arg];
                    cap[inst.arg] = pos;
                    this.add(q, inst.out, pos, cap, cond, null);
                    cap[inst.arg] = opos;
                    break;
                }
                t = this.add(q, inst.out, pos, cap, cond, t);
                break;
            }
            case MATCH: 
            case BYTE: 
            case BYTE1: {
                if (t == null) {
                    t = this.alloc(inst);
                } else {
                    t.inst = inst;
                }
                if (cap.length > 0 && t.cap != cap) {
                    System.arraycopy(cap, 0, t.cap, 0, cap.length);
                }
                d.thread = t;
                t = null;
            }
        }
        return t;
    }

    private class Queue {
        final Entry[] dense;
        final int[] sparse;
        int size;

        Queue(int n) {
            this.sparse = new int[n];
            this.dense = new Entry[n];
        }

        boolean contains(int pc) {
            int j = this.sparse[pc];
            if (j >= this.size) {
                return false;
            }
            Entry d = this.dense[j];
            return d != null && d.pc == pc;
        }

        boolean isEmpty() {
            return this.size == 0;
        }

        Entry add(int pc) {
            int j;
            this.sparse[pc] = j = this.size++;
            Entry e = this.dense[j];
            if (e == null) {
                e = this.dense[j] = new Entry();
            }
            e.thread = null;
            e.pc = pc;
            return e;
        }

        void clear() {
            for (int i = 0; i < this.size; ++i) {
                Entry entry = this.dense[i];
                if (entry == null || entry.thread == null) continue;
                NFAMachine.this.free(entry.thread);
            }
            this.size = 0;
        }

        public String toString() {
            StringBuilder out = new StringBuilder();
            out.append('{');
            for (int i = 0; i < this.size; ++i) {
                if (i != 0) {
                    out.append(", ");
                }
                out.append(this.dense[i].pc);
            }
            out.append('}');
            return out.toString();
        }

        class Entry {
            int pc;
            Thread thread;

            Entry() {
            }
        }
    }

    private static class Thread {
        int[] cap;
        Inst inst;

        Thread(int n) {
            this.cap = new int[n];
        }
    }
}

