/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.regexp.re2j;

import com.github.aaronshan.functions.regexp.re2j.Parser;
import com.github.aaronshan.functions.regexp.re2j.Regexp;
import java.util.ArrayList;

class Simplify {
    private Simplify() {
    }

    static Regexp simplify(Regexp re) {
        if (re == null) {
            return null;
        }
        switch (re.op) {
            case CAPTURE: 
            case CONCAT: 
            case ALTERNATE: {
                Regexp nre = re;
                for (int i = 0; i < re.subs.length; ++i) {
                    Regexp sub = re.subs[i];
                    Regexp nsub = Simplify.simplify(sub);
                    if (nre == re && nsub != sub) {
                        nre = new Regexp(re);
                        nre.runes = null;
                        nre.subs = Parser.subarray(re.subs, 0, re.subs.length);
                    }
                    if (nre == re) continue;
                    nre.subs[i] = nsub;
                }
                return nre;
            }
            case STAR: 
            case PLUS: 
            case QUEST: {
                Regexp sub = Simplify.simplify(re.subs[0]);
                return Simplify.simplify1(re.op, re.flags, sub, re);
            }
            case REPEAT: {
                if (re.min == 0 && re.max == 0) {
                    return new Regexp(Regexp.Op.EMPTY_MATCH);
                }
                Regexp sub = Simplify.simplify(re.subs[0]);
                if (re.max == -1) {
                    if (re.min == 0) {
                        return Simplify.simplify1(Regexp.Op.STAR, re.flags, sub, null);
                    }
                    if (re.min == 1) {
                        return Simplify.simplify1(Regexp.Op.PLUS, re.flags, sub, null);
                    }
                    Regexp nre = new Regexp(Regexp.Op.CONCAT);
                    ArrayList<Regexp> subs = new ArrayList<Regexp>();
                    for (int i = 0; i < re.min - 1; ++i) {
                        subs.add(sub);
                    }
                    subs.add(Simplify.simplify1(Regexp.Op.PLUS, re.flags, sub, null));
                    nre.subs = subs.toArray(new Regexp[subs.size()]);
                    return nre;
                }
                if (re.min == 1 && re.max == 1) {
                    return sub;
                }
                ArrayList<Regexp> prefixSubs = null;
                if (re.min > 0) {
                    prefixSubs = new ArrayList<Regexp>();
                    for (int i = 0; i < re.min; ++i) {
                        prefixSubs.add(sub);
                    }
                }
                if (re.max > re.min) {
                    Regexp suffix = Simplify.simplify1(Regexp.Op.QUEST, re.flags, sub, null);
                    for (int i = re.min + 1; i < re.max; ++i) {
                        Regexp nre2 = new Regexp(Regexp.Op.CONCAT);
                        nre2.subs = new Regexp[]{sub, suffix};
                        suffix = Simplify.simplify1(Regexp.Op.QUEST, re.flags, nre2, null);
                    }
                    if (prefixSubs == null) {
                        return suffix;
                    }
                    prefixSubs.add(suffix);
                }
                if (prefixSubs != null) {
                    Regexp prefix = new Regexp(Regexp.Op.CONCAT);
                    prefix.subs = prefixSubs.toArray(new Regexp[prefixSubs.size()]);
                    return prefix;
                }
                return new Regexp(Regexp.Op.NO_MATCH);
            }
        }
        return re;
    }

    private static Regexp simplify1(Regexp.Op op, int flags, Regexp sub, Regexp re) {
        if (sub.op == Regexp.Op.EMPTY_MATCH) {
            return sub;
        }
        if (op == sub.op && (flags & 0x20) == (sub.flags & 0x20)) {
            return sub;
        }
        if (re != null && re.op == op && (re.flags & 0x20) == (flags & 0x20) && sub == re.subs[0]) {
            return re;
        }
        re = new Regexp(op);
        re.flags = flags;
        re.subs = new Regexp[]{sub};
        return re;
    }
}

