/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.regexp.re2j;

import com.github.aaronshan.functions.regexp.re2j.Matcher;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;

final class SliceUtils {
    private SliceUtils() {
    }

    static void appendReplacement(SliceOutput so, Slice replacement, Matcher matcher) {
        int idx = 0;
        while (idx < replacement.length()) {
            byte nextByte = replacement.getByte(idx);
            if (nextByte == 36) {
                Slice group;
                int backref;
                if (++idx == replacement.length()) {
                    throw new IllegalArgumentException("Illegal replacement sequence: " + replacement.toStringUtf8());
                }
                nextByte = replacement.getByte(idx);
                if (nextByte == 123) {
                    int startCursor = ++idx;
                    while (idx < replacement.length() && (nextByte = replacement.getByte(idx)) != 125) {
                        ++idx;
                    }
                    String groupName = replacement.slice(startCursor, idx - startCursor).toStringUtf8();
                    Integer namedGroupIndex = matcher.pattern().re2().namedGroupIndexes.get(groupName);
                    if (namedGroupIndex == null) {
                        throw new IndexOutOfBoundsException("Illegal replacement sequence: unknown group " + groupName);
                    }
                    backref = namedGroupIndex;
                    ++idx;
                } else {
                    int nextDigit;
                    backref = nextByte - 48;
                    if (backref < 0 || backref > 9) {
                        throw new IllegalArgumentException("Illegal replacement sequence: " + replacement.toStringUtf8());
                    }
                    if (matcher.groupCount() < backref) {
                        throw new IndexOutOfBoundsException("Illegal replacement sequence: unknown group " + backref);
                    }
                    ++idx;
                    while (idx < replacement.length() && (nextDigit = replacement.getByte(idx) - 48) >= 0 && nextDigit <= 9) {
                        int newBackref = backref * 10 + nextDigit;
                        if (matcher.groupCount() < newBackref) break;
                        backref = newBackref;
                        ++idx;
                    }
                }
                if ((group = matcher.group(backref)) == null) continue;
                so.writeBytes(group);
                continue;
            }
            if (nextByte == 92) {
                if (++idx == replacement.length()) {
                    throw new IllegalArgumentException("Illegal replacement sequence: " + replacement.toStringUtf8());
                }
                nextByte = replacement.getByte(idx);
            }
            so.appendByte((int)nextByte);
            ++idx;
        }
    }
}

