/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.regexp.re2j;

import com.github.aaronshan.functions.regexp.re2j.UnicodeTables;
import java.nio.charset.Charset;

class Unicode {
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    static final int RUNE_SELF = 128;
    static final int MAX_RUNE = 0x10FFFF;
    static final int MAX_ASCII = 127;
    static final int MAX_LATIN1 = 255;
    static final int MIN_FOLD = 65;
    static final int MAX_FOLD = 66639;
    static final int UTF_MAX = 4;
    private static final int MAX_CASE = 3;
    private static final int REPLACEMENT_CHAR = 65533;

    private Unicode() {
    }

    private static boolean is32(int[][] ranges, int r) {
        int lo = 0;
        int hi = ranges.length;
        while (lo < hi) {
            int m = lo + (hi - lo) / 2;
            int[] range = ranges[m];
            if (range[0] <= r && r <= range[1]) {
                return (r - range[0]) % range[2] == 0;
            }
            if (r < range[0]) {
                hi = m;
                continue;
            }
            lo = m + 1;
        }
        return false;
    }

    private static boolean is(int[][] ranges, int r) {
        if (r <= 255) {
            for (int[] range : ranges) {
                if (r > range[1]) continue;
                if (r < range[0]) {
                    return false;
                }
                return (r - range[0]) % range[2] == 0;
            }
            return false;
        }
        return ranges.length > 0 && r >= ranges[0][0] && Unicode.is32(ranges, r);
    }

    static byte[] codePointToUtf8(int codePoint) {
        return new String(Character.toChars(codePoint)).getBytes(UTF_8);
    }

    static int maxRune(int len) {
        int b = len == 1 ? 7 : 8 - (len + 1) + 6 * (len - 1);
        return (1 << b) - 1;
    }

    static boolean isUpper(int r) {
        if (r <= 255) {
            return Character.isUpperCase((char)r);
        }
        return Unicode.is(UnicodeTables.Upper, r);
    }

    static boolean isLower(int r) {
        if (r <= 255) {
            return Character.isLowerCase((char)r);
        }
        return Unicode.is(UnicodeTables.Lower, r);
    }

    static boolean isTitle(int r) {
        if (r <= 255) {
            return false;
        }
        return Unicode.is(UnicodeTables.Title, r);
    }

    static boolean isPrint(int r) {
        if (r <= 255) {
            return r >= 32 && r < 127 || r >= 161 && r != 173;
        }
        return Unicode.is(UnicodeTables.L, r) || Unicode.is(UnicodeTables.M, r) || Unicode.is(UnicodeTables.N, r) || Unicode.is(UnicodeTables.P, r) || Unicode.is(UnicodeTables.S, r);
    }

    private static int to(int kase, int r, int[][] caseRange) {
        if (kase < 0 || 3 <= kase) {
            return 65533;
        }
        int lo = 0;
        int hi = caseRange.length;
        while (lo < hi) {
            int m = lo + (hi - lo) / 2;
            int[] cr = caseRange[m];
            int crlo = cr[0];
            int crhi = cr[1];
            if (crlo <= r && r <= crhi) {
                int delta = cr[2 + kase];
                if (delta > 0x10FFFF) {
                    return crlo + (r - crlo & 0xFFFFFFFE | kase & 1);
                }
                return r + delta;
            }
            if (r < crlo) {
                hi = m;
                continue;
            }
            lo = m + 1;
        }
        return r;
    }

    private static int to(int kase, int r) {
        return Unicode.to(kase, r, UnicodeTables.CASE_RANGES);
    }

    static int toUpper(int r) {
        if (r <= 127) {
            if (97 <= r && r <= 122) {
                r -= 32;
            }
            return r;
        }
        return Unicode.to(0, r);
    }

    static int toLower(int r) {
        if (r <= 127) {
            if (65 <= r && r <= 90) {
                r += 32;
            }
            return r;
        }
        return Unicode.to(1, r);
    }

    static int simpleFold(int r) {
        int lo = 0;
        int hi = UnicodeTables.CASE_ORBIT.length;
        while (lo < hi) {
            int m = lo + (hi - lo) / 2;
            if (UnicodeTables.CASE_ORBIT[m][0] < r) {
                lo = m + 1;
                continue;
            }
            hi = m;
        }
        if (lo < UnicodeTables.CASE_ORBIT.length && UnicodeTables.CASE_ORBIT[lo][0] == r) {
            return UnicodeTables.CASE_ORBIT[lo][1];
        }
        int l = Unicode.toLower(r);
        if (l != r) {
            return l;
        }
        return Unicode.toUpper(r);
    }
}

