/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.string;

import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.Text;

@Description(name="pinyin", value="_FUNC_(string) - get pinyin by given chinese.", extended="Example:\n > select _FUNC_(string) from src;")
public class UDFChineseToPinYin
extends UDF {
    private Text result = new Text();

    public Text evaluate(Text chinese) {
        if (chinese == null) {
            return null;
        }
        this.result.set(this.ConvertToPinyin(chinese.toString()));
        return this.result;
    }

    public String ConvertToPinyin(String name) {
        HanyuPinyinOutputFormat pyFormat = new HanyuPinyinOutputFormat();
        pyFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        pyFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        pyFormat.setVCharType(HanyuPinyinVCharType.WITH_V);
        String result = null;
        try {
            result = PinyinHelper.toHanyuPinyinString((String)name, (HanyuPinyinOutputFormat)pyFormat, (String)"");
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            return null;
        }
        return result;
    }
}

