/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.string;

import com.github.aaronshan.functions.utils.Failures;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.airlift.slice.Slices;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;

@Description(name="codepoint", value="_FUNC_(string) - returns Unicode code point of a single character string.", extended="Example:\n > select _FUNC_(string) from src;")
public class UDFCodePoint
extends UDF {
    private LongWritable result = new LongWritable();

    public LongWritable evaluate(Text text) throws HiveException {
        if (text == null) {
            return null;
        }
        Slice slice = Slices.utf8Slice((String)text.toString());
        Failures.checkCondition(SliceUtf8.countCodePoints((Slice)slice) == 1, "Input string must be a single character string", new Object[0]);
        this.result.set((long)SliceUtf8.getCodePointAt((Slice)slice, (int)0));
        return this.result;
    }
}

