/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.string;

import com.github.aaronshan.functions.utils.Failures;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.airlift.slice.Slices;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;

@Description(name="hamming_distance", value="_FUNC_(string, string) - computes Hamming distance between two strings.", extended="Example:\n > select _FUNC_(string, string) from src;")
public class UDFStringHammingDistance
extends UDF {
    private LongWritable result = new LongWritable(0L);

    public LongWritable evaluate(Text leftText, Text rightText) throws HiveException {
        int rightPosition;
        int codePointRight;
        int codePointLeft;
        if (leftText == null || rightText == null) {
            return this.result;
        }
        Slice left = Slices.utf8Slice((String)leftText.toString());
        Slice right = Slices.utf8Slice((String)rightText.toString());
        int distance = 0;
        int leftPosition = 0;
        for (rightPosition = 0; leftPosition < left.length() && rightPosition < right.length(); leftPosition += codePointLeft > 0 ? SliceUtf8.lengthOfCodePoint((int)codePointLeft) : -codePointLeft, rightPosition += codePointRight > 0 ? SliceUtf8.lengthOfCodePoint((int)codePointRight) : -codePointRight) {
            codePointLeft = SliceUtf8.tryGetCodePointAt((Slice)left, (int)leftPosition);
            if (codePointLeft == (codePointRight = SliceUtf8.tryGetCodePointAt((Slice)right, (int)rightPosition))) continue;
            ++distance;
        }
        Failures.checkCondition(leftPosition == left.length() && rightPosition == right.length(), "The input strings to hamming_distance function must have the same length", new Object[0]);
        this.result.set((long)distance);
        return this.result;
    }
}

