/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.string;

import java.text.Normalizer;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.io.Text;

@Description(name="normalize", value="_FUNC_(string, string) - transforms the string to normalized form.", extended="Example:\n > select _FUNC_(string, form_str) from src;")
public class UDFStringNormalize
extends UDF {
    private Text result = new Text();

    public Text evaluate(Text text, Text form) throws HiveException {
        Normalizer.Form targetForm;
        if (text == null) {
            return null;
        }
        try {
            targetForm = Normalizer.Form.valueOf(form.toString());
        }
        catch (IllegalArgumentException e) {
            throw new HiveException("Normalization form must be one of [NFD, NFC, NFKD, NFKC]");
        }
        this.result.set(Normalizer.normalize(text.toString(), targetForm));
        return this.result;
    }
}

