/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.string;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;

@Description(name="strpos", value="_FUNC_(string, substring) - returns index of first occurrence of a substring (or 0 if not found).", extended="Example:\n > select _FUNC_(string, substring) from src;")
public class UDFStringPosition
extends UDF {
    private LongWritable result = new LongWritable(0L);

    public LongWritable evaluate(Text text, Text subText) {
        if (text == null || subText == null) {
            return this.result;
        }
        if (subText.getLength() == 1) {
            this.result.set(1L);
            return this.result;
        }
        int index = text.toString().indexOf(subText.toString());
        if (index < 0) {
            return this.result;
        }
        this.result.set((long)(index + 1));
        return this.result;
    }
}

