/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.string;

import com.github.aaronshan.functions.utils.Failures;
import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;

@Description(name="split_to_multimap", value="_FUNC_(string, string, string) - creates a multimap by splitting a string into key/value pairs.", extended="Example:\n > select _FUNC_('a=123,b=.4,c=,=d', ',', '=') from src;")
public class UDFStringSplitToMultimap
extends GenericUDF {
    private static final int ARG_COUNT = 3;
    HashMap<String, List<String>> result = new HashMap();

    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 3) {
            throw new UDFArgumentLengthException("The function split_to_multimap(string, string, string) takes exactly 3 arguments.");
        }
        for (int i = 0; i < 3; ++i) {
            if (ObjectInspectorUtils.compareTypes((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)arguments[i])) continue;
            throw new UDFArgumentTypeException(i, "\"" + PrimitiveObjectInspectorFactory.javaStringObjectInspector.getTypeName() + "\" expected at function split_to_multimap, but \"" + arguments[i].getTypeName() + "\" is found");
        }
        JavaStringObjectInspector mapKeyOI = PrimitiveObjectInspectorFactory.javaStringObjectInspector;
        StandardListObjectInspector mapValueOI = ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector);
        return ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)mapKeyOI, (ObjectInspector)mapValueOI);
    }

    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        String string = (String)arguments[0].get();
        String entryDelimiter = (String)arguments[1].get();
        String keyValueDelimiter = (String)arguments[2].get();
        Failures.checkCondition(entryDelimiter.length() > 0, "entryDelimiter is empty", new Object[0]);
        Failures.checkCondition(keyValueDelimiter.length() > 0, "keyValueDelimiter is empty", new Object[0]);
        Failures.checkCondition(!entryDelimiter.equals(keyValueDelimiter), "entryDelimiter and keyValueDelimiter must not be the same", new Object[0]);
        if (string == null) {
            return null;
        }
        ArrayListMultimap multimap = ArrayListMultimap.create();
        this.result.clear();
        List list = Splitter.on((String)entryDelimiter).splitToList((CharSequence)string);
        for (String str : list) {
            String[] fields = str.split(keyValueDelimiter);
            if (fields.length != 2) {
                throw new HiveException("Key-value delimiter must appear exactly once in each entry. Bad input: " + string);
            }
            multimap.put((Object)fields[0], (Object)fields[1]);
        }
        for (String key : multimap.keySet()) {
            this.result.put(key, Lists.newArrayList((Iterable)multimap.get((Object)key)));
        }
        return this.result;
    }

    public String getDisplayString(String[] strings) {
        assert (strings.length == 3);
        return "split_to_multimap(" + strings[0] + ", " + strings[1] + ", " + strings[2] + ")";
    }
}

