/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.url;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.Text;

@Description(name="url_decode", value="_FUNC_(value) - Unescape the URL encoded value. This function is the inverse of url_encode()", extended="Example:\n > select _FUNC_(value) from src;")
public class UDFUrlDecode
extends UDF {
    private Text result = new Text();

    public Text evaluate(String value) {
        if (value == null) {
            return null;
        }
        try {
            this.result.set(URLDecoder.decode(value, "UTF-8"));
            return this.result;
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }
}

