/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.aaronshan.functions.model.ChinaIdArea;
import com.github.aaronshan.functions.utils.ConfigUtils;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

public class CardUtils {
    private static final Map<String, ChinaIdArea> chinaIdAreaMap = ConfigUtils.getIdCardMap();
    private static int[] weight = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
    private static char[] validate = new char[]{'1', '0', 'X', '9', '8', '7', '6', '5', '4', '3', '2'};

    private static ChinaIdArea getCardValue(String card) {
        if (card == null) {
            return null;
        }
        int cardLength = card.length();
        if (cardLength != 15 && cardLength != 18) {
            return null;
        }
        String cardPrefix = card.substring(0, 6);
        if (chinaIdAreaMap.containsKey(cardPrefix)) {
            return chinaIdAreaMap.get(cardPrefix);
        }
        return null;
    }

    public static String getIdCardProvince(String card) {
        ChinaIdArea chinaIdArea = CardUtils.getCardValue(card);
        if (chinaIdArea != null) {
            return chinaIdArea.getProvince();
        }
        return null;
    }

    public static String getIdCardCity(String card) {
        ChinaIdArea chinaIdArea = CardUtils.getCardValue(card);
        if (chinaIdArea != null) {
            return chinaIdArea.getCity();
        }
        return null;
    }

    public static String getIdCardArea(String card) {
        ChinaIdArea chinaIdArea = CardUtils.getCardValue(card);
        if (chinaIdArea != null) {
            return chinaIdArea.getArea();
        }
        return null;
    }

    public static String getIdCardBirthday(String card) {
        if (CardUtils.isValidIdCard(card)) {
            int cardLength = card.length();
            if (cardLength == 15) {
                return "19" + card.substring(6, 12);
            }
            return card.substring(6, 14);
        }
        return null;
    }

    public static String getIdCardGender(String card) {
        if (CardUtils.isValidIdCard(card)) {
            int cardLength = card.length();
            int genderValue = cardLength == 15 ? card.charAt(15) - 48 : card.charAt(17) - 48;
            if (genderValue % 2 == 0) {
                return "\u5973";
            }
            return "\u7537";
        }
        return null;
    }

    public static boolean isValidIdCard(String card) {
        if (!Strings.isNullOrEmpty((String)card)) {
            int cardLength = card.length();
            if (cardLength == 18) {
                String card17 = card.substring(0, 17);
                if (!card17.matches("[0-9]+")) {
                    return false;
                }
                char validateCode = CardUtils.getValidateCode(card17);
                if (validateCode == card.charAt(17)) {
                    return true;
                }
            } else if (cardLength == 15) {
                return card.matches("[0-9]+") && CardUtils.getCardValue(card) != null;
            }
        }
        return false;
    }

    private static char getValidateCode(String card17) {
        int sum = 0;
        int mode = 0;
        for (int i = 0; i < card17.length(); ++i) {
            sum += (card17.charAt(i) - 48) * weight[i];
        }
        mode = sum % 11;
        return validate[mode];
    }

    public static String getJsonOfChinaIdCard(String card) {
        try {
            HashMap map = Maps.newHashMap();
            ChinaIdArea chinaIdArea = CardUtils.getCardValue(card);
            if (chinaIdArea == null) {
                map.put("province", null);
                map.put("city", null);
                map.put("area", null);
            } else {
                map.put("province", chinaIdArea.getProvince());
                map.put("city", chinaIdArea.getCity());
                map.put("area", chinaIdArea.getArea());
            }
            map.put("gender", CardUtils.getIdCardGender(card));
            map.put("valid", CardUtils.isValidIdCard(card));
            ObjectMapper mapper = new ObjectMapper();
            return mapper.writeValueAsString((Object)map);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }
}

