/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.utils;

import com.github.aaronshan.functions.model.ChinaIdArea;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Closer;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigUtils {
    private static Logger logger = LoggerFactory.getLogger(ConfigUtils.class);

    public static List<String> loadFile(String fileName) throws IOException {
        ArrayList strings = Lists.newArrayList();
        Closer closer = Closer.create();
        try {
            String line;
            InputStream inputStream = ConfigUtils.class.getResourceAsStream(fileName);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            closer.register((Closeable)bufferedReader);
            while ((line = bufferedReader.readLine()) != null) {
                if (Strings.isNullOrEmpty((String)line) || line.startsWith("#")) continue;
                strings.add(line);
            }
        }
        catch (IOException e) {
            logger.error("loadFile {} error. error is {}.", (Object)fileName, (Object)e);
            throw e;
        }
        finally {
            closer.close();
        }
        return strings;
    }

    public static Map<String, ChinaIdArea> getIdCardMap() {
        String fileName = "/china_p_c_a.config";
        HashMap map = Maps.newHashMap();
        try {
            List<String> list = ConfigUtils.loadFile(fileName);
            for (String line : list) {
                String[] results = line.split("\t", 4);
                map.put(results[0], new ChinaIdArea(results[1], results[2], results[3]));
            }
        }
        catch (IOException e) {
            logger.error("get china id card map error. error is {}.", (Throwable)e);
            return map;
        }
        return map;
    }

    public static Map<String, String> getDayMap() {
        String fileName = "/china_day_type.config";
        HashMap map = Maps.newHashMap();
        try {
            List<String> list = ConfigUtils.loadFile(fileName);
            for (String line : list) {
                String[] results = line.split("\t", 2);
                map.put(results[0], results[1]);
            }
        }
        catch (IOException e) {
            logger.error("get day map error. error is {}.", (Throwable)e);
            return map;
        }
        return map;
    }
}

