/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import java.util.HashMap;

public class GeoUtils {
    private static final double xPi = 52.35987755982988;
    private static final double a = 6378245.0;
    private static final double ee = 0.006693421622965943;
    private static final double radius = 6371000.0;

    public static double WGS84Distance(double lat1, double lng1, double lat2, double lng2) {
        double dLat = Math.toRadians(lat2 - lat1);
        double dLng = Math.toRadians(lng2 - lng1);
        double a = Math.sin(dLat / 2.0) * Math.sin(dLat / 2.0) + Math.cos(Math.toRadians(lat1)) * Math.cos(Math.toRadians(lat2)) * Math.sin(dLng / 2.0) * Math.sin(dLng / 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        return 6371000.0 * c;
    }

    public static String GCJ02ToBD09(double gcjLat, double gcjLng) {
        double x = gcjLng;
        double y = gcjLat;
        double z = Math.sqrt(x * x + y * y) + 2.0E-5 * Math.sin(y * 52.35987755982988);
        double theta = Math.atan2(y, x) + 3.0E-6 * Math.cos(x * 52.35987755982988);
        double bdLng = z * Math.cos(theta) + 0.0065;
        double bdLat = z * Math.sin(theta) + 0.006;
        return GeoUtils.getJsonOfCoordinate(bdLat, bdLng);
    }

    public static String BD09ToGCJ02(double bdLat, double bdLng) {
        double x = bdLng - 0.0065;
        double y = bdLat - 0.006;
        double z = Math.sqrt(x * x + y * y) - 2.0E-5 * Math.sin(y * 52.35987755982988);
        double theta = Math.atan2(y, x) - 3.0E-6 * Math.cos(x * 52.35987755982988);
        double gcjLng = z * Math.cos(theta);
        double gcjLat = z * Math.sin(theta);
        return GeoUtils.getJsonOfCoordinate(gcjLat, gcjLng);
    }

    public static String WGS84ToGCJ02(double wgsLat, double wgsLng) {
        if (GeoUtils.outOfChina(wgsLat, wgsLng)) {
            return GeoUtils.getJsonOfCoordinate(wgsLat, wgsLng);
        }
        double[] delta = GeoUtils.delta(wgsLat, wgsLng);
        double gcjLat = wgsLat + delta[0];
        double gcjLng = wgsLng + delta[1];
        return GeoUtils.getJsonOfCoordinate(gcjLat, gcjLng);
    }

    public static String GCJ02ToWGS84(double gcjLat, double gcjLng) {
        if (GeoUtils.outOfChina(gcjLat, gcjLng)) {
            return GeoUtils.getJsonOfCoordinate(gcjLat, gcjLng);
        }
        double[] delta = GeoUtils.delta(gcjLat, gcjLng);
        double wgsLat = gcjLat - delta[0];
        double wgsLng = gcjLng - delta[1];
        return GeoUtils.getJsonOfCoordinate(wgsLat, wgsLng);
    }

    public static String GCJ02ExtractWGS84(double gcjLat, double gcjLng) {
        double initDelta = 0.01;
        double threshold = 1.0E-6;
        double dLat = initDelta;
        double dLng = initDelta;
        double mLat = gcjLat - dLat;
        double mLng = gcjLng - dLng;
        double pLat = gcjLat + dLat;
        double pLng = gcjLng + dLng;
        double wgsLat = 0.0;
        double wgsLng = 0.0;
        for (int i = 0; i < 30; ++i) {
            wgsLat = (mLat + pLat) / 2.0;
            wgsLng = (mLng + pLng) / 2.0;
            double[] tmp = GeoUtils.wgs2gcj(wgsLat, wgsLng);
            double tmpLat = tmp[0];
            double tmpLng = tmp[1];
            dLat = tmpLat - gcjLat;
            dLng = tmpLng - gcjLng;
            if (Math.abs(dLat) < threshold && Math.abs(dLng) < threshold) {
                return GeoUtils.getJsonOfCoordinate(wgsLat, wgsLng);
            }
            if (dLat > 0.0) {
                pLat = wgsLat;
            } else {
                mLat = wgsLat;
            }
            if (dLng > 0.0) {
                pLng = wgsLng;
                continue;
            }
            mLng = wgsLng;
        }
        return GeoUtils.getJsonOfCoordinate(wgsLat, wgsLng);
    }

    private static double[] wgs2gcj(double wgsLat, double wgsLng) {
        double[] result = new double[2];
        if (GeoUtils.outOfChina(wgsLat, wgsLng)) {
            result[0] = wgsLat;
            result[1] = wgsLng;
            return result;
        }
        double[] delta = GeoUtils.delta(wgsLat, wgsLng);
        double gcjLat = wgsLat + delta[0];
        double gcjLng = wgsLng + delta[1];
        result[0] = gcjLat;
        result[1] = gcjLng;
        return result;
    }

    private static boolean outOfChina(double lat, double lng) {
        if (lng < 72.004 || lng > 137.8347) {
            return true;
        }
        return lat < 0.8293 || lat > 55.8271;
    }

    private static double[] delta(double lat, double lng) {
        double[] delta = new double[2];
        double dLat = GeoUtils.transformLat(lng - 105.0, lat - 35.0);
        double dLng = GeoUtils.transformLng(lng - 105.0, lat - 35.0);
        double radLat = lat / 180.0 * Math.PI;
        double magic = Math.sin(radLat);
        magic = 1.0 - 0.006693421622965943 * magic * magic;
        double sqrtMagic = Math.sqrt(magic);
        delta[0] = dLat * 180.0 / (6335552.717000426 / (magic * sqrtMagic) * Math.PI);
        delta[1] = dLng * 180.0 / (6378245.0 / sqrtMagic * Math.cos(radLat) * Math.PI);
        return delta;
    }

    private static double transformLng(double lng, double lat) {
        double ret = 300.0 + lng + 2.0 * lat + 0.1 * lng * lng + 0.1 * lng * lat + 0.1 * Math.sqrt(Math.abs(lng));
        ret += (20.0 * Math.sin(6.0 * lng * Math.PI) + 20.0 * Math.sin(2.0 * lng * Math.PI)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(lng * Math.PI) + 40.0 * Math.sin(lng / 3.0 * Math.PI)) * 2.0 / 3.0;
        return ret += (150.0 * Math.sin(lng / 12.0 * Math.PI) + 300.0 * Math.sin(lng / 30.0 * Math.PI)) * 2.0 / 3.0;
    }

    private static double transformLat(double lng, double lat) {
        double ret = -100.0 + 2.0 * lng + 3.0 * lat + 0.2 * lat * lat + 0.1 * lng * lat + 0.2 * Math.sqrt(Math.abs(lng));
        ret += (20.0 * Math.sin(6.0 * lng * Math.PI) + 20.0 * Math.sin(2.0 * lng * Math.PI)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(lat * Math.PI) + 40.0 * Math.sin(lat / 3.0 * Math.PI)) * 2.0 / 3.0;
        return ret += (160.0 * Math.sin(lat / 12.0 * Math.PI) + 320.0 * Math.sin(lat * Math.PI / 30.0)) * 2.0 / 3.0;
    }

    private static String getJsonOfCoordinate(double latitude, double longitude) {
        try {
            HashMap map = Maps.newHashMap();
            map.put("lat", latitude);
            map.put("lng", longitude);
            ObjectMapper mapper = new ObjectMapper();
            return mapper.writeValueAsString((Object)map);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }
}

