/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.utils.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.SerializedString;
import com.github.aaronshan.functions.utils.json.JsonPathTokenizer;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;

public class JsonExtract {
    private static final JsonFactory JSON_FACTORY = new JsonFactory().disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES);

    private JsonExtract() {
    }

    public static <T> T extract(String jsonInput, JsonExtractor<T> jsonExtractor) {
        if (jsonInput == null) {
            throw new NullPointerException("jsonInput is null");
        }
        try {
            JsonParser jsonParser = JSON_FACTORY.createParser(jsonInput);
            if (jsonParser.nextToken() == null) {
                return null;
            }
            return jsonExtractor.extract(jsonParser);
        }
        catch (JsonParseException e) {
            return null;
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static <T> JsonExtractor<T> generateExtractor(String path, JsonExtractor<T> rootExtractor) {
        return JsonExtract.generateExtractor(path, rootExtractor, false);
    }

    public static <T> JsonExtractor<T> generateExtractor(String path, JsonExtractor<T> rootExtractor, boolean exceptionOnOutOfBounds) {
        ImmutableList tokens = ImmutableList.copyOf((Iterator)((Object)new JsonPathTokenizer(path)));
        JsonExtractor<T> jsonExtractor = rootExtractor;
        for (String token : tokens.reverse()) {
            jsonExtractor = new ObjectFieldJsonExtractor<T>(token, jsonExtractor, exceptionOnOutOfBounds);
        }
        return jsonExtractor;
    }

    private static int tryParseInt(String fieldName, int defaultValue) {
        int index = defaultValue;
        try {
            index = Integer.parseInt(fieldName);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return index;
    }

    public static class JsonSizeExtractor
    implements JsonExtractor<Long> {
        @Override
        public Long extract(JsonParser jsonParser) throws IOException {
            if (!jsonParser.hasCurrentToken()) {
                throw new JsonParseException("Unexpected end of value", jsonParser.getCurrentLocation());
            }
            if (jsonParser.getCurrentToken() == JsonToken.START_ARRAY) {
                long length = 0L;
                while (true) {
                    JsonToken token;
                    if ((token = jsonParser.nextToken()) == null) {
                        return null;
                    }
                    if (token == JsonToken.END_ARRAY) {
                        return length;
                    }
                    jsonParser.skipChildren();
                    ++length;
                }
            }
            if (jsonParser.getCurrentToken() == JsonToken.START_OBJECT) {
                long length = 0L;
                while (true) {
                    JsonToken token;
                    if ((token = jsonParser.nextToken()) == null) {
                        return null;
                    }
                    if (token == JsonToken.END_OBJECT) {
                        return length;
                    }
                    if (token == JsonToken.FIELD_NAME) {
                        ++length;
                        continue;
                    }
                    jsonParser.skipChildren();
                }
            }
            return 0L;
        }
    }

    public static class JsonValueJsonExtractor
    implements JsonExtractor<String> {
        @Override
        public String extract(JsonParser jsonParser) throws IOException {
            if (!jsonParser.hasCurrentToken()) {
                throw new JsonParseException("Unexpected end of value", jsonParser.getCurrentLocation());
            }
            StringWriter stringWriter = new StringWriter();
            try {
                JsonGenerator jsonGenerator = JSON_FACTORY.createGenerator((Writer)stringWriter);
                jsonGenerator.copyCurrentStructure(jsonParser);
                jsonGenerator.flush();
                jsonGenerator.close();
            }
            catch (IOException e) {
                return null;
            }
            return stringWriter.toString();
        }
    }

    public static class ScalarValueJsonExtractor
    implements JsonExtractor<String> {
        @Override
        public String extract(JsonParser jsonParser) throws IOException {
            JsonToken token = jsonParser.getCurrentToken();
            if (token == null) {
                throw new JsonParseException("Unexpected end of value", jsonParser.getCurrentLocation());
            }
            if (!token.isScalarValue() || token == JsonToken.VALUE_NULL) {
                return null;
            }
            return jsonParser.getText();
        }
    }

    public static class ObjectFieldJsonExtractor<T>
    implements JsonExtractor<T> {
        private final SerializedString fieldName;
        private final JsonExtractor<? extends T> delegate;
        private final int index;
        private final boolean exceptionOnOutOfBounds;

        public ObjectFieldJsonExtractor(String fieldName, JsonExtractor<? extends T> delegate) {
            this(fieldName, delegate, false);
        }

        public ObjectFieldJsonExtractor(String fieldName, JsonExtractor<? extends T> delegate, boolean exceptionOnOutOfBounds) {
            if (fieldName == null) {
                throw new NullPointerException("jsonInput is null");
            }
            if (delegate == null) {
                throw new NullPointerException("delegate is null");
            }
            this.fieldName = new SerializedString(fieldName);
            this.delegate = delegate;
            this.exceptionOnOutOfBounds = exceptionOnOutOfBounds;
            this.index = JsonExtract.tryParseInt(fieldName, -1);
        }

        @Override
        public T extract(JsonParser jsonParser) throws IOException {
            if (jsonParser.getCurrentToken() == JsonToken.START_OBJECT) {
                return this.processJsonObject(jsonParser);
            }
            if (jsonParser.getCurrentToken() == JsonToken.START_ARRAY) {
                return this.processJsonArray(jsonParser);
            }
            throw new JsonParseException("Expected a JSON object or array", jsonParser.getCurrentLocation());
        }

        public T processJsonObject(JsonParser jsonParser) throws IOException {
            while (!jsonParser.nextFieldName((SerializableString)this.fieldName)) {
                if (!jsonParser.hasCurrentToken()) {
                    throw new JsonParseException("Unexpected end of object", jsonParser.getCurrentLocation());
                }
                if (jsonParser.getCurrentToken() == JsonToken.END_OBJECT) {
                    return null;
                }
                jsonParser.skipChildren();
            }
            jsonParser.nextToken();
            return this.delegate.extract(jsonParser);
        }

        public T processJsonArray(JsonParser jsonParser) throws IOException {
            int currentIndex = 0;
            while (true) {
                JsonToken token;
                if ((token = jsonParser.nextToken()) == null) {
                    throw new JsonParseException("Unexpected end of array", jsonParser.getCurrentLocation());
                }
                if (token == JsonToken.END_ARRAY) {
                    if (this.exceptionOnOutOfBounds) {
                        throw new RuntimeException("Index out of bounds");
                    }
                    return null;
                }
                if (currentIndex == this.index) break;
                ++currentIndex;
                jsonParser.skipChildren();
            }
            return this.delegate.extract(jsonParser);
        }
    }

    public static interface JsonExtractor<T> {
        public T extract(JsonParser var1) throws IOException;
    }
}

