/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.utils.json;

import com.github.aaronshan.functions.utils.json.JsonExtract;

public class JsonPath {
    private final JsonExtract.JsonExtractor<String> scalarExtractor;
    private final JsonExtract.JsonExtractor<String> objectExtractor;
    private final JsonExtract.JsonExtractor<Long> sizeExtractor;

    public JsonPath(String pattern) {
        this.scalarExtractor = JsonExtract.generateExtractor(pattern, new JsonExtract.ScalarValueJsonExtractor());
        this.objectExtractor = JsonExtract.generateExtractor(pattern, new JsonExtract.JsonValueJsonExtractor());
        this.sizeExtractor = JsonExtract.generateExtractor(pattern, new JsonExtract.JsonSizeExtractor());
    }

    public JsonExtract.JsonExtractor<String> getScalarExtractor() {
        return this.scalarExtractor;
    }

    public JsonExtract.JsonExtractor<String> getObjectExtractor() {
        return this.objectExtractor;
    }

    public JsonExtract.JsonExtractor<Long> getSizeExtractor() {
        return this.sizeExtractor;
    }
}

