/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.utils.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;

public class JsonUtils {
    private static final JsonFactory JSON_FACTORY = new JsonFactory().disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES);
    private static final JsonFactory MAPPING_JSON_FACTORY = new MappingJsonFactory().disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES);

    public static Long jsonArrayLength(String jsonString) {
        try {
            JsonParser parser = JSON_FACTORY.createParser(jsonString);
            if (parser.nextToken() != JsonToken.START_ARRAY) {
                return null;
            }
            long length = 0L;
            while (true) {
                JsonToken token;
                if ((token = parser.nextToken()) == null) {
                    return null;
                }
                if (token == JsonToken.END_ARRAY) {
                    return length;
                }
                parser.skipChildren();
                ++length;
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String jsonArrayGet(String json, long index) {
        try {
            JsonParser parser = MAPPING_JSON_FACTORY.createParser(json);
            if (parser.nextToken() != JsonToken.START_ARRAY) {
                return null;
            }
            ArrayList tokens = null;
            if (index < 0L) {
                tokens = Lists.newArrayList();
            }
            long count = 0L;
            while (true) {
                JsonToken token;
                if ((token = parser.nextToken()) == null) {
                    return null;
                }
                if (token == JsonToken.END_ARRAY) {
                    if (tokens != null && count >= index * -1L) {
                        return (String)tokens.get(0);
                    }
                    return null;
                }
                String arrayElement = token == JsonToken.START_OBJECT || token == JsonToken.START_ARRAY ? parser.readValueAsTree().toString() : parser.getValueAsString();
                if (count == index) {
                    return arrayElement == null ? null : arrayElement;
                }
                if (tokens != null) {
                    tokens.add(arrayElement);
                    if (count >= index * -1L) {
                        tokens.remove(0);
                    }
                }
                ++count;
            }
        }
        catch (IOException e) {
            return null;
        }
    }
}

