/*
 * Decompiled with CFR 0.152.
 */
package com.github.abel533.easyxls.common;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class XmlUtil {
    private static final String ENCODING = "GBK";

    public static <T> T fromXml(File xmlPath, Class<T> type) {
        BufferedReader reader = null;
        StringBuilder sb = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(xmlPath), ENCODING));
            String line = null;
            sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return XmlUtil.fromXml(sb.toString(), type);
    }

    public static <T> T fromXml(String xml, Class<T> type) {
        if (xml == null || xml.trim().equals("")) {
            return null;
        }
        JAXBContext jc = null;
        Unmarshaller u = null;
        Object object = null;
        try {
            jc = JAXBContext.newInstance((Class[])new Class[]{type});
            u = jc.createUnmarshaller();
            object = u.unmarshal((InputStream)new ByteArrayInputStream(xml.getBytes(ENCODING)));
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return (T)object;
    }

    public static boolean toXml(Object object, File xml) {
        if (object == null) {
            throw new NullPointerException("object\u5bf9\u8c61\u4e0d\u5b58\u5728!");
        }
        JAXBContext jc = null;
        Marshaller m = null;
        try {
            jc = JAXBContext.newInstance((Class[])new Class[]{object.getClass()});
            m = jc.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
            m.setProperty("jaxb.encoding", (Object)ENCODING);
            m.marshal(object, xml);
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String toXml(Object object) {
        if (object == null) {
            throw new NullPointerException("object\u5bf9\u8c61\u4e0d\u5b58\u5728!");
        }
        JAXBContext jc = null;
        Marshaller m = null;
        String xml = null;
        try {
            jc = JAXBContext.newInstance((Class[])new Class[]{object.getClass()});
            m = jc.createMarshaller();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            m.marshal(object, (OutputStream)bos);
            xml = new String(bos.toByteArray());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return xml;
    }
}

