/*
 * Decompiled with CFR 0.152.
 */
package com.github.abrarsyed.jastyle;

import com.github.abrarsyed.jastyle.ASUtils;
import com.github.abrarsyed.jastyle.AbstractASBase;
import com.github.abrarsyed.jastyle.SwitchVariables;
import com.github.abrarsyed.jastyle.constants.SourceMode;
import java.util.Stack;

public class ASEnhancer
extends AbstractASBase {
    int indentLength;
    boolean useTabs;
    boolean caseIndent;
    boolean emptyLineFill;
    int lineNumber;
    boolean isInQuote;
    boolean isInComment;
    char quoteChar;
    int bracketCount;
    int switchDepth;
    boolean lookingForCaseBracket;
    boolean unindentNextLine;
    SwitchVariables sw;
    Stack<SwitchVariables> swVector;
    boolean nextLineIsEventTable;
    boolean isInEventTable;

    void init(SourceMode fileType, int _indentLength, String _indentString, boolean _caseIndent, boolean _emptyLineFill) {
        this.init(fileType);
        this.indentLength = _indentLength;
        this.useTabs = _indentString.charAt(0) == '\t';
        this.caseIndent = _caseIndent;
        this.emptyLineFill = _emptyLineFill;
        this.lineNumber = 0;
        this.bracketCount = 0;
        this.isInComment = false;
        this.isInQuote = false;
        this.switchDepth = 0;
        this.lookingForCaseBracket = false;
        this.unindentNextLine = false;
        this.sw = new SwitchVariables(0, 0, false);
        this.swVector = new Stack();
        this.nextLineIsEventTable = false;
        this.isInEventTable = false;
    }

    public void enhance(StringBuilder line) {
        boolean isSpecialChar = false;
        int lineLength = line.length();
        ++this.lineNumber;
        if (this.nextLineIsEventTable) {
            this.isInEventTable = true;
            this.nextLineIsEventTable = false;
        }
        if (lineLength == 0 && !this.isInEventTable && !this.emptyLineFill) {
            return;
        }
        if (this.unindentNextLine) {
            this.sw.setUnindentDepth(this.sw.getUnindentDepth() + 1);
            this.sw.setUnindentCase(true);
            this.unindentNextLine = false;
        }
        for (int i = 0; i < lineLength; ++i) {
            boolean isPotentialKeyword;
            char ch = line.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            if (isSpecialChar) {
                isSpecialChar = false;
                continue;
            }
            if (!this.isInComment && line.indexOf("\\\\", i) == i) {
                ++i;
                continue;
            }
            if (!this.isInComment && ch == '\\') {
                isSpecialChar = true;
                continue;
            }
            if (!(this.isInComment || ch != '\"' && ch != '\'')) {
                if (!this.isInQuote) {
                    this.quoteChar = ch;
                    this.isInQuote = true;
                } else if (this.quoteChar == ch) {
                    this.isInQuote = false;
                    continue;
                }
            }
            if (this.isInQuote) continue;
            if (!this.isInComment && line.indexOf("//", i) == i) {
                if (i + 2 >= line.length() || line.charAt(i + 2) <= '\u00f0') break;
                --this.lineNumber;
                break;
            }
            if (!this.isInComment && line.indexOf("/*", i) == i) {
                this.isInComment = true;
                ++i;
                continue;
            }
            if (this.isInComment && line.indexOf("*/", i) == i) {
                this.isInComment = false;
                ++i;
                continue;
            }
            if (this.isInComment) continue;
            if (line.charAt(i) == '{') {
                ++this.bracketCount;
            }
            if (line.charAt(i) == '}') {
                --this.bracketCount;
            }
            if ((isPotentialKeyword = this.isCharPotentialHeader(line, i)) && !this.isJavaStyle()) {
                if (this.findKeyword(line, i, "BEGIN_EVENT_TABLE") || this.findKeyword(line, i, "BEGIN_MESSAGE_MAP")) {
                    this.nextLineIsEventTable = true;
                }
                if (this.findKeyword(line, i, "END_EVENT_TABLE") || this.findKeyword(line, i, "END_MESSAGE_MAP")) {
                    this.isInEventTable = false;
                }
            }
            if (isPotentialKeyword && this.findKeyword(line, i, "switch")) {
                ++this.switchDepth;
                this.swVector.push(this.sw);
                this.sw.setSwitchBracketCount(0);
                this.sw.setUnindentCase(false);
                i += 5;
                continue;
            }
            if (this.caseIndent || this.switchDepth == 0) continue;
            if (line.charAt(i) == '{') {
                this.sw.setSwitchBracketCount(this.sw.getSwitchBracketCount() + 1);
                if (!this.lookingForCaseBracket) continue;
                this.sw.setUnindentCase(true);
                this.sw.setUnindentDepth(this.sw.getUnindentDepth() + 1);
                this.lookingForCaseBracket = false;
                continue;
            }
            this.lookingForCaseBracket = false;
            if (line.charAt(i) == '}') {
                this.sw.setSwitchBracketCount(this.sw.getSwitchBracketCount() - 1);
                if (this.sw.getSwitchBracketCount() != 0) continue;
                --this.switchDepth;
                this.sw = this.swVector.pop();
                continue;
            }
            if (isPotentialKeyword && (this.findKeyword(line, i, "case") || this.findKeyword(line, i, "default"))) {
                if (this.sw.isUnindentCase()) {
                    this.sw.setUnindentCase(false);
                    this.sw.setUnindentDepth(this.sw.getUnindentDepth() - 1);
                }
                boolean isInQuote = false;
                int quoteChar = 32;
                while (i < lineLength) {
                    if (isInQuote) {
                        if (line.charAt(i) == '\\') {
                            ++i;
                        } else if (line.charAt(i) == quoteChar) {
                            isInQuote = false;
                            quoteChar = 32;
                        }
                    } else if (line.charAt(i) == '\'' || line.charAt(i) == '\"') {
                        isInQuote = true;
                        quoteChar = line.charAt(i);
                    } else if (line.charAt(i) == ':') {
                        if (i + 1 >= lineLength || line.charAt(i + 1) != ':') break;
                        ++i;
                    }
                    ++i;
                }
                ++i;
                while (i < lineLength && Character.isWhitespace(line.charAt(i))) {
                    ++i;
                }
                if (i < lineLength && line.charAt(i) == '{') {
                    this.sw.setSwitchBracketCount(this.sw.getSwitchBracketCount() + 1);
                    this.unindentNextLine = true;
                    continue;
                }
                this.lookingForCaseBracket = true;
                --i;
                continue;
            }
            if (!isPotentialKeyword) continue;
            String name = this.getCurrentWord(line, i);
            i += name.length() - 1;
        }
        if (this.isInEventTable) {
            this.indentLine(line, 1);
        }
        if (this.sw.getUnindentDepth() > 0) {
            this.unindentLine(line, this.sw.getUnindentDepth());
        }
    }

    int indentLine(StringBuilder line, int indent) {
        int charsToInsert;
        if (line.length() == 0 && !this.emptyLineFill) {
            return 0;
        }
        if (this.useTabs) {
            charsToInsert = indent;
            line.insert(0, ASUtils.repeat(charsToInsert, '\t'));
        } else {
            charsToInsert = indent * this.indentLength;
            line.insert(0, ASUtils.repeat(charsToInsert, ' '));
        }
        return charsToInsert;
    }

    int unindentLine(StringBuilder line, int unindent) {
        int charsToErase;
        int whitespace = ASUtils.findFirstNotOf(line, " \t", 0);
        if (whitespace == -1) {
            whitespace = line.length();
        }
        if (whitespace == 0) {
            return 0;
        }
        if (this.useTabs) {
            charsToErase = unindent;
            if (charsToErase <= whitespace) {
                line.delete(0, charsToErase);
            } else {
                charsToErase = 0;
            }
        } else {
            charsToErase = unindent * this.indentLength;
            if (charsToErase <= whitespace) {
                line.delete(0, charsToErase);
            } else {
                charsToErase = 0;
            }
        }
        return charsToErase;
    }
}

