/*
 * Decompiled with CFR 0.152.
 */
package com.github.abrarsyed.jastyle;

import com.github.abrarsyed.jastyle.ASBeautifier;
import com.github.abrarsyed.jastyle.ASEnhancer;
import com.github.abrarsyed.jastyle.ASResource;
import com.github.abrarsyed.jastyle.ASSourceIterator;
import com.github.abrarsyed.jastyle.ASStreamIterator;
import com.github.abrarsyed.jastyle.ASUtils;
import com.github.abrarsyed.jastyle.constants.EnumBracketMode;
import com.github.abrarsyed.jastyle.constants.EnumFormatStyle;
import com.github.abrarsyed.jastyle.constants.SourceMode;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class ASFormatter
extends ASBeautifier {
    private static final String TEMP_SUFFIX = ".tmp";
    private SourceMode formatterFileType = null;
    private List<String> headers;
    private List<String> nonParenHeaders;
    private List<String> preDefinitionHeaders;
    private List<String> preCommandHeaders;
    private List<String> operators;
    private List<String> assignmentOperators;
    private List<String> castOperators;
    private ASSourceIterator sourceIterator = null;
    private ASEnhancer enhancer = new ASEnhancer();
    private Stack<String> preBracketHeaderStack = null;
    private Stack<Integer> bracketTypeStack = null;
    private Stack<Integer> parenStack = null;
    private StringBuilder readyFormattedLine;
    private StringBuilder currentLine;
    private StringBuilder formattedLine;
    private String currentHeader;
    private char currentChar;
    private char previousChar;
    private char previousNonWSChar;
    private char previousCommandChar;
    private char quoteChar;
    private int charNum;
    private int preprocBracketTypeStackSize;
    private int tabIncrementIn;
    private int spacePadNum;
    private int templateDepth;
    private int traceLineNumber;
    private long formattedLineCommentNum;
    private long previousReadyFormattedLineLength;
    private EnumFormatStyle formattingStyle = EnumFormatStyle.NONE;
    private EnumBracketMode bracketFormatMode = EnumBracketMode.NONE;
    private int previousBracketType;
    private boolean isVirgin;
    private boolean shouldPadOperators = true;
    private boolean shouldPadParensOutside = false;
    private boolean shouldPadParensInside = false;
    private boolean shouldUnPadParens = false;
    private boolean shouldConvertTabs = false;
    private boolean isInLineComment;
    private boolean isInComment;
    private boolean isInPreprocessor;
    private boolean isInTemplate;
    private boolean doesLineStartComment;
    private boolean lineEndsInCommentOnly;
    private boolean lineIsLineCommentOnly;
    private boolean lineIsEmpty;
    private boolean isImmediatelyPostCommentOnly;
    private boolean isImmediatelyPostEmptyLine;
    private boolean isInQuote;
    private boolean isInVerbatimQuote;
    private boolean haveLineContinuationChar;
    private boolean isInQuoteContinuation;
    private boolean isInBlParen;
    private boolean isSpecialChar;
    private boolean isNonParenHeader;
    private boolean foundQuestionMark;
    private boolean foundPreDefinitionHeader;
    private boolean foundNamespaceHeader;
    private boolean foundClassHeader;
    private boolean foundInterfaceHeader;
    private boolean foundPreCommandHeader;
    private boolean foundCastOperator;
    private boolean isInLineBreak;
    private boolean endOfCodeReached;
    private boolean lineCommentNoIndent = false;
    private boolean isLineReady;
    private boolean isPreviousBracketBlockRelated;
    private boolean isInPotentialCalculation;
    private boolean isCharImmediatelyPostComment;
    private boolean isPreviousCharPostComment;
    private boolean isCharImmediatelyPostLineComment;
    private boolean isCharImmediatelyPostOpenBlock;
    private boolean isCharImmediatelyPostCloseBlock;
    private boolean isCharImmediatelyPostTemplate;
    private boolean isCharImmediatelyPostReturn;
    private boolean isCharImmediatelyPostOperator;
    private boolean shouldBreakOneLineBlocks = true;
    private boolean shouldReparseCurrentChar;
    private boolean shouldBreakOneLineStatements = true;
    private boolean shouldBreakClosingHeaderBrackets = false;
    private boolean shouldBreakElseIfs = false;
    private boolean shouldDeleteEmptyLines = false;
    private boolean needHeaderOpeningBracket;
    private boolean passedSemicolon;
    private boolean passedColon;
    private boolean isImmediatelyPostComment;
    private boolean isImmediatelyPostLineComment;
    private boolean isImmediatelyPostEmptyBlock;
    private boolean isImmediatelyPostPreprocessor;
    private boolean isImmediatelyPostReturn;
    private boolean isImmediatelyPostOperator;
    private String suffix = ".orig";
    private boolean shouldBreakBlocks = false;
    private boolean shouldBreakClosingHeaderBlocks = false;
    private boolean isPrependPostBlockEmptyLineRequested;
    private boolean isAppendPostBlockEmptyLineRequested;
    private boolean prependEmptyLine;
    private boolean appendOpeningBracket;
    private boolean foundClosingHeader;
    private boolean isInHeader;
    private boolean isImmediatelyPostHeader;
    private boolean isInCase;
    private boolean isJavaStaticConstructor;

    private void buildLanguageVectors() {
        if (this.getFileType() == this.formatterFileType) {
            return;
        }
        this.formatterFileType = this.getFileType();
        this.headers = new ArrayList<String>();
        this.nonParenHeaders = new ArrayList<String>();
        this.assignmentOperators = new ArrayList<String>();
        this.operators = new ArrayList<String>();
        this.preDefinitionHeaders = new ArrayList<String>();
        this.preCommandHeaders = new ArrayList<String>();
        this.castOperators = new ArrayList<String>();
        ASResource.buildHeaders(this.headers, this.getFileType(), false);
        ASResource.buildNonParenHeaders(this.nonParenHeaders, this.getFileType(), false);
        ASResource.buildPreDefinitionHeaders(this.preDefinitionHeaders, this.getFileType());
        ASResource.buildPreCommandHeaders(this.preCommandHeaders, this.getFileType());
        if (this.operators.size() == 0) {
            ASResource.buildOperators(this.operators);
        }
        if (this.assignmentOperators.size() == 0) {
            ASResource.buildAssignmentOperators(this.assignmentOperators);
        }
        if (this.castOperators.size() == 0) {
            ASResource.buildCastOperators(this.castOperators);
        }
    }

    public void fixOptionVariableConflicts() {
        this.formattingStyle.apply(this);
        if (this.isBracketIndent() && this.isBlockIndent()) {
            this.setBracketIndent(false);
        }
    }

    @Override
    public void init(ASSourceIterator iterator) {
        this.buildLanguageVectors();
        this.fixOptionVariableConflicts();
        super.init(iterator);
        this.enhancer.init(this.getFileType(), this.getIndentLength(), this.getIndentString(), this.isCaseIndent(), this.isEmptyLineFill());
        this.sourceIterator = iterator;
        this.preBracketHeaderStack = new Stack();
        this.parenStack = new Stack();
        this.parenStack.push(0);
        this.bracketTypeStack = new Stack();
        this.bracketTypeStack.push(0);
        this.currentHeader = null;
        this.currentLine = new StringBuilder();
        this.readyFormattedLine = new StringBuilder();
        this.formattedLine = new StringBuilder();
        this.currentChar = (char)32;
        this.previousChar = (char)32;
        this.previousCommandChar = (char)32;
        this.previousNonWSChar = (char)32;
        this.quoteChar = (char)34;
        this.charNum = 0;
        this.preprocBracketTypeStackSize = 0;
        this.spacePadNum = 0;
        this.previousReadyFormattedLineLength = -1L;
        this.templateDepth = 0;
        this.traceLineNumber = 0;
        this.previousBracketType = 0;
        this.isVirgin = true;
        this.isInLineComment = false;
        this.isInComment = false;
        this.isInPreprocessor = false;
        this.doesLineStartComment = false;
        this.lineEndsInCommentOnly = false;
        this.lineIsLineCommentOnly = false;
        this.lineIsEmpty = false;
        this.isImmediatelyPostCommentOnly = false;
        this.isImmediatelyPostEmptyLine = false;
        this.isInQuote = false;
        this.isInVerbatimQuote = false;
        this.haveLineContinuationChar = false;
        this.isInQuoteContinuation = false;
        this.isSpecialChar = false;
        this.isNonParenHeader = true;
        this.foundNamespaceHeader = false;
        this.foundClassHeader = false;
        this.foundInterfaceHeader = false;
        this.foundPreDefinitionHeader = false;
        this.foundPreCommandHeader = false;
        this.foundCastOperator = false;
        this.foundQuestionMark = false;
        this.isInLineBreak = false;
        this.endOfCodeReached = false;
        this.isLineReady = false;
        this.isPreviousBracketBlockRelated = true;
        this.isInPotentialCalculation = false;
        this.shouldReparseCurrentChar = false;
        this.needHeaderOpeningBracket = false;
        this.passedSemicolon = false;
        this.passedColon = false;
        this.isInTemplate = false;
        this.isInBlParen = false;
        this.isImmediatelyPostComment = false;
        this.isImmediatelyPostLineComment = false;
        this.isImmediatelyPostEmptyBlock = false;
        this.isImmediatelyPostPreprocessor = false;
        this.isImmediatelyPostReturn = false;
        this.isImmediatelyPostOperator = false;
        this.isCharImmediatelyPostReturn = false;
        this.isCharImmediatelyPostOperator = false;
        this.isPrependPostBlockEmptyLineRequested = false;
        this.isAppendPostBlockEmptyLineRequested = false;
        this.prependEmptyLine = false;
        this.appendOpeningBracket = false;
        this.foundClosingHeader = false;
        this.previousReadyFormattedLineLength = 0L;
        this.isImmediatelyPostHeader = false;
        this.isInHeader = false;
        this.isInCase = false;
        this.isJavaStaticConstructor = false;
    }

    public boolean formatFile(File file) {
        try {
            SourceMode fileTypeOld = this.fileType;
            if (this.fileType == null) {
                this.setSourceStyle(SourceMode.getFromFileName(file.getName()));
            }
            BufferedReader in = new BufferedReader(new FileReader(file));
            File tempFile = new File(file.getPath() + TEMP_SUFFIX);
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(tempFile)));
            this.format(in, out);
            out.flush();
            out.close();
            ((Reader)in).close();
            this.setSourceStyle(fileTypeOld);
            File outFile = file;
            if (this.suffix != null) {
                new File(file.getPath() + this.suffix);
            }
            outFile.delete();
            tempFile.renameTo(outFile);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void format(Reader in, Writer out) throws IOException {
        ASStreamIterator streamIterator = new ASStreamIterator(in);
        this.init(streamIterator);
        PrintWriter pout = out instanceof PrintWriter ? (PrintWriter)out : new PrintWriter(out);
        while (this.hasMoreLines()) {
            String temp = this.nextLine().toString();
            pout.println(temp);
        }
    }

    @Override
    public StringBuilder nextLine() {
        StringBuilder beautifiedLine;
        boolean isInVirginLine = this.isVirgin;
        this.isCharImmediatelyPostComment = false;
        this.isPreviousCharPostComment = false;
        this.isCharImmediatelyPostLineComment = false;
        this.isCharImmediatelyPostOpenBlock = false;
        this.isCharImmediatelyPostCloseBlock = false;
        this.isCharImmediatelyPostTemplate = false;
        ++this.traceLineNumber;
        while (!this.isLineReady) {
            String newHeader;
            if (this.shouldReparseCurrentChar) {
                this.shouldReparseCurrentChar = false;
            } else {
                if (!this.getNextChar()) {
                    this.breakLine();
                    return this.beautify(this.readyFormattedLine);
                }
                if (isInVirginLine && this.currentChar == '{' && this.lineBeginsWith('{')) {
                    this.previousCommandChar = (char)123;
                }
                this.isPreviousCharPostComment = this.isCharImmediatelyPostComment;
                this.isCharImmediatelyPostComment = false;
                this.isCharImmediatelyPostTemplate = false;
                this.isCharImmediatelyPostReturn = false;
                this.isCharImmediatelyPostOperator = false;
                this.isCharImmediatelyPostOpenBlock = false;
                this.isCharImmediatelyPostCloseBlock = false;
            }
            if (this.isInLineComment) {
                this.appendCurrentChar();
                if (this.charNum + 1 != this.currentLine.length()) continue;
                this.isInLineBreak = true;
                this.isInLineComment = false;
                this.isImmediatelyPostLineComment = true;
                this.currentChar = '\u0000';
                continue;
            }
            if (this.isInComment) {
                if (this.isSequenceReached("*/")) {
                    this.isInComment = false;
                    this.isImmediatelyPostComment = true;
                    this.appendSequence("*/", true);
                    this.goForward(1);
                    if (!this.doesLineStartComment || ASUtils.findFirstNotOf(this.currentLine, " \t", this.charNum + 1) != -1) continue;
                    this.lineEndsInCommentOnly = true;
                    continue;
                }
                this.appendCurrentChar();
                continue;
            }
            if (this.isInQuote) {
                if (this.isSpecialChar) {
                    this.isSpecialChar = false;
                } else if (this.currentChar == '\\' && !this.isInVerbatimQuote) {
                    if (this.peekNextChar() == ' ') {
                        this.haveLineContinuationChar = true;
                    } else {
                        this.isSpecialChar = true;
                    }
                } else if (this.isInVerbatimQuote && this.currentChar == '\"') {
                    if (this.peekNextChar() == '\"') {
                        this.appendSequence("\"\"");
                        this.goForward(1);
                        continue;
                    }
                    this.isInQuote = false;
                    this.isInVerbatimQuote = false;
                } else if (this.quoteChar == this.currentChar) {
                    this.isInQuote = false;
                }
                this.appendCurrentChar();
                continue;
            }
            if (this.isSequenceReached("//")) {
                if (this.charNum + 2 < this.currentLine.length() && this.currentLine.charAt(this.charNum + 2) == '\u00f2') {
                    this.isAppendPostBlockEmptyLineRequested = false;
                }
                this.isInLineComment = true;
                if (!this.lineCommentNoIndent) {
                    if (this.charNum == 0) {
                        this.lineCommentNoIndent = true;
                    } else if (this.charNum == 1 && this.currentLine.charAt(0) == ' ') {
                        this.lineCommentNoIndent = true;
                    }
                }
                if (!this.lineCommentNoIndent && this.spacePadNum != 0) {
                    this.adjustComments();
                }
                this.formattedLineCommentNum = this.formattedLine.length();
                this.appendSequence("//");
                this.goForward(1);
                if (this.shouldBreakBlocks && this.lineIsLineCommentOnly && !this.isImmediatelyPostEmptyLine && this.previousCommandChar != '{' && !this.isImmediatelyPostLineComment) {
                    this.checkForFollowingHeader(new StringBuilder(this.currentLine.substring(this.charNum - 1)));
                }
                if (this.previousCommandChar == '}') {
                    this.currentHeader = null;
                }
                if (this.charNum + 1 != this.currentLine.length()) continue;
                this.isInLineBreak = true;
                this.isInLineComment = false;
                this.isImmediatelyPostLineComment = true;
                this.currentChar = '\u0000';
                continue;
            }
            if (this.isSequenceReached("/*")) {
                this.isInComment = true;
                if (this.spacePadNum != 0) {
                    this.adjustComments();
                }
                this.formattedLineCommentNum = this.formattedLine.length();
                this.appendSequence("/*");
                this.goForward(1);
                if (this.shouldBreakBlocks && this.doesLineStartComment && !this.isImmediatelyPostEmptyLine && this.previousCommandChar != '{' && !this.isImmediatelyPostLineComment) {
                    this.checkForFollowingHeader(new StringBuilder(this.currentLine.substring(this.charNum - 1)));
                }
                if (this.previousCommandChar != '}') continue;
                this.currentHeader = null;
                continue;
            }
            if (this.currentChar == '\"' || this.currentChar == '\'') {
                this.isInQuote = true;
                if (this.isSharpStyle() && this.previousChar == '@') {
                    this.isInVerbatimQuote = true;
                }
                this.quoteChar = this.currentChar;
                this.appendCurrentChar();
                continue;
            }
            if (this.currentChar == '#' && (this.isSequenceReached("#region") || this.isSequenceReached("#endregion") || this.isSequenceReached("#error") || this.isSequenceReached("#warning"))) {
                this.isInLineComment = true;
                this.appendCurrentChar();
                continue;
            }
            if (Character.isWhitespace(this.currentChar) || this.isInPreprocessor) {
                this.appendCurrentChar();
                continue;
            }
            if (this.appendOpeningBracket) {
                this.previousChar = (char)123;
                this.previousNonWSChar = (char)123;
                this.previousCommandChar = (char)123;
            }
            if (this.currentChar == '#') {
                this.isInPreprocessor = true;
                this.processPreprocessor();
            }
            if (this.isImmediatelyPostComment) {
                this.isImmediatelyPostComment = false;
                this.isCharImmediatelyPostComment = true;
            }
            if (this.isImmediatelyPostLineComment) {
                this.isImmediatelyPostLineComment = false;
                this.isCharImmediatelyPostLineComment = true;
            }
            if (this.isImmediatelyPostReturn) {
                this.isImmediatelyPostReturn = false;
                this.isCharImmediatelyPostReturn = true;
            }
            if (this.isImmediatelyPostOperator) {
                this.isImmediatelyPostOperator = false;
                this.isCharImmediatelyPostOperator = true;
            }
            if (this.isImmediatelyPostHeader) {
                this.isImmediatelyPostHeader = false;
                if (this.shouldBreakOneLineStatements && (this.shouldBreakOneLineBlocks || !this.isBracketType(this.bracketTypeStack.peek(), 64)) && this.shouldBreakElseIfs) {
                    this.isInLineBreak = true;
                }
            }
            if (this.passedSemicolon) {
                this.passedSemicolon = false;
                if (this.parenStack.peek() == 0 && this.currentChar != ';') {
                    if (this.isBracketType(this.bracketTypeStack.peek(), 64)) {
                        int blockEnd = this.currentLine.lastIndexOf("}");
                        assert (blockEnd != -1);
                        if (this.isBeforeLineEndComment(blockEnd)) {
                            int commentStart = ASUtils.findFirstNotOf(this.currentLine, " \t", blockEnd + 1);
                            assert (commentStart != -1);
                            assert (this.currentLine.indexOf("//", commentStart) == commentStart || this.currentLine.indexOf("/*", commentStart) == commentStart);
                            int commentLength = this.currentLine.length() - commentStart;
                            int tabCount = this.getIndentLength();
                            this.appendSpacePad();
                            this.formattedLine.append(ASUtils.repeat(tabCount, ' '));
                            this.formattedLine.append(this.currentLine.substring(commentStart, commentStart + commentLength));
                            this.currentLine.delete(commentStart, commentStart + commentLength);
                        }
                    }
                    this.shouldReparseCurrentChar = true;
                    this.isInLineBreak = true;
                    if (!this.needHeaderOpeningBracket) continue;
                    this.isCharImmediatelyPostCloseBlock = true;
                    this.needHeaderOpeningBracket = false;
                    continue;
                }
            }
            if (this.passedColon) {
                this.passedColon = false;
                if (this.parenStack.peek() == 0 && !this.isBeforeComment()) {
                    this.shouldReparseCurrentChar = true;
                    this.isInLineBreak = true;
                    continue;
                }
            }
            if (!this.isInTemplate && this.currentChar == '<') {
                int maxTemplateDepth = 0;
                this.templateDepth = 0;
                for (int i = this.charNum; i < this.currentLine.length(); ++i) {
                    char currentChar = this.currentLine.charAt(i);
                    if (currentChar == '<') {
                        ++this.templateDepth;
                        ++maxTemplateDepth;
                        continue;
                    }
                    if (currentChar == '>') {
                        --this.templateDepth;
                        if (this.templateDepth != 0) continue;
                        this.isInTemplate = true;
                        this.templateDepth = maxTemplateDepth;
                        break;
                    }
                    if (currentChar == ',' || currentChar == '&' || currentChar == '*' || currentChar == ':' || currentChar == '[' || currentChar == ']' || this.isLegalNameChar(currentChar) || Character.isWhitespace(currentChar)) continue;
                    this.isInTemplate = false;
                    break;
                }
            }
            if (this.currentChar == '(' || this.currentChar == '[' || this.isInTemplate && this.currentChar == '<') {
                this.parenStack.set(this.parenStack.size() - 1, this.parenStack.peek() + 1);
                if (this.currentChar == '[') {
                    this.isInBlParen = true;
                }
            } else if (this.currentChar == ')' || this.currentChar == ']' || this.isInTemplate && this.currentChar == '>') {
                this.parenStack.set(this.parenStack.size() - 1, this.parenStack.peek() - 1);
                if (this.isInTemplate && this.currentChar == '>') {
                    --this.templateDepth;
                    if (this.templateDepth == 0) {
                        this.isInTemplate = false;
                        this.isCharImmediatelyPostTemplate = true;
                    }
                }
                if (this.isInHeader && this.parenStack.peek() == 0) {
                    this.isInHeader = false;
                    this.isImmediatelyPostHeader = true;
                }
                if (this.currentChar == ']') {
                    this.isInBlParen = false;
                }
                if (this.currentChar == ')') {
                    this.foundCastOperator = false;
                }
            }
            if (this.currentChar == '{' || this.currentChar == '}') {
                int bracketType;
                boolean isOpeningArrayBracket;
                if (this.currentChar == '{') {
                    int newBracketType = this.getBracketType();
                    this.foundNamespaceHeader = false;
                    this.foundClassHeader = false;
                    this.foundInterfaceHeader = false;
                    this.foundPreDefinitionHeader = false;
                    this.foundPreCommandHeader = false;
                    this.isInPotentialCalculation = false;
                    this.isJavaStaticConstructor = false;
                    this.needHeaderOpeningBracket = false;
                    this.bracketTypeStack.add(newBracketType);
                    this.preBracketHeaderStack.add(this.currentHeader);
                    this.currentHeader = null;
                    this.isPreviousBracketBlockRelated = !this.isBracketType(newBracketType, 32);
                }
                boolean bl = isOpeningArrayBracket = this.isBracketType(bracketType = this.bracketTypeStack.peek().intValue(), 32) && this.bracketTypeStack.size() >= 2 && !this.isBracketType((Integer)this.bracketTypeStack.get(this.bracketTypeStack.size() - 2), 32);
                if (this.currentChar == '}') {
                    this.isAppendPostBlockEmptyLineRequested = false;
                    if (this.bracketTypeStack.size() > 1) {
                        this.previousBracketType = this.bracketTypeStack.peek();
                        this.bracketTypeStack.pop();
                        this.isPreviousBracketBlockRelated = !this.isBracketType(bracketType, 32);
                    } else {
                        this.previousBracketType = 0;
                        this.isPreviousBracketBlockRelated = false;
                    }
                    if (!this.preBracketHeaderStack.empty()) {
                        this.currentHeader = this.preBracketHeaderStack.peek();
                        this.preBracketHeaderStack.pop();
                    } else {
                        this.currentHeader = null;
                    }
                }
                if (this.isBracketType(bracketType, 32)) {
                    this.formatArrayBrackets(bracketType, isOpeningArrayBracket);
                    continue;
                }
                this.formatBrackets(bracketType);
                continue;
            }
            if ((this.previousCommandChar == '{' && this.isPreviousBracketBlockRelated || this.previousCommandChar == '}' && !this.isImmediatelyPostEmptyBlock && this.isPreviousBracketBlockRelated && !this.isPreviousCharPostComment && this.peekNextChar() != ' ' && !this.isBracketType(this.previousBracketType, 8) && !this.isBracketType(this.bracketTypeStack.peek(), 8)) && (this.shouldBreakOneLineBlocks || !this.isBracketType(this.bracketTypeStack.peek(), 64))) {
                this.isCharImmediatelyPostOpenBlock = this.previousCommandChar == '{';
                boolean bl = this.isCharImmediatelyPostCloseBlock = this.previousCommandChar == '}';
                if (this.isCharImmediatelyPostOpenBlock || this.isCharImmediatelyPostCloseBlock && this.shouldBreakOneLineStatements && this.isLegalNameChar(this.currentChar) && this.currentChar != '.' && !this.isCharImmediatelyPostComment) {
                    this.previousCommandChar = (char)32;
                    this.isInLineBreak = true;
                }
            }
            this.isImmediatelyPostEmptyBlock = false;
            boolean isPotentialHeader = this.isCharPotentialHeader(this.currentLine, this.charNum);
            if (isPotentialHeader && !this.isInTemplate) {
                newHeader = this.findHeader(this.headers);
                if (newHeader != null) {
                    char peekChar = this.peekNextChar(this.currentLine, this.charNum + newHeader.length() - 1);
                    if (peekChar == ',' || peekChar == ')') {
                        newHeader = null;
                    } else if ((newHeader.equals("get") || newHeader.equals("set") || newHeader.equals("default")) && peekChar == ';') {
                        newHeader = null;
                    }
                }
                if (newHeader != null) {
                    this.foundClosingHeader = false;
                    if (this.currentHeader != null && (newHeader.equals("else") && this.currentHeader.equals("if") || newHeader.equals("while") && this.currentHeader.equals("do") || newHeader.equals("catch") && this.currentHeader.equals("try") || newHeader.equals("catch") && this.currentHeader.equals("catch") || newHeader.equals("finally") && this.currentHeader.equals("try") || newHeader.equals("finally") && this.currentHeader.equals("catch") || newHeader.equals("set") && this.currentHeader.equals("get") || newHeader.equals("remove") && this.currentHeader.equals("add"))) {
                        this.foundClosingHeader = true;
                    }
                    String previousHeader = this.currentHeader;
                    this.currentHeader = newHeader;
                    this.needHeaderOpeningBracket = true;
                    if (this.foundClosingHeader && this.previousNonWSChar == '}' && (this.shouldBreakOneLineBlocks || !this.isBracketType(this.bracketTypeStack.peek(), 64))) {
                        if (this.bracketFormatMode.equals((Object)EnumBracketMode.BREAK)) {
                            this.isInLineBreak = true;
                        } else if (this.bracketFormatMode == EnumBracketMode.NONE) {
                            if (this.shouldBreakClosingHeaderBrackets || this.isBracketIndent() || this.isBlockIndent()) {
                                this.isInLineBreak = true;
                            } else {
                                this.appendSpacePad();
                                int i = ASUtils.findFirstNotOf(this.currentLine, " \t", 0);
                                if (i != -1 && this.currentLine.charAt(i) == '}') {
                                    this.isInLineBreak = false;
                                }
                                if (this.shouldBreakBlocks) {
                                    this.isAppendPostBlockEmptyLineRequested = false;
                                }
                            }
                        } else if (this.shouldBreakClosingHeaderBrackets || this.isBracketIndent() || this.isBlockIndent()) {
                            this.isInLineBreak = true;
                        } else {
                            this.spacePadNum = 0;
                            int firstChar = ASUtils.findFirstNotOf(this.formattedLine, " \t", 0);
                            if (firstChar != -1) {
                                this.isInLineBreak = false;
                                this.appendSpacePad();
                            }
                            if (this.shouldBreakBlocks) {
                                this.isAppendPostBlockEmptyLineRequested = false;
                            }
                        }
                    }
                    this.isNonParenHeader = this.nonParenHeaders.contains(newHeader);
                    if (previousHeader != null && this.currentHeader.equals("if") && previousHeader.equals("else") && this.isInLineBreak && !this.shouldBreakElseIfs) {
                        int start;
                        int n = start = this.formattedLine.length() >= 6 ? this.formattedLine.length() - 6 : 0;
                        if (this.formattedLine.indexOf("else", start) != -1 && this.formattedLine.indexOf("#else", start) == -1) {
                            this.appendSpacePad();
                            this.isInLineBreak = false;
                        }
                    }
                    this.appendSequence(this.currentHeader, true);
                    this.goForward(this.currentHeader.length() - 1);
                    if ((!this.isNonParenHeader || this.currentHeader.equals("catch") && this.peekNextChar() == '(') && !Character.isWhitespace(this.currentLine.charAt(this.charNum + 1))) {
                        this.appendSpacePad();
                    }
                    if (!this.foundClosingHeader || !this.currentHeader.equals("while")) {
                        this.isInHeader = true;
                        if (this.isNonParenHeader && this.peekNextChar() != '(') {
                            this.isImmediatelyPostHeader = true;
                            this.isInHeader = false;
                        }
                    }
                    if (!this.shouldBreakBlocks || !this.shouldBreakOneLineBlocks && this.isBracketType(this.bracketTypeStack.peek(), 64)) continue;
                    if (!(previousHeader != null || this.foundClosingHeader || this.isCharImmediatelyPostOpenBlock || this.isImmediatelyPostCommentOnly)) {
                        this.isPrependPostBlockEmptyLineRequested = true;
                    }
                    if (this.currentHeader.equals("else") || this.currentHeader.equals("catch") || this.currentHeader.equals("finally") || this.foundClosingHeader) {
                        this.isPrependPostBlockEmptyLineRequested = false;
                    }
                    if (!this.shouldBreakClosingHeaderBlocks || !this.isCharImmediatelyPostCloseBlock || this.isImmediatelyPostCommentOnly || this.currentHeader.equals("while")) continue;
                    this.isPrependPostBlockEmptyLineRequested = true;
                    continue;
                }
                newHeader = this.findHeader(this.preDefinitionHeaders);
                if (newHeader != null && this.parenStack.peek() == 0) {
                    if (newHeader.equals("namespace")) {
                        this.foundNamespaceHeader = true;
                    }
                    if (newHeader.equals("class")) {
                        this.foundClassHeader = true;
                    }
                    if (newHeader.equals("interface")) {
                        this.foundInterfaceHeader = true;
                    }
                    this.foundPreDefinitionHeader = true;
                    this.appendSequence(newHeader);
                    this.goForward(newHeader.length() - 1);
                    continue;
                }
                newHeader = this.findHeader(this.preCommandHeaders);
                if (newHeader != null) {
                    if (!newHeader.equals("") || this.previousCommandChar == ')') {
                        this.foundPreCommandHeader = true;
                    }
                    this.appendSequence(newHeader);
                    this.goForward(newHeader.length() - 1);
                    continue;
                }
                newHeader = this.findHeader(this.castOperators);
                if (newHeader != null) {
                    this.foundCastOperator = true;
                    this.appendSequence(newHeader);
                    this.goForward(newHeader.length() - 1);
                    continue;
                }
            }
            if (this.isInLineBreak) {
                this.breakLine();
            }
            if (this.previousNonWSChar == '}' || this.currentChar == ';') {
                if (this.shouldBreakOneLineStatements && this.currentChar == ';' && (this.shouldBreakOneLineBlocks || !this.isBracketType(this.bracketTypeStack.peek(), 64))) {
                    this.passedSemicolon = true;
                }
                if (this.shouldBreakBlocks && this.currentChar == ';' && this.currentHeader != null && this.parenStack.peek() == 0) {
                    this.isAppendPostBlockEmptyLineRequested = true;
                }
                if (this.currentChar != ';' || this.needHeaderOpeningBracket && this.parenStack.peek() == 0) {
                    this.currentHeader = null;
                }
                this.foundQuestionMark = false;
                this.foundNamespaceHeader = false;
                this.foundClassHeader = false;
                this.foundInterfaceHeader = false;
                this.foundPreDefinitionHeader = false;
                this.foundPreCommandHeader = false;
                this.foundCastOperator = false;
                this.isInPotentialCalculation = false;
                this.isNonInStatementArray = false;
                this.isSharpAccessor = false;
            }
            if (this.currentChar == ':' && this.shouldBreakOneLineStatements) {
                if (this.isInCase && this.previousChar != ':' && this.peekNextChar() != ':') {
                    this.isInCase = false;
                    this.passedColon = true;
                } else if (this.isCStyle() && !this.foundQuestionMark && !this.foundPreDefinitionHeader && this.previousCommandChar != ')' && this.previousChar != ':' && this.peekNextChar() != ':' && !Character.isDigit(this.peekNextChar())) {
                    this.passedColon = true;
                }
            }
            if (this.currentChar == '?') {
                this.foundQuestionMark = true;
            }
            if (isPotentialHeader && !this.isInTemplate) {
                if (this.findKeyword(this.currentLine, this.charNum, "case") || this.findKeyword(this.currentLine, this.charNum, "default")) {
                    this.isInCase = true;
                }
                if (this.findKeyword(this.currentLine, this.charNum, "new")) {
                    this.isInPotentialCalculation = false;
                }
                if (this.findKeyword(this.currentLine, this.charNum, "return")) {
                    this.isImmediatelyPostReturn = true;
                }
                if (this.findKeyword(this.currentLine, this.charNum, "operator")) {
                    this.isImmediatelyPostOperator = true;
                }
                if (this.isJavaStyle() && this.findKeyword(this.currentLine, this.charNum, "static") && this.isNextCharOpeningBracket(this.charNum + 6)) {
                    this.isJavaStaticConstructor = true;
                }
                String name = this.getCurrentWord(this.currentLine, this.charNum);
                this.appendSequence(name);
                this.goForward(name.length() - 1);
                continue;
            }
            boolean isPotentialOperator = this.isCharPotentialOperator(this.currentChar);
            newHeader = null;
            if (isPotentialOperator && (newHeader = this.findOperator(this.operators)) != null) {
                if (this.isInTemplate && (newHeader.equals(">>") || newHeader.equals(">>>"))) {
                    newHeader = ">";
                }
                if (!this.isInPotentialCalculation && this.assignmentOperators.contains(newHeader)) {
                    char peekedChar = this.peekNextChar();
                    boolean bl = this.isInPotentialCalculation = !(newHeader.equals("==") && peekedChar == '*' || newHeader.equals("==") && peekedChar == '&');
                }
            }
            if (this.shouldPadOperators && newHeader != null) {
                this.padOperators(newHeader);
                continue;
            }
            if (this.currentChar == ';' || this.currentChar == ',' && this.shouldPadOperators) {
                char nextChar = ' ';
                if (this.charNum + 1 < this.currentLine.length()) {
                    nextChar = this.currentLine.charAt(this.charNum + 1);
                }
                if (!Character.isWhitespace(nextChar) && nextChar != '}' && nextChar != ')' && nextChar != ']' && nextChar != '>' && nextChar != ';' && !this.isBeforeComment()) {
                    this.appendCurrentChar();
                    this.appendSpaceAfter();
                    continue;
                }
            }
            if ((this.shouldPadParensOutside || this.shouldPadParensInside || this.shouldUnPadParens) && (this.currentChar == '(' || this.currentChar == ')')) {
                this.padParens();
                continue;
            }
            this.appendCurrentChar();
        }
        int readyFormattedLineLength = this.readyFormattedLine.toString().trim().length();
        if (this.prependEmptyLine && readyFormattedLineLength > 0 && this.previousReadyFormattedLineLength > 0L) {
            this.isLineReady = true;
            beautifiedLine = this.beautify(new StringBuilder());
            this.previousReadyFormattedLineLength = 0L;
        } else {
            this.isLineReady = false;
            beautifiedLine = this.beautify(this.readyFormattedLine);
            this.previousReadyFormattedLineLength = readyFormattedLineLength;
            this.lineCommentNoBeautify = this.lineCommentNoIndent;
            this.lineCommentNoIndent = false;
            if (this.appendOpeningBracket) {
                this.appendOpeningBracket = false;
                this.isLineReady = true;
                this.readyFormattedLine = new StringBuilder("{");
                this.isPrependPostBlockEmptyLineRequested = false;
                this.lineCommentNoIndent = this.lineCommentNoBeautify;
                this.lineCommentNoBeautify = false;
            }
        }
        this.prependEmptyLine = false;
        this.enhancer.enhance(beautifiedLine);
        return beautifiedLine;
    }

    @Override
    public boolean hasMoreLines() {
        return !this.endOfCodeReached;
    }

    boolean isBracketType(int a, int b) {
        return (a & b) == b;
    }

    public void setFormattingStyle(EnumFormatStyle style) {
        this.formattingStyle = style;
    }

    public void setBracketFormatMode(EnumBracketMode mode) {
        this.bracketFormatMode = mode;
    }

    public void setBreakClosingHeaderBracketsMode(boolean state) {
        this.shouldBreakClosingHeaderBrackets = state;
    }

    public void setBreakElseIfsMode(boolean state) {
        this.shouldBreakElseIfs = state;
    }

    public void setOperatorPaddingMode(boolean state) {
        this.shouldPadOperators = state;
    }

    public void setParensOutsidePaddingMode(boolean state) {
        this.shouldPadParensOutside = state;
    }

    public void setParensInsidePaddingMode(boolean state) {
        this.shouldPadParensInside = state;
    }

    public void setParensUnPaddingMode(boolean state) {
        this.shouldUnPadParens = state;
    }

    public void setBreakOneLineBlocksMode(boolean state) {
        this.shouldBreakOneLineBlocks = state;
    }

    public void setSingleStatementsMode(boolean state) {
        this.shouldBreakOneLineStatements = state;
    }

    public void setTabSpaceConversionMode(boolean state) {
        this.shouldConvertTabs = state;
    }

    public void setBreakBlocksMode(boolean state) {
        this.shouldBreakBlocks = state;
    }

    public void setBreakClosingHeaderBlocksMode(boolean state) {
        this.shouldBreakClosingHeaderBlocks = state;
    }

    public void setDeleteEmptyLinesMode(boolean state) {
        this.shouldDeleteEmptyLines = state;
    }

    private void goForward(int i) {
        while (--i >= 0) {
            this.getNextChar();
        }
    }

    private char peekNextChar() {
        char ch = ' ';
        int peekNum = ASUtils.findFirstNotOf(this.currentLine, " \t", this.charNum + 1);
        if (peekNum == -1) {
            return ch;
        }
        ch = this.currentLine.charAt(peekNum);
        return ch;
    }

    private boolean isBeforeComment() {
        boolean foundComment = false;
        int peekNum = ASUtils.findFirstNotOf(this.currentLine, " \t", this.charNum + 1);
        if (peekNum == -1) {
            return foundComment;
        }
        foundComment = this.currentLine.indexOf("/*", peekNum) == peekNum || this.currentLine.indexOf("//", peekNum) == peekNum;
        return foundComment;
    }

    private boolean isBeforeLineEndComment(int startPos) {
        boolean foundLineEndComment = false;
        int peekNum = ASUtils.findFirstNotOf(this.currentLine, " \t", startPos + 1);
        if (peekNum != -1) {
            int endNum;
            if (this.currentLine.indexOf("//", peekNum) == peekNum) {
                foundLineEndComment = true;
            } else if (this.currentLine.indexOf("/*", peekNum) == peekNum && (endNum = this.currentLine.indexOf("*/", peekNum + 2)) != -1 && ASUtils.findFirstNotOf(this.currentLine, " \t", endNum + 2) == -1) {
                foundLineEndComment = true;
            }
        }
        return foundLineEndComment;
    }

    private boolean getNextChar() {
        this.isInLineBreak = false;
        this.previousChar = this.currentChar;
        if (!Character.isWhitespace(this.currentChar)) {
            this.previousNonWSChar = this.currentChar;
            if (!(this.isInComment || this.isInLineComment || this.isInQuote || this.isImmediatelyPostComment || this.isImmediatelyPostLineComment || this.isSequenceReached("/*") || this.isSequenceReached("//"))) {
                this.previousCommandChar = this.currentChar;
            }
        }
        if (this.charNum + 1 < this.currentLine.length() && (!Character.isWhitespace(this.peekNextChar()) || this.isInComment || this.isInLineComment)) {
            this.currentChar = this.currentLine.charAt(++this.charNum);
            if (this.shouldConvertTabs && this.currentChar == '\t') {
                this.convertTabToSpaces();
            }
            return true;
        }
        return this.getNextLine();
    }

    private boolean getNextLine() {
        return this.getNextLine(false);
    }

    private boolean getNextLine(boolean emptyLineWasDeleted) {
        if (this.sourceIterator.hasMoreLines()) {
            this.currentLine.delete(0, this.currentLine.length());
            this.currentLine.append((CharSequence)this.sourceIterator.nextLine(emptyLineWasDeleted));
            this.spacePadNum = 0;
            ++this.inLineNumber;
            this.isInCase = false;
            this.isInQuoteContinuation = this.isInVerbatimQuote | this.haveLineContinuationChar;
            this.haveLineContinuationChar = false;
            this.isImmediatelyPostEmptyLine = this.lineIsEmpty;
            this.previousChar = (char)32;
            if (this.currentLine.length() == 0) {
                this.currentLine.append(" ");
            }
            if (!this.isVirgin) {
                this.isInLineBreak = true;
            } else {
                this.isVirgin = false;
            }
            this.isImmediatelyPostPreprocessor = this.isInPreprocessor;
            if (this.previousNonWSChar != '\\' || ASUtils.findFirstNotOf(this.currentLine, " \t", 0) == -1) {
                this.isInPreprocessor = false;
            }
            this.trimNewLine();
            this.currentChar = this.currentLine.charAt(this.charNum);
            if (this.shouldConvertTabs && this.currentChar == '\t') {
                this.convertTabToSpaces();
            }
            if (this.shouldDeleteEmptyLines && this.lineIsEmpty && this.isBracketType((Integer)this.bracketTypeStack.get(this.bracketTypeStack.size() - 1), 16) && (!this.shouldBreakBlocks && !this.shouldBreakClosingHeaderBlocks || !this.isImmediatelyPostCommentOnly || !this.commentAndHeaderFollows())) {
                this.isInPreprocessor = this.isImmediatelyPostPreprocessor;
                this.lineIsEmpty = false;
                return this.getNextLine(true);
            }
            return true;
        }
        this.endOfCodeReached = true;
        return false;
    }

    private void trimNewLine() {
        int len = this.currentLine.length();
        int indent = this.getIndentLength();
        this.charNum = 0;
        this.tabIncrementIn = 0;
        if (this.isInComment || this.isInPreprocessor || this.isInQuoteContinuation) {
            return;
        }
        while (Character.isWhitespace(this.currentLine.charAt(this.charNum)) && this.charNum + 1 < len) {
            if (this.currentLine.charAt(this.charNum) == '\t') {
                this.tabIncrementIn += indent - 1 - (this.tabIncrementIn + this.charNum) % indent;
            }
            ++this.charNum;
        }
        this.isImmediatelyPostCommentOnly = this.lineIsLineCommentOnly || this.lineEndsInCommentOnly;
        this.lineIsLineCommentOnly = false;
        this.lineEndsInCommentOnly = false;
        this.doesLineStartComment = false;
        this.lineIsEmpty = false;
        if (this.isSequenceReached("/*")) {
            this.charNum = 0;
            this.tabIncrementIn = 0;
            this.doesLineStartComment = true;
        }
        if (this.isSequenceReached("//")) {
            this.lineIsLineCommentOnly = true;
        }
        if (Character.isWhitespace(this.currentLine.charAt(this.charNum)) && this.charNum + 1 >= this.currentLine.length()) {
            this.lineIsEmpty = true;
        }
    }

    private void appendSequence(String sequence, boolean canBreakLine) {
        if (canBreakLine && this.isInLineBreak) {
            this.breakLine();
        }
        this.formattedLine.append(sequence);
    }

    private void appendSequence(String sequence) {
        this.appendSequence(sequence, true);
    }

    private void appendSpacePad() {
        int len = this.formattedLine.length();
        if (len > 0 && !Character.isWhitespace(this.formattedLine.charAt(len - 1))) {
            this.formattedLine.append(' ');
            ++this.spacePadNum;
        }
    }

    private void appendSpaceAfter() {
        int len = this.currentLine.length();
        if (this.charNum + 1 < len && !Character.isWhitespace(this.currentLine.charAt(this.charNum + 1))) {
            this.formattedLine.append(' ');
            ++this.spacePadNum;
        }
    }

    private void breakLine() {
        this.isLineReady = true;
        this.isInLineBreak = false;
        this.spacePadNum = 0;
        this.formattedLineCommentNum = -1L;
        this.prependEmptyLine = this.isPrependPostBlockEmptyLineRequested;
        this.readyFormattedLine.delete(0, this.readyFormattedLine.length());
        this.readyFormattedLine.append((CharSequence)this.formattedLine);
        if (this.isAppendPostBlockEmptyLineRequested) {
            this.isAppendPostBlockEmptyLineRequested = false;
            this.isPrependPostBlockEmptyLineRequested = true;
        } else {
            this.isPrependPostBlockEmptyLineRequested = false;
        }
        this.formattedLine.delete(0, this.formattedLine.length());
    }

    private int getBracketType() {
        int returnVal;
        assert (this.currentChar == '{');
        if (this.previousNonWSChar == '=') {
            returnVal = 32;
        } else if (this.foundPreDefinitionHeader) {
            returnVal = 8;
            if (this.foundNamespaceHeader) {
                returnVal |= 1;
            } else if (this.foundClassHeader) {
                returnVal |= 2;
            } else if (this.foundInterfaceHeader) {
                returnVal |= 4;
            }
        } else {
            boolean isCommandType;
            boolean bl = isCommandType = this.foundPreCommandHeader || this.currentHeader != null && this.isNonParenHeader || this.previousCommandChar == ')' || this.previousCommandChar == ':' && !this.foundQuestionMark || this.previousCommandChar == ';' || (this.previousCommandChar == '{' || this.previousCommandChar == '}') && this.isPreviousBracketBlockRelated || this.isJavaStaticConstructor;
            if (!isCommandType && this.isSharpStyle() && this.isNextWordSharpNonParenHeader(this.charNum + 1)) {
                isCommandType = true;
                this.isSharpAccessor = true;
            }
            int n = returnVal = isCommandType ? 16 : 32;
        }
        if (this.isOneLineBlockReached()) {
            returnVal |= 0x40;
        }
        return returnVal;
    }

    private boolean isPointerOrReference() {
        boolean isPR;
        assert (this.currentChar == '*' || this.currentChar == '&');
        boolean bl = isPR = !this.isInPotentialCalculation || this.isBracketType(this.bracketTypeStack.peek(), 8) || !this.isLegalNameChar(this.previousNonWSChar) && this.previousNonWSChar != ')' && this.previousNonWSChar != ']';
        if (!isPR) {
            char nextChar = this.peekNextChar();
            isPR |= !Character.isWhitespace(nextChar) && nextChar != '-' && nextChar != '(' && nextChar != '[' && !this.isLegalNameChar(nextChar);
        }
        return isPR;
    }

    private boolean isUnaryOperator() {
        assert (this.currentChar == '+' || this.currentChar == '-');
        return (this.isCharImmediatelyPostReturn || !this.isLegalNameChar(this.previousCommandChar)) && this.previousCommandChar != '.' && this.previousCommandChar != '\"' && this.previousCommandChar != '\'' && this.previousCommandChar != ')' && this.previousCommandChar != ']';
    }

    private boolean isInExponent() {
        assert (this.currentChar == '+' || this.currentChar == '-');
        int formattedLineLength = this.formattedLine.length();
        if (formattedLineLength >= 2) {
            char prevPrevFormattedChar = this.formattedLine.charAt(formattedLineLength - 2);
            char prevFormattedChar = this.formattedLine.charAt(formattedLineLength - 1);
            return !(prevFormattedChar != 'e' && prevFormattedChar != 'E' || prevPrevFormattedChar != '.' && !Character.isDigit(prevPrevFormattedChar));
        }
        return false;
    }

    private boolean isOneLineBlockReached() {
        boolean isInComment = false;
        boolean isInQuote = false;
        int bracketCount = 1;
        int currentLineLength = this.currentLine.length();
        char quoteChar = ' ';
        for (int i = this.charNum + 1; i < currentLineLength; ++i) {
            char ch = this.currentLine.charAt(i);
            if (isInComment) {
                if (this.currentLine.indexOf("*/", i) != i) continue;
                isInComment = false;
                ++i;
                continue;
            }
            if (ch == '\\') {
                ++i;
                continue;
            }
            if (isInQuote) {
                if (ch != quoteChar) continue;
                isInQuote = false;
                continue;
            }
            if (ch == '\"' || ch == '\'') {
                isInQuote = true;
                quoteChar = ch;
                continue;
            }
            if (this.currentLine.indexOf("//", i) == i) break;
            if (this.currentLine.indexOf("/*", i) == i) {
                isInComment = true;
                ++i;
                continue;
            }
            if (ch == '{') {
                ++bracketCount;
            } else if (ch == '}') {
                --bracketCount;
            }
            if (bracketCount != 0) continue;
            return true;
        }
        return false;
    }

    private boolean lineBeginsWith(char charToCheck) {
        boolean beginsWith = false;
        int i = ASUtils.findFirstNotOf(this.currentLine, " \t", 0);
        if (i != -1 && this.currentLine.charAt(i) == charToCheck && i == this.charNum) {
            beginsWith = true;
        }
        return beginsWith;
    }

    private boolean isNextWordSharpNonParenHeader(int startChar) {
        StringBuilder nextText = this.peekNextText(new StringBuilder(this.currentLine.substring(startChar)));
        if (nextText.length() == 0 || !this.isCharPotentialHeader(nextText, 0)) {
            return false;
        }
        return this.findKeyword(nextText, 0, "get") || this.findKeyword(nextText, 0, "set") || this.findKeyword(nextText, 0, "add") || this.findKeyword(nextText, 0, "remove");
    }

    private boolean isNextCharOpeningBracket(int startChar) {
        StringBuilder nextText = this.peekNextText(new StringBuilder(this.currentLine.substring(startChar)));
        return nextText.charAt(0) == '{';
    }

    private StringBuilder peekNextText(StringBuilder firstLine) {
        return this.peekNextText(firstLine, false);
    }

    private StringBuilder peekNextText(StringBuilder firstLine, boolean endOnEmptyLine) {
        boolean isFirstLine = true;
        boolean needReset = false;
        StringBuilder nextLine = firstLine;
        int firstChar = -1;
        boolean isInComment = false;
        while (this.sourceIterator.hasMoreLines()) {
            if (isFirstLine) {
                isFirstLine = false;
            } else {
                nextLine = this.sourceIterator.peekNextLine();
                needReset = true;
            }
            firstChar = ASUtils.findFirstNotOf(nextLine, " \t", 0);
            if (firstChar == -1) {
                if (!endOnEmptyLine || isInComment) continue;
                break;
            }
            if (nextLine.indexOf("/*", firstChar) == firstChar) {
                isInComment = true;
            }
            if (isInComment) {
                if ((firstChar = nextLine.indexOf("*/", firstChar)) == -1) continue;
                firstChar += 2;
                isInComment = false;
                if ((firstChar = ASUtils.findFirstNotOf(nextLine, " \t", firstChar)) == -1) continue;
            }
            if (nextLine.indexOf("//", firstChar) == firstChar) continue;
        }
        if (needReset) {
            this.sourceIterator.peekReset();
        }
        nextLine = firstChar == -1 ? new StringBuilder("") : new StringBuilder(nextLine.substring(firstChar));
        return nextLine;
    }

    private void adjustComments() {
        assert (this.spacePadNum != 0);
        assert (this.currentLine.indexOf("//", this.charNum) == this.charNum || this.currentLine.indexOf("/*", this.charNum) == this.charNum);
        if (this.currentLine.indexOf("/*", this.charNum) == this.charNum) {
            int endNum = this.currentLine.indexOf("*/", this.charNum + 2);
            if (endNum == -1) {
                return;
            }
            if (ASUtils.findFirstNotOf(this.currentLine, " \t", endNum + 2) != -1) {
                return;
            }
        }
        int len = this.formattedLine.length();
        if (this.spacePadNum < 0) {
            int adjust = -this.spacePadNum;
            if (this.formattedLine.charAt(len - 1) != '\t') {
                this.formattedLine.append(ASUtils.repeat(adjust, ' '));
            }
        } else if (this.spacePadNum > 0) {
            int adjust = this.spacePadNum;
            if (ASUtils.findLastNotOf(this.formattedLine, " ") < len - adjust - 1 && this.formattedLine.charAt(len - 1) != '\t') {
                this.formattedLine.setLength(len - adjust);
            }
        }
    }

    private void appendCharInsideComments() {
        if (this.formattedLineCommentNum == -1L || this.isBeforeComment()) {
            this.appendCurrentChar();
            return;
        }
        assert (this.formattedLine.indexOf("//", (int)this.formattedLineCommentNum) == (int)this.formattedLineCommentNum || this.formattedLine.indexOf("/*", (int)this.formattedLineCommentNum) == (int)this.formattedLineCommentNum);
        int end = (int)this.formattedLineCommentNum;
        int beg = ASUtils.findLastNotOf(this.formattedLine, " \t", end - 1);
        if (beg == -1) {
            this.appendCurrentChar();
            return;
        }
        if (end - ++beg < 3) {
            this.formattedLine.insert(beg, ASUtils.repeat(3 - end + beg, ' '));
        }
        if (this.formattedLine.charAt(beg) == '\t') {
            this.formattedLine.insert(beg, ' ');
        }
        System.err.println(this.currentChar + ": " + this.formattedLine);
        this.formattedLine.setCharAt(beg + 1, this.currentChar);
    }

    private void padOperators(String newOperator) {
        boolean shouldPad;
        assert (newOperator != null);
        boolean bl = shouldPad = !(newOperator.equals("::") || newOperator.equals("()") || newOperator.equals("[]") || newOperator.equals("++") || newOperator.equals("--") || newOperator.equals("!") || newOperator.equals("~") || newOperator.equals("->") || newOperator.equals("-") && this.isInExponent() || (newOperator.equals("+") || newOperator.equals("-")) && (this.previousNonWSChar == '(' || this.previousNonWSChar == '=' || this.previousNonWSChar == ',') || newOperator.equals("+") && this.isInExponent() || this.isCharImmediatelyPostOperator || (newOperator.equals("*") || newOperator.equals("&")) && this.isPointerOrReference() || newOperator.equals("*") && (this.previousNonWSChar == '.' || this.previousNonWSChar == '>') || (this.isInTemplate || this.isCharImmediatelyPostTemplate) && (newOperator.equals("<") || newOperator.equals(">")) || newOperator.equals("<?") && this.peekNextChar(this.currentLine, this.charNum + 1) == '>' || newOperator.equals(">") && this.previousNonWSChar == '?' || this.isInCase);
        if (!(!shouldPad || this.isInBlParen || newOperator.equals(":") && !this.foundQuestionMark || newOperator.equals("?") && this.isSharpStyle() && this.currentLine.indexOf(":", this.charNum + 1) == -1)) {
            this.appendSpacePad();
        }
        this.appendSequence(newOperator);
        this.goForward(newOperator.length() - 1);
        if (newOperator.equals("()") || newOperator.equals("[]")) {
            this.parenStack.set(this.parenStack.size() - 1, this.parenStack.peek() - 1);
        }
        this.currentChar = newOperator.charAt(newOperator.length() - 1);
        if (!(!shouldPad || this.isInBlParen || this.isBeforeComment() || newOperator.equals("+") && this.isUnaryOperator() || newOperator.equals("-") && this.isUnaryOperator() || this.peek(1, 1).equals(";") || this.peek(1, 2).equals("::") || newOperator.equals("?") && this.isSharpStyle() && this.currentLine.charAt(this.charNum + 1) == '[')) {
            this.appendSpaceAfter();
        }
    }

    private String peek(int offset, int len) {
        if (this.charNum + offset + len > this.currentLine.length()) {
            return "";
        }
        return this.currentLine.substring(this.charNum + offset, this.charNum + offset + len);
    }

    private void padParens() {
        assert (this.currentChar == '(' || this.currentChar == ')');
        if (this.currentChar == '(') {
            int spacesOutsideToDelete = this.formattedLine.length() - 1;
            int spacesInsideToDelete = 0;
            if (this.shouldUnPadParens) {
                int lastChar = 32;
                boolean prevIsParenHeader = false;
                int i = ASUtils.findLastNotOf(this.formattedLine, " \t");
                if (i != -1) {
                    int start;
                    int end = i;
                    spacesOutsideToDelete -= i;
                    lastChar = this.formattedLine.charAt(i);
                    for (start = i; start > -1 && this.isLegalNameChar(this.formattedLine.charAt(start)); --start) {
                    }
                    String prevWord = this.formattedLine.substring(++start, end + 1);
                    String prevWordH = null;
                    if (prevWord.length() > 0 && this.isCharPotentialHeader(new StringBuilder(prevWord), 0)) {
                        prevWordH = this.findHeader(this.formattedLine, start, this.headers);
                    }
                    if (prevWordH != null) {
                        prevIsParenHeader = true;
                    } else if (prevWord.equals("return") || prevWord.equals("*")) {
                        prevIsParenHeader = true;
                    } else if (prevWord.equals("boolean") || prevWord.equals("int") || prevWord.equals("void") || prevWord.equals("void*") || prevWord.length() >= 6 && prevWord.indexOf("_t", prevWord.length() - 2) == prevWord.length() - 2 || prevWord.equals("BOOL") || prevWord.equals("DWORD") || prevWord.equals("HWND") || prevWord.equals("INT") || prevWord.equals("LPSTR") || prevWord.equals("VOID") || prevWord.equals("LPVOID")) {
                        prevIsParenHeader = true;
                    }
                }
                if (this.shouldPadParensOutside || prevIsParenHeader) {
                    --spacesOutsideToDelete;
                } else if (lastChar == 124 || lastChar == 38 || lastChar == 44 || lastChar == 62 && !this.foundCastOperator || lastChar == 60 || lastChar == 63 || lastChar == 58 || lastChar == 59 || lastChar == 61 || lastChar == 43 || lastChar == 45 || lastChar == 42 || lastChar == 47 || lastChar == 37 || lastChar == 94) {
                    --spacesOutsideToDelete;
                }
                if (spacesOutsideToDelete > 0) {
                    this.formattedLine.delete(i + 1, i + 1 + spacesOutsideToDelete);
                    this.spacePadNum -= spacesOutsideToDelete;
                }
            }
            char peekedCharOutside = this.peekNextChar();
            if (this.shouldPadParensOutside && (this.currentChar != '(' || peekedCharOutside != ')')) {
                this.appendSpacePad();
            }
            this.appendCurrentChar();
            if (this.shouldUnPadParens) {
                int j = ASUtils.findFirstNotOf(this.currentLine, " \t", this.charNum + 1);
                if (j != -1) {
                    spacesInsideToDelete = j - this.charNum - 1;
                }
                if (this.shouldPadParensInside) {
                    --spacesInsideToDelete;
                }
                if (spacesInsideToDelete > 0) {
                    this.currentLine.delete(this.charNum + 1, this.charNum + 1 + spacesInsideToDelete);
                    this.spacePadNum -= spacesInsideToDelete;
                }
                if (this.shouldConvertTabs && this.currentLine.length() > this.charNum && this.currentLine.charAt(this.charNum + 1) == '\t') {
                    this.currentLine.setCharAt(this.charNum + 1, ' ');
                }
            }
            char peekedCharInside = this.peekNextChar();
            if (this.shouldPadParensInside && (this.currentChar != '(' || peekedCharInside != ')')) {
                this.appendSpaceAfter();
            }
        } else if (this.currentChar == ')') {
            int spacesOutsideToDelete = 0;
            int spacesInsideToDelete = this.formattedLine.length();
            if (this.shouldUnPadParens) {
                int i = ASUtils.findLastNotOf(this.formattedLine, " \t");
                if (i != -1) {
                    spacesInsideToDelete = this.formattedLine.length() - 1 - i;
                }
                if (this.shouldPadParensInside) {
                    --spacesInsideToDelete;
                }
                if (spacesInsideToDelete > 0) {
                    this.formattedLine.delete(i + 1, i + 1 + spacesInsideToDelete);
                    this.spacePadNum -= spacesInsideToDelete;
                }
            }
            if (this.shouldPadParensInside && (this.previousChar != '(' || this.currentChar != ')')) {
                this.appendSpacePad();
            }
            this.appendCurrentChar();
            if (this.shouldUnPadParens) {
                int j = ASUtils.findFirstNotOf(this.currentLine, " \t", this.charNum + 1);
                if (j != -1 && (this.currentLine.charAt(j) == '[' || this.currentLine.charAt(j) == ']')) {
                    spacesOutsideToDelete = j - this.charNum - 1;
                }
                if (this.shouldPadParensOutside) {
                    --spacesOutsideToDelete;
                }
                if (spacesOutsideToDelete > 0) {
                    this.currentLine.delete(this.charNum + 1, this.charNum + 1 + spacesOutsideToDelete);
                    this.spacePadNum -= spacesOutsideToDelete;
                }
            }
            char peekedCharOutside = this.peekNextChar();
            if (this.shouldPadParensOutside && peekedCharOutside != ';' && peekedCharOutside != ',' && peekedCharOutside != '.' && peekedCharOutside != '-') {
                this.appendSpaceAfter();
            }
        }
    }

    private void formatBrackets(int bracketType) {
        assert (!this.isBracketType(bracketType, 32));
        assert (this.currentChar == '{' || this.currentChar == '}');
        if (this.currentChar == '{') {
            this.parenStack.add(0);
        } else if (this.currentChar == '}' && this.parenStack.size() > 1) {
            this.parenStack.pop();
        }
        if (this.currentChar == '{') {
            boolean breakBracket = false;
            if (this.bracketFormatMode == EnumBracketMode.NONE) {
                if (this.lineBeginsWith('{')) {
                    breakBracket = true;
                }
            } else if (this.bracketFormatMode == EnumBracketMode.BREAK) {
                breakBracket = true;
            } else if (this.bracketFormatMode == EnumBracketMode.LINUX || this.bracketFormatMode == EnumBracketMode.STROUSTRUP) {
                int bracketTypeStackEnd = this.bracketTypeStack.size() - 1;
                if (this.isBracketType((Integer)this.bracketTypeStack.get(bracketTypeStackEnd), 2)) {
                    if (this.bracketFormatMode == EnumBracketMode.LINUX) {
                        breakBracket = true;
                    }
                } else if (this.isBracketType((Integer)this.bracketTypeStack.get(bracketTypeStackEnd), 1) || this.isBracketType((Integer)this.bracketTypeStack.get(bracketTypeStackEnd), 4)) {
                    if (this.bracketFormatMode == EnumBracketMode.LINUX) {
                        breakBracket = true;
                    }
                } else if (bracketTypeStackEnd == 1 && this.isBracketType((Integer)this.bracketTypeStack.get(bracketTypeStackEnd), 16)) {
                    breakBracket = true;
                } else if (bracketTypeStackEnd > 1) {
                    if (this.isBracketType((Integer)this.bracketTypeStack.get(bracketTypeStackEnd - 1), 1)) {
                        if (this.isBracketType((Integer)this.bracketTypeStack.get(bracketTypeStackEnd), 16)) {
                            breakBracket = true;
                        }
                    } else if (!this.isCStyle() && this.isBracketType((Integer)this.bracketTypeStack.get(bracketTypeStackEnd - 1), 2) && this.isBracketType((Integer)this.bracketTypeStack.get(bracketTypeStackEnd), 16)) {
                        breakBracket = true;
                    }
                }
            }
            if (breakBracket) {
                if (this.isBeforeComment() && (this.shouldBreakOneLineBlocks || !this.isBracketType(bracketType, 64))) {
                    if (this.isBeforeLineEndComment(this.charNum) && !this.lineBeginsWith('{')) {
                        this.currentChar = (char)32;
                        this.appendOpeningBracket = true;
                    } else {
                        this.breakLine();
                    }
                } else if (!this.isBracketType(bracketType, 64)) {
                    this.breakLine();
                } else if (this.shouldBreakOneLineBlocks && this.peekNextChar() != '}') {
                    this.breakLine();
                } else if (!this.isInLineBreak) {
                    this.appendSpacePad();
                }
                this.appendCurrentChar();
            } else if (this.isCharImmediatelyPostComment || this.isCharImmediatelyPostLineComment) {
                if ((this.shouldBreakOneLineBlocks || !this.isBracketType(bracketType, 64)) && this.peekNextChar() != '}' && this.previousCommandChar != '{' && this.previousCommandChar != '}' && this.previousCommandChar != ';') {
                    this.appendCharInsideComments();
                } else {
                    this.appendCurrentChar();
                }
            } else if (this.previousCommandChar == '{' || this.previousCommandChar == '}' || this.previousCommandChar == ';') {
                this.appendCurrentChar();
            } else {
                int firstChar = ASUtils.findFirstNotOf(this.formattedLine, " \t", 0);
                if (firstChar == -1) {
                    this.appendCurrentChar();
                } else if (!(!this.shouldBreakOneLineBlocks && this.isBracketType(bracketType, 64) && this.peekNextChar() != '}' || this.isImmediatelyPostPreprocessor && this.lineBeginsWith('{'))) {
                    this.appendSpacePad();
                    this.appendCurrentChar(false);
                } else {
                    if (!this.isInLineBreak) {
                        this.appendSpacePad();
                    }
                    this.appendCurrentChar();
                }
            }
        } else if (this.currentChar == '}') {
            if (this.previousCommandChar == '{') {
                this.isImmediatelyPostEmptyBlock = true;
            }
            if (!(this.previousCommandChar == '{' && this.isPreviousBracketBlockRelated || !this.shouldBreakOneLineBlocks && this.isBracketType(bracketType, 64) || this.isImmediatelyPostEmptyBlock)) {
                this.breakLine();
                this.appendCurrentChar();
            } else {
                if (!this.isCharImmediatelyPostComment && !this.isImmediatelyPostEmptyBlock) {
                    this.isInLineBreak = false;
                }
                this.appendCurrentChar();
            }
            if (this.isLegalNameChar(this.peekNextChar())) {
                this.appendSpaceAfter();
            }
            if (this.shouldBreakBlocks && this.currentHeader != null && this.parenStack.peek() == 0) {
                this.isAppendPostBlockEmptyLineRequested = true;
            }
        }
    }

    private void formatArrayBrackets(int bracketType, boolean isOpeningArrayBracket) {
        assert (this.isBracketType(bracketType, 32));
        assert (this.currentChar == '{' || this.currentChar == '}');
        if (this.currentChar == '{') {
            if (isOpeningArrayBracket) {
                if (this.bracketFormatMode == EnumBracketMode.ATTACH || this.bracketFormatMode == EnumBracketMode.LINUX || this.bracketFormatMode == EnumBracketMode.STROUSTRUP) {
                    if (this.isImmediatelyPostPreprocessor && this.lineBeginsWith('{')) {
                        this.isInLineBreak = true;
                        this.appendCurrentChar();
                    } else if (this.isCharImmediatelyPostComment || this.isCharImmediatelyPostLineComment) {
                        this.appendCharInsideComments();
                    } else {
                        int firstChar = ASUtils.findFirstNotOf(this.formattedLine, " \t", 0);
                        if (firstChar == -1) {
                            this.appendCurrentChar();
                        } else {
                            if (this.lineBeginsWith('{') || this.previousNonWSChar != '=') {
                                this.appendSpacePad();
                            }
                            this.appendCurrentChar(false);
                        }
                    }
                } else if (this.bracketFormatMode == EnumBracketMode.BREAK) {
                    if (Character.isWhitespace(this.peekNextChar())) {
                        this.breakLine();
                    } else if (this.isBeforeComment() && this.isBeforeLineEndComment(this.charNum)) {
                        this.currentChar = (char)32;
                        this.appendOpeningBracket = true;
                    }
                    if (!this.isInLineBreak && this.previousNonWSChar != '=') {
                        this.appendSpacePad();
                    }
                    this.appendCurrentChar();
                } else if (this.bracketFormatMode == EnumBracketMode.NONE) {
                    if (this.lineBeginsWith('{')) {
                        this.appendCurrentChar();
                    } else {
                        if (this.lineBeginsWith('{') || this.previousNonWSChar != '=') {
                            this.appendSpacePad();
                        }
                        this.appendCurrentChar(false);
                    }
                }
            } else {
                this.appendCurrentChar();
            }
            char nextChar = this.peekNextChar();
            if (Character.isWhitespace(nextChar) || this.isBeforeLineEndComment(this.charNum) || nextChar == '{') {
                this.isNonInStatementArray = true;
            }
            if (this.isJavaStyle() && this.previousNonWSChar == ']') {
                this.isNonInStatementArray = false;
            }
        } else if (this.currentChar == '}') {
            if (isOpeningArrayBracket && !this.isBracketType(bracketType, 64)) {
                this.breakLine();
                this.appendCurrentChar();
            } else {
                this.appendCurrentChar();
            }
            if (this.isLegalNameChar(this.peekNextChar())) {
                this.appendSpaceAfter();
            }
        }
    }

    private void convertTabToSpaces() {
        assert (this.currentLine.charAt(this.charNum) == '\t');
        if (this.isInQuote || this.isInQuoteContinuation) {
            return;
        }
        int indent = this.getIndentLength();
        int numSpaces = indent - (this.tabIncrementIn + this.charNum) % indent;
        String spaces = ASUtils.repeat(numSpaces, ' ');
        this.currentLine.replace(this.charNum, this.charNum + numSpaces, spaces);
        this.currentChar = this.currentLine.charAt(this.charNum);
    }

    private void checkForFollowingHeader(StringBuilder firstLine) {
        boolean isClosingHeader;
        StringBuilder nextText = this.peekNextText(firstLine, true);
        if (nextText.length() == 0 || !this.isCharPotentialHeader(nextText, 0)) {
            return;
        }
        String newHeader = this.findHeader(nextText, 0, this.headers);
        if (newHeader == null) {
            return;
        }
        boolean bl = isClosingHeader = newHeader.equals("else") || newHeader.equals("catch") || newHeader.equals("finally");
        if (isClosingHeader) {
            if (!this.shouldBreakClosingHeaderBlocks) {
                this.isPrependPostBlockEmptyLineRequested = false;
            }
        } else {
            this.isPrependPostBlockEmptyLineRequested = true;
        }
    }

    private void processPreprocessor() {
        int addedPreproc;
        assert (this.currentLine.charAt(this.charNum) == '#');
        int preproc = this.charNum + 1;
        if (this.currentLine.indexOf("if", preproc) == preproc) {
            this.preprocBracketTypeStackSize = this.bracketTypeStack.size();
        } else if (this.currentLine.indexOf("else", preproc) == preproc && (addedPreproc = this.bracketTypeStack.size() - this.preprocBracketTypeStackSize) > 0) {
            for (int i = 0; i < addedPreproc; ++i) {
                this.bracketTypeStack.pop();
            }
        }
    }

    private boolean commentAndHeaderFollows() {
        boolean isClosingHeader;
        StringBuilder nextLine = this.sourceIterator.peekNextLine();
        int firstChar = ASUtils.findFirstNotOf(nextLine, " \t", 0);
        if (firstChar == -1 || nextLine.indexOf("//", firstChar) != firstChar && nextLine.indexOf("/*", firstChar) != firstChar) {
            this.sourceIterator.peekReset();
            return false;
        }
        StringBuilder nextText = this.peekNextText(nextLine, true);
        if (nextText.length() == 0 || !this.isCharPotentialHeader(nextText, 0)) {
            return false;
        }
        String newHeader = this.findHeader(nextText, 0, this.headers);
        if (newHeader == null) {
            return false;
        }
        boolean bl = isClosingHeader = newHeader.equals("else") || newHeader.equals("catch") || newHeader.equals("finally");
        return !isClosingHeader || this.shouldBreakClosingHeaderBlocks;
    }

    private String findHeader(List<String> headers) {
        return this.findHeader(this.currentLine, this.charNum, headers);
    }

    private String findOperator(List<String> headers) {
        return this.findOperator(this.currentLine.toString(), this.charNum, headers);
    }

    private void appendChar(char ch, boolean canBreakLine) {
        if (canBreakLine && this.isInLineBreak) {
            this.breakLine();
        }
        this.formattedLine.append(ch);
        this.isImmediatelyPostCommentOnly = false;
    }

    private void appendCurrentChar() {
        this.appendChar(this.currentChar, true);
    }

    private void appendCurrentChar(boolean canBreakLine) {
        this.appendChar(this.currentChar, canBreakLine);
    }

    private boolean isSequenceReached(String sequence) {
        return this.currentLine.indexOf(sequence, this.charNum) == this.charNum;
    }

    public String gtSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suff) {
        this.suffix = suff;
    }
}

