/*
 * Decompiled with CFR 0.152.
 */
package com.github.abrarsyed.jastyle;

import com.github.abrarsyed.jastyle.SortOnLength;
import com.github.abrarsyed.jastyle.SortOnName;
import com.github.abrarsyed.jastyle.constants.SourceMode;
import java.util.Collections;
import java.util.List;

public class ASResource {
    public static final String AS_IF = "if";
    public static final String AS_ELSE = "else";
    public static final String AS_FOR = "for";
    public static final String AS_DO = "do";
    public static final String AS_WHILE = "while";
    public static final String AS_SWITCH = "switch";
    public static final String AS_CASE = "case";
    public static final String AS_DEFAULT = "default";
    public static final String AS_CLASS = "class";
    public static final String AS_STRUCT = "struct";
    public static final String AS_UNION = "union";
    public static final String AS_INTERFACE = "interface";
    public static final String AS_NAMESPACE = "namespace";
    public static final String AS_STATIC = "static";
    public static final String AS_SYNCHRONIZED = "synchronized";
    public static final String AS_OPERATOR = "operator";
    public static final String AS_TEMPLATE = "template";
    public static final String AS_TRY = "try";
    public static final String AS_CATCH = "catch";
    public static final String AS_FINALLY = "finally";
    public static final String AS_THROWS = "throws";
    public static final String AS_CONST = "";
    public static final String AS_WHERE = "where";
    public static final String AS_NEW = "new";
    public static final String AS_BAR_EL = "#el";
    public static final String AS_BAR_ENDIF = "#endif";
    public static final String AS_OPEN_BRACKET = "{";
    public static final String AS_CLOSE_BRACKET = "}";
    public static final String AS_OPEN_LINE_COMMENT = "//";
    public static final String AS_OPEN_COMMENT = "/*";
    public static final String AS_CLOSE_COMMENT = "*/";
    public static final String AS_ASSIGN = "=";
    public static final String AS_PLUS_ASSIGN = "+=";
    public static final String AS_MINUS_ASSIGN = "-=";
    public static final String AS_MULT_ASSIGN = "*=";
    public static final String AS_DIV_ASSIGN = "/=";
    public static final String AS_MOD_ASSIGN = "%=";
    public static final String AS_OR_ASSIGN = "|=";
    public static final String AS_AND_ASSIGN = "&=";
    public static final String AS_XOR_ASSIGN = "^=";
    public static final String AS_GR_GR_ASSIGN = ">>=";
    public static final String AS_LS_LS_ASSIGN = "<<=";
    public static final String AS_GR_GR_GR_ASSIGN = ">>>=";
    public static final String AS_LS_LS_LS_ASSIGN = "<<<=";
    public static final String AS_GCC_MIN_ASSIGN = "<?";
    public static final String AS_GCC_MAX_ASSIGN = ">?";
    public static final String AS_RETURN = "return";
    public static final String AS_CIN = "cin";
    public static final String AS_COUT = "cout";
    public static final String AS_CERR = "cerr";
    public static final String AS_EQUAL = "==";
    public static final String AS_PLUS_PLUS = "++";
    public static final String AS_MINUS_MINUS = "--";
    public static final String AS_NOT_EQUAL = "!=";
    public static final String AS_GR_EQUAL = ">=";
    public static final String AS_GR_GR = ">>";
    public static final String AS_GR_GR_GR = ">>>";
    public static final String AS_LS_EQUAL = "<=";
    public static final String AS_LS_LS = "<<";
    public static final String AS_LS_LS_LS = "<<<";
    public static final String AS_QUESTION_QUESTION = "??";
    public static final String AS_EQUAL_GR = "=>";
    public static final String AS_ARROW = "->";
    public static final String AS_AND = "&&";
    public static final String AS_OR = "||";
    public static final String AS_COLON_COLON = "::";
    public static final String AS_PAREN_PAREN = "()";
    public static final String AS_BLPAREN_BLPAREN = "[]";
    public static final String AS_PLUS = "+";
    public static final String AS_MINUS = "-";
    public static final String AS_MULT = "*";
    public static final String AS_DIV = "/";
    public static final String AS_MOD = "%";
    public static final String AS_GR = ">";
    public static final String AS_LS = "<";
    public static final String AS_NOT = "!";
    public static final String AS_BIT_OR = "|";
    public static final String AS_BIT_AND = "&";
    public static final String AS_BIT_NOT = "~";
    public static final String AS_BIT_XOR = "^";
    public static final String AS_QUESTION = "?";
    public static final String AS_COLON = ":";
    public static final String AS_COMMA = ",";
    public static final String AS_SEMICOLON = ";";
    public static final String AS_FOREACH = "foreach";
    public static final String AS_LOCK = "lock";
    public static final String AS_UNSAFE = "unsafe";
    public static final String AS_FIXED = "fixed";
    public static final String AS_GET = "get";
    public static final String AS_SET = "set";
    public static final String AS_ADD = "add";
    public static final String AS_REMOVE = "remove";
    public static final String AS_CONST_CAST = "const_cast";
    public static final String AS_DYNAMIC_CAST = "dynamic_cast";
    public static final String AS_REINTERPRET_CAST = "reinterpret_cast";
    public static final String AS_STATIC_CAST = "static_cast";

    public static void buildAssignmentOperators(List<String> assignmentOperators) {
        assignmentOperators.add(AS_ASSIGN);
        assignmentOperators.add(AS_PLUS_ASSIGN);
        assignmentOperators.add(AS_MINUS_ASSIGN);
        assignmentOperators.add(AS_MULT_ASSIGN);
        assignmentOperators.add(AS_DIV_ASSIGN);
        assignmentOperators.add(AS_MOD_ASSIGN);
        assignmentOperators.add(AS_OR_ASSIGN);
        assignmentOperators.add(AS_AND_ASSIGN);
        assignmentOperators.add(AS_XOR_ASSIGN);
        assignmentOperators.add(AS_GR_GR_GR_ASSIGN);
        assignmentOperators.add(AS_GR_GR_ASSIGN);
        assignmentOperators.add(AS_LS_LS_ASSIGN);
        assignmentOperators.add(AS_LS_LS_LS_ASSIGN);
        Collections.sort(assignmentOperators, new SortOnLength());
    }

    public static void buildCastOperators(List<String> castOperators) {
        castOperators.add(AS_CONST_CAST);
        castOperators.add(AS_DYNAMIC_CAST);
        castOperators.add(AS_REINTERPRET_CAST);
        castOperators.add(AS_STATIC_CAST);
    }

    public static void buildHeaders(List<String> headers, SourceMode fileType, boolean beautifier) {
        headers.add(AS_IF);
        headers.add(AS_ELSE);
        headers.add(AS_FOR);
        headers.add(AS_WHILE);
        headers.add(AS_DO);
        headers.add(AS_SWITCH);
        headers.add(AS_TRY);
        headers.add(AS_CATCH);
        if (fileType == SourceMode.JAVA) {
            headers.add(AS_FINALLY);
            headers.add(AS_SYNCHRONIZED);
        }
        if (fileType == SourceMode.CS) {
            headers.add(AS_FINALLY);
            headers.add(AS_FOREACH);
            headers.add(AS_LOCK);
            headers.add(AS_FIXED);
            headers.add(AS_GET);
            headers.add(AS_SET);
            headers.add(AS_ADD);
            headers.add(AS_REMOVE);
        }
        if (beautifier) {
            headers.add(AS_CASE);
            headers.add(AS_DEFAULT);
            if (fileType == SourceMode.C) {
                headers.add(AS_CONST);
                headers.add(AS_TEMPLATE);
            }
            if (fileType == SourceMode.JAVA) {
                headers.add(AS_STATIC);
            }
        }
        Collections.sort(headers, new SortOnName());
    }

    public static void buildIndentableHeaders(List<String> indentableHeaders) {
        indentableHeaders.add(AS_RETURN);
        indentableHeaders.add(AS_COUT);
        indentableHeaders.add(AS_CERR);
        indentableHeaders.add(AS_CIN);
        Collections.sort(indentableHeaders, new SortOnName());
    }

    public static void buildNonAssignmentOperators(List<String> nonAssignmentOperators) {
        nonAssignmentOperators.add(AS_EQUAL);
        nonAssignmentOperators.add(AS_PLUS_PLUS);
        nonAssignmentOperators.add(AS_MINUS_MINUS);
        nonAssignmentOperators.add(AS_NOT_EQUAL);
        nonAssignmentOperators.add(AS_GR_EQUAL);
        nonAssignmentOperators.add(AS_GR_GR_GR);
        nonAssignmentOperators.add(AS_GR_GR);
        nonAssignmentOperators.add(AS_LS_EQUAL);
        nonAssignmentOperators.add(AS_LS_LS_LS);
        nonAssignmentOperators.add(AS_LS_LS);
        nonAssignmentOperators.add(AS_ARROW);
        nonAssignmentOperators.add(AS_AND);
        nonAssignmentOperators.add(AS_OR);
        Collections.sort(nonAssignmentOperators, new SortOnLength());
    }

    public static void buildNonParenHeaders(List<String> nonParenHeaders, SourceMode fileType, boolean beautifier) {
        nonParenHeaders.add(AS_ELSE);
        nonParenHeaders.add(AS_DO);
        nonParenHeaders.add(AS_TRY);
        if (fileType == SourceMode.JAVA) {
            nonParenHeaders.add(AS_FINALLY);
        } else if (fileType == SourceMode.CS) {
            nonParenHeaders.add(AS_CATCH);
            nonParenHeaders.add(AS_FINALLY);
            nonParenHeaders.add(AS_GET);
            nonParenHeaders.add(AS_SET);
            nonParenHeaders.add(AS_ADD);
            nonParenHeaders.add(AS_REMOVE);
        }
        if (beautifier) {
            nonParenHeaders.add(AS_CASE);
            nonParenHeaders.add(AS_DEFAULT);
            if (fileType == SourceMode.C) {
                nonParenHeaders.add(AS_CONST);
                nonParenHeaders.add(AS_TEMPLATE);
            } else if (fileType == SourceMode.JAVA) {
                nonParenHeaders.add(AS_STATIC);
            }
        }
        Collections.sort(nonParenHeaders, new SortOnName());
    }

    public static void buildOperators(List<String> operators) {
        operators.add(AS_PLUS_ASSIGN);
        operators.add(AS_MINUS_ASSIGN);
        operators.add(AS_MULT_ASSIGN);
        operators.add(AS_DIV_ASSIGN);
        operators.add(AS_MOD_ASSIGN);
        operators.add(AS_OR_ASSIGN);
        operators.add(AS_AND_ASSIGN);
        operators.add(AS_XOR_ASSIGN);
        operators.add(AS_EQUAL);
        operators.add(AS_PLUS_PLUS);
        operators.add(AS_MINUS_MINUS);
        operators.add(AS_NOT_EQUAL);
        operators.add(AS_GR_EQUAL);
        operators.add(AS_GR_GR_GR_ASSIGN);
        operators.add(AS_GR_GR_ASSIGN);
        operators.add(AS_GR_GR_GR);
        operators.add(AS_GR_GR);
        operators.add(AS_LS_EQUAL);
        operators.add(AS_LS_LS_LS_ASSIGN);
        operators.add(AS_LS_LS_ASSIGN);
        operators.add(AS_LS_LS_LS);
        operators.add(AS_LS_LS);
        operators.add(AS_QUESTION_QUESTION);
        operators.add(AS_EQUAL_GR);
        operators.add(AS_GCC_MIN_ASSIGN);
        operators.add(AS_GCC_MAX_ASSIGN);
        operators.add(AS_ARROW);
        operators.add(AS_AND);
        operators.add(AS_OR);
        operators.add(AS_COLON_COLON);
        operators.add(AS_PLUS);
        operators.add(AS_MINUS);
        operators.add(AS_MULT);
        operators.add(AS_DIV);
        operators.add(AS_MOD);
        operators.add(AS_QUESTION);
        operators.add(AS_COLON);
        operators.add(AS_ASSIGN);
        operators.add(AS_LS);
        operators.add(AS_GR);
        operators.add(AS_NOT);
        operators.add(AS_BIT_OR);
        operators.add(AS_BIT_AND);
        operators.add(AS_BIT_NOT);
        operators.add(AS_BIT_XOR);
        Collections.sort(operators, new SortOnLength());
    }

    public static void buildPreBlockStatements(List<String> preBlockStatements, SourceMode fileType) {
        preBlockStatements.add(AS_CLASS);
        if (fileType == SourceMode.C) {
            preBlockStatements.add(AS_STRUCT);
            preBlockStatements.add(AS_UNION);
            preBlockStatements.add(AS_NAMESPACE);
        } else if (fileType == SourceMode.JAVA) {
            preBlockStatements.add(AS_INTERFACE);
            preBlockStatements.add(AS_THROWS);
        } else if (fileType == SourceMode.CS) {
            preBlockStatements.add(AS_INTERFACE);
            preBlockStatements.add(AS_NAMESPACE);
            preBlockStatements.add(AS_WHERE);
        }
        Collections.sort(preBlockStatements, new SortOnName());
    }

    public static void buildPreCommandHeaders(List<String> preCommandHeaders, SourceMode fileType) {
        if (fileType == SourceMode.C) {
            preCommandHeaders.add(AS_CONST);
        } else if (fileType == SourceMode.JAVA) {
            preCommandHeaders.add(AS_THROWS);
        } else if (fileType == SourceMode.CS) {
            preCommandHeaders.add(AS_WHERE);
        }
        Collections.sort(preCommandHeaders, new SortOnName());
    }

    public static void buildPreDefinitionHeaders(List<String> preDefinitionHeaders, SourceMode fileType) {
        preDefinitionHeaders.add(AS_CLASS);
        if (fileType == SourceMode.C) {
            preDefinitionHeaders.add(AS_STRUCT);
            preDefinitionHeaders.add(AS_UNION);
            preDefinitionHeaders.add(AS_NAMESPACE);
        } else if (fileType == SourceMode.JAVA) {
            preDefinitionHeaders.add(AS_INTERFACE);
        } else if (fileType == SourceMode.CS) {
            preDefinitionHeaders.add(AS_INTERFACE);
            preDefinitionHeaders.add(AS_NAMESPACE);
        }
        Collections.sort(preDefinitionHeaders, new SortOnName());
    }
}

