/*
 * Decompiled with CFR 0.152.
 */
package com.github.abrarsyed.jastyle;

import com.github.abrarsyed.jastyle.ASSourceIterator;
import com.github.abrarsyed.jastyle.reader.ExtendedReader;
import java.io.IOException;
import java.io.Reader;

public class ASStreamIterator
implements ASSourceIterator {
    private boolean peekSet = true;
    private ExtendedReader inStream;
    private StringBuilder buffer;
    private int eolWindows;
    private int eolLinux;
    private int eolMacOld;
    private String outputEOL;
    private static final int MAX_PEEK = 256;

    public ASStreamIterator(Reader in) {
        this.inStream = new ExtendedReader(in);
        this.eolMacOld = 0;
        this.eolLinux = 0;
        this.eolWindows = 0;
    }

    @Override
    public StringBuilder nextLine() {
        return this.nextLine(false);
    }

    @Override
    public StringBuilder nextLine(boolean emptyLineWasDeleted) {
        try {
            this.buffer = new StringBuilder();
            int ch = this.inStream.read();
            while (ch > 0 && ch != 10 && ch != 13) {
                this.buffer.append((char)ch);
                ch = this.inStream.read();
            }
            if (ch <= 0) {
                return this.buffer;
            }
            int peekCh = this.inStream.peek();
            if (peekCh > 0) {
                if (ch == 13) {
                    if (peekCh == 10) {
                        ch = (char)this.inStream.read();
                        ++this.eolWindows;
                    } else {
                        ++this.eolMacOld;
                    }
                } else if (peekCh == 13) {
                    ch = (char)this.inStream.read();
                    ++this.eolWindows;
                } else {
                    ++this.eolLinux;
                }
            }
            this.outputEOL = this.eolWindows >= this.eolLinux ? (this.eolWindows >= this.eolMacOld ? "\r\n" : "\r") : (this.eolLinux >= this.eolMacOld ? "\n" : "\r");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.buffer;
    }

    @Override
    public StringBuilder peekNextLine() {
        StringBuilder nextLine = new StringBuilder();
        try {
            if (this.peekSet) {
                this.peekSet = false;
                this.inStream.mark(256);
            }
            int ch = this.inStream.read();
            while (ch > 0 && ch != 10 && ch != 13) {
                nextLine.append((char)ch);
                ch = this.inStream.read();
            }
            if (ch <= 0) {
                return nextLine;
            }
            int peekCh = this.inStream.peek();
            if (peekCh > 0 && (peekCh == 10 || peekCh == 13) && peekCh != ch) {
                this.inStream.read();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getCause());
        }
        return nextLine;
    }

    @Override
    public boolean hasMoreLines() {
        boolean hasMoreLines = false;
        try {
            hasMoreLines = !this.inStream.isEndOfStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return hasMoreLines;
    }

    @Override
    public String getOutputEOL() {
        return this.outputEOL;
    }

    @Override
    public void peekReset() {
        try {
            if (!this.peekSet) {
                this.peekSet = true;
                this.inStream.reset();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

