/*
 * Decompiled with CFR 0.152.
 */
package com.github.abrarsyed.jastyle;

import com.github.abrarsyed.jastyle.ASUtils;
import com.github.abrarsyed.jastyle.constants.SourceMode;

public class AbstractASBase {
    protected SourceMode fileType;

    protected void init(SourceMode fileTypeArg) {
        this.fileType = fileTypeArg;
    }

    protected boolean isCStyle() {
        return this.fileType == SourceMode.C;
    }

    protected boolean isJavaStyle() {
        return this.fileType == SourceMode.JAVA;
    }

    protected boolean isSharpStyle() {
        return this.fileType == SourceMode.CS;
    }

    protected boolean isLegalNameChar(char ch) {
        if (Character.isWhitespace(ch)) {
            return false;
        }
        if (ch > '\u007f') {
            return false;
        }
        return Character.isLetterOrDigit(ch) || ch == '.' || ch == '_' || this.isJavaStyle() && ch == '$' || this.isSharpStyle() && ch == '@';
    }

    protected boolean isCharPotentialHeader(StringBuilder line, int i) {
        if (Character.isWhitespace(line.charAt(i))) {
            throw new IllegalArgumentException("White spaces not permitted at position " + i);
        }
        char prevCh = ' ';
        if (i > 0) {
            prevCh = line.charAt(i - 1);
        }
        return !this.isLegalNameChar(prevCh) && this.isLegalNameChar(line.charAt(i));
    }

    protected boolean isCharPotentialOperator(char ch) {
        assert (!Character.isWhitespace(ch)) : "White spaces not permitted as a Potential Operator";
        if (ch > '\u007f') {
            return false;
        }
        return ASUtils.isPunct(ch) && ch != '{' && ch != '}' && ch != '(' && ch != ')' && ch != '[' && ch != ']' && ch != ';' && ch != ',' && ch != '#' && ch != '\\' && ch != '\'' && ch != '\"';
    }

    protected char peekNextChar(StringBuilder line, int start) {
        int peekNum = ASUtils.findFirstNotOf(line, " \t", start + 1);
        if (peekNum == -1) {
            return ' ';
        }
        return line.charAt(peekNum);
    }

    protected boolean findKeyword(StringBuilder line, int i, String keyword) {
        assert (this.isCharPotentialHeader(line, i)) : line + " is not a potential header";
        int keywordLength = keyword.length();
        if (line.indexOf(keyword, i) != i) {
            return false;
        }
        int wordEnd = i + keywordLength;
        if (wordEnd == line.length()) {
            return true;
        }
        if (this.isLegalNameChar(line.charAt(wordEnd))) {
            return false;
        }
        char peekChar = this.peekNextChar(line, wordEnd - 1);
        return peekChar != ',' && peekChar != ')';
    }

    protected String getCurrentWord(StringBuilder line, int charNum) {
        int i;
        int lineLength = line.length();
        for (i = charNum; i < lineLength && this.isLegalNameChar(line.charAt(i)); ++i) {
        }
        return line.substring(charNum, i);
    }
}

