/*
 * Decompiled with CFR 0.152.
 */
package com.github.abrarsyed.jastyle;

import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Pattern;

public class FileWildcardFilter
implements FilenameFilter {
    private Pattern p;

    public FileWildcardFilter(String filenameWithWildcars) {
        this.p = Pattern.compile(this.replaceWildcards(filenameWithWildcars));
    }

    private String replaceWildcards(String wild) {
        StringBuilder buffer = new StringBuilder();
        for (char c : wild.toCharArray()) {
            if (c == '*') {
                buffer.append(".*");
                continue;
            }
            if (c == '?') {
                buffer.append(".");
                continue;
            }
            if ("+()^$.{}[]|\\".indexOf(c) != -1) {
                buffer.append('\\').append(c);
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    @Override
    public boolean accept(File dir, String name) {
        return this.p.matcher(name).matches();
    }
}

