/*
 * Decompiled with CFR 0.152.
 */
package com.github.abrarsyed.jastyle;

import com.github.abrarsyed.jastyle.ASFormatter;
import com.github.abrarsyed.jastyle.constants.EnumBracketMode;
import com.github.abrarsyed.jastyle.constants.EnumFormatStyle;
import com.github.abrarsyed.jastyle.constants.SourceMode;
import com.github.abrarsyed.jastyle.exceptions.MalformedOptionException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;

public class OptParser {
    public final ASFormatter formatter;

    public OptParser(ASFormatter formatter) {
        this.formatter = formatter;
    }

    private static void error() throws MalformedOptionException {
        throw new MalformedOptionException();
    }

    public ArrayList<String> parseOptionFile(File file) {
        try {
            ArrayList<String> errors = new ArrayList<String>();
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = reader.readLine();
            while (line != null) {
                if (!line.isEmpty() && !line.startsWith("#")) {
                    try {
                        this.parseOption(line.trim());
                    }
                    catch (MalformedOptionException ex) {
                        errors.add(line);
                    }
                }
                line = reader.readLine();
            }
            reader.close();
            return errors;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void parseOption(String opt) throws MalformedOptionException {
        if (opt.startsWith("--")) {
            this.parseLongOption(opt.replaceFirst("[-]{2}", ""));
        } else if (opt.startsWith("-")) {
            this.parseShortOption(opt.replaceFirst("[-]", ""));
        } else {
            this.parseLongOption(opt);
        }
    }

    private void parseLongOption(String opt) throws MalformedOptionException {
        if (opt.startsWith("--")) {
            throw new IllegalArgumentException("Trying to parse long option " + opt + " while it still cotnains a -");
        }
        if (opt.startsWith("style=")) {
            String temp = opt.substring(6);
            temp = temp.toUpperCase();
            temp = temp.replace("&", "");
            temp = temp.replace("/", "");
            try {
                this.formatter.setFormattingStyle(EnumFormatStyle.valueOf(temp));
            }
            catch (Exception e) {
                OptParser.error();
            }
        } else if (opt.startsWith("indent=")) {
            String temp = opt.substring(7);
            if (temp.startsWith("spaces")) {
                this.formatter.setSpaceIndentation(this.getLongOptNum(temp, 4));
            } else if (temp.startsWith("tab")) {
                this.formatter.setTabIndentation(this.getLongOptNum(temp, 4), false);
            } else if (temp.startsWith("force-tab")) {
                this.formatter.setTabIndentation(this.getLongOptNum(temp, 4), true);
            }
        } else if (opt.startsWith("indent-")) {
            String temp = opt.substring(7);
            if (temp.equals("classes")) {
                this.formatter.setClassIndent(true);
            } else if (temp.equals("switches")) {
                this.formatter.setSwitchIndent(true);
            } else if (temp.equals("cases")) {
                this.formatter.setCaseIndent(true);
            } else if (temp.equals("blocks")) {
                this.formatter.setBlockIndent(true);
            } else if (temp.equals("brackets")) {
                this.formatter.setBracketIndent(true);
            } else if (temp.equals("namespaces")) {
                this.formatter.setNamespaceIndent(true);
            } else if (temp.equals("labels")) {
                this.formatter.setLabelIndent(true);
            } else if (temp.equals("preprocessor")) {
                this.formatter.setPreprocessorIndent(true);
            }
        } else if (opt.startsWith("max-instatement-indent=")) {
            this.formatter.setMaxInStatementIndentLength(this.getLongOptNum(opt, 40));
        } else if (opt.startsWith("min-conditional-indent=")) {
            this.formatter.setMinConditionalIndentLength(this.getLongOptNum(opt, 8));
        } else if (opt.startsWith("brackets=")) {
            String temp = opt.substring(9);
            temp = temp.toUpperCase();
            try {
                this.formatter.setBracketFormatMode(EnumBracketMode.valueOf(temp));
            }
            catch (Exception e) {
                OptParser.error();
            }
        } else if (opt.startsWith("break-")) {
            String temp = opt.substring(6);
            if (temp.startsWith("blocks")) {
                this.formatter.setBreakBlocksMode(true);
                if (temp.contains("=all")) {
                    this.formatter.setBreakClosingHeaderBlocksMode(true);
                }
            } else if (temp.equals("closing-brackets")) {
                this.formatter.setBreakClosingHeaderBracketsMode(true);
            } else if (temp.equals("elseifs")) {
                this.formatter.setBreakElseIfsMode(true);
            }
        } else if (opt.startsWith("pad")) {
            String temp = opt.substring(4);
            if (temp.equals("oper")) {
                this.formatter.setOperatorPaddingMode(true);
            } else if (temp.startsWith("paren")) {
                if ((temp = temp.substring(5)).isEmpty()) {
                    this.formatter.setParensOutsidePaddingMode(true);
                    this.formatter.setParensInsidePaddingMode(true);
                } else if (temp.equals("out")) {
                    this.formatter.setParensOutsidePaddingMode(true);
                } else if (temp.equals("in")) {
                    this.formatter.setParensInsidePaddingMode(true);
                } else {
                    OptParser.error();
                }
            }
        } else if (opt.equals("unpad-paren")) {
            this.formatter.setParensUnPaddingMode(true);
        } else if (opt.startsWith("mode=")) {
            String temp = opt.substring(5);
            temp = temp.toUpperCase();
            try {
                this.formatter.setSourceStyle(SourceMode.valueOf(temp));
            }
            catch (Exception e) {
                OptParser.error();
            }
        } else if (opt.equals("delete-empty-lines")) {
            this.formatter.setDeleteEmptyLinesMode(true);
        } else if (opt.startsWith("keep-one-line")) {
            String temp = opt.substring(13);
            if (temp.equals("statements")) {
                this.formatter.setSingleStatementsMode(false);
            } else if (temp.equals("blocks")) {
                this.formatter.setBreakOneLineBlocksMode(false);
            } else {
                OptParser.error();
            }
        } else if (opt.startsWith("suffix=")) {
            String temp = opt.substring(7);
            if (temp.equals("none")) {
                this.formatter.setSuffix(null);
            } else if (!temp.isEmpty()) {
                this.formatter.setSuffix(temp);
            } else {
                OptParser.error();
            }
        } else {
            OptParser.error();
        }
    }

    private void parseShortOption(String opt) throws MalformedOptionException {
        if (opt.startsWith("-")) {
            throw new IllegalArgumentException("Trying to parse short option " + opt + " while it still cotnains a -");
        }
        char optStart = opt.charAt(0);
        String start = "" + optStart;
        switch (optStart) {
            case 'A': {
                int tempNum = this.getShortOptNum(start, opt, 0);
                if (tempNum >= EnumFormatStyle.values().length || tempNum < 0) {
                    OptParser.error();
                }
                this.formatter.setFormattingStyle(EnumFormatStyle.values()[tempNum]);
                break;
            }
            case 's': {
                this.formatter.setSpaceIndentation(this.getShortOptNum(start, opt, 4));
                break;
            }
            case 't': {
                this.formatter.setTabIndentation(this.getShortOptNum(start, opt, 4), false);
                break;
            }
            case 'T': {
                this.formatter.setTabIndentation(this.getShortOptNum(start, opt, 4), true);
                break;
            }
            case 'b': {
                this.formatter.setBracketFormatMode(EnumBracketMode.BREAK);
                break;
            }
            case 'a': {
                this.formatter.setBracketFormatMode(EnumBracketMode.ATTACH);
                break;
            }
            case 'l': {
                this.formatter.setBracketFormatMode(EnumBracketMode.LINUX);
                break;
            }
            case 'u': {
                this.formatter.setBracketFormatMode(EnumBracketMode.STROUSTRUP);
                break;
            }
            case 'C': {
                this.formatter.setClassIndent(true);
                break;
            }
            case 'S': {
                this.formatter.setSwitchIndent(true);
                break;
            }
            case 'K': {
                this.formatter.setCaseIndent(true);
                break;
            }
            case 'G': {
                this.formatter.setBlockIndent(true);
                break;
            }
            case 'B': {
                this.formatter.setBracketIndent(true);
                break;
            }
            case 'N': {
                this.formatter.setNamespaceIndent(true);
                break;
            }
            case 'L': {
                this.formatter.setLabelIndent(true);
                break;
            }
            case 'w': {
                this.formatter.setPreprocessorIndent(true);
                break;
            }
            case 'M': {
                this.formatter.setMaxInStatementIndentLength(this.getShortOptNum(start, opt, 40));
                break;
            }
            case 'm': {
                this.formatter.setMinConditionalIndentLength(this.getShortOptNum(start, opt, 8));
                break;
            }
            case 'f': {
                this.formatter.setBreakBlocksMode(true);
                break;
            }
            case 'F': {
                this.formatter.setBreakBlocksMode(true);
                this.formatter.setBreakClosingHeaderBlocksMode(true);
                break;
            }
            case 'y': {
                this.formatter.setBreakClosingHeaderBracketsMode(true);
                break;
            }
            case 'e': {
                this.formatter.setBreakElseIfsMode(true);
                break;
            }
            case 'x': {
                if (opt.length() == 1) {
                    this.formatter.setDeleteEmptyLinesMode(true);
                    break;
                }
                OptParser.error();
            }
            case 'p': {
                this.formatter.setOperatorPaddingMode(true);
                break;
            }
            case 'P': {
                this.formatter.setParensOutsidePaddingMode(true);
                this.formatter.setParensInsidePaddingMode(true);
                break;
            }
            case 'd': {
                this.formatter.setParensOutsidePaddingMode(true);
                break;
            }
            case 'D': {
                this.formatter.setParensInsidePaddingMode(true);
                break;
            }
            case 'U': {
                this.formatter.setParensUnPaddingMode(true);
                break;
            }
            case 'o': {
                this.formatter.setSingleStatementsMode(false);
                break;
            }
            case 'O': {
                this.formatter.setBreakOneLineBlocksMode(false);
                break;
            }
            case 'n': {
                this.formatter.setSuffix(null);
            }
        }
        OptParser.error();
    }

    private int getLongOptNum(String str, int def) throws MalformedOptionException {
        if (str.contains("=")) {
            try {
                String[] split = str.split("=");
                return Integer.parseInt(split[1]);
            }
            catch (Exception e) {
                OptParser.error();
            }
        }
        return def;
    }

    private int getShortOptNum(String start, String str, int def) throws MalformedOptionException {
        if (!str.startsWith(start)) {
            throw new IllegalArgumentException("Param start must be the portion of param str before the number!");
        }
        if (str.length() > start.length()) {
            try {
                return Integer.parseInt(str.substring(start.length()));
            }
            catch (Exception e) {
                OptParser.error();
            }
        }
        return def;
    }
}

