/*
 * Decompiled with CFR 0.152.
 */
package com.github.abrarsyed.jastyle;

import com.github.abrarsyed.jastyle.ASResource;
import com.github.abrarsyed.jastyle.ASSourceIterator;
import com.github.abrarsyed.jastyle.ASUtils;
import com.github.abrarsyed.jastyle.AbstractASBase;
import com.github.abrarsyed.jastyle.constants.SourceMode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class ASBeautifier
extends AbstractASBase {
    private List<String> headers;
    private List<String> nonParenHeaders;
    private List<String> preBlockStatements;
    private List<String> assignmentOperators;
    private List<String> nonAssignmentOperators;
    private List<String> indentableHeaders;
    private ASSourceIterator sourceIterator;
    private Stack<ASBeautifier> waitingBeautifierStack = null;
    private Stack<ASBeautifier> activeBeautifierStack = null;
    private Stack<Integer> waitingBeautifierStackLengthStack = null;
    private Stack<Integer> activeBeautifierStackLengthStack = null;
    private Stack<String> headerStack;
    private Stack<Stack<String>> tempStacks;
    private Stack<Integer> blockParenDepthStack;
    private Stack<Boolean> blockStatementStack;
    private Stack<Boolean> parenStatementStack;
    private Stack<Boolean> bracketBlockStateStack;
    private Stack<Integer> inStatementIndentStack;
    private Stack<Integer> inStatementIndentStackSizeStack;
    private Stack<Integer> parenIndentStack;
    private SourceMode beautifierFileType = null;
    private String indentString;
    private String currentHeader;
    private String previousLastLineHeader;
    private String probationHeader;
    private boolean isInQuote;
    private boolean isInVerbatimQuote;
    private boolean haveLineContinuationChar;
    private boolean isInComment;
    private boolean isInCase;
    private boolean isInQuestion;
    private boolean isInStatement;
    private boolean isInHeader;
    private boolean isInTemplate;
    private boolean isInDefine;
    private boolean isInDefineDefinition;
    private boolean classIndent;
    private boolean isInClassHeader;
    private boolean isInClassHeaderTab;
    private boolean switchIndent;
    private boolean caseIndent;
    private boolean namespaceIndent;
    private boolean bracketIndent;
    private boolean blockIndent;
    private boolean labelIndent;
    private boolean preprocessorIndent;
    private boolean isInConditional;
    private boolean isMinimalConditinalIndentSet;
    private boolean shouldForceTabIndentation;
    private boolean emptyLineFill;
    private boolean backslashEndsPrevLine;
    private boolean blockCommentNoIndent;
    private boolean blockCommentNoBeautify;
    private boolean previousLineProbationTab;
    private int minConditionalIndent;
    private int parenDepth;
    private int indentLength;
    private int blockTabCount;
    private int leadingWhiteSpaces;
    private int maxInStatementIndent;
    private int templateDepth;
    private int prevFinalLineSpaceTabCount;
    private int prevFinalLineTabCount;
    private int defineTabCount;
    private char quoteChar;
    private char prevNonSpaceCh;
    private char currentNonSpaceCh;
    private char currentNonLegalCh;
    private char prevNonLegalCh;
    private boolean useProperInnerClassIndenting = true;
    protected int inLineNumber;
    protected boolean lineCommentNoBeautify;
    protected boolean isNonInStatementArray;
    protected boolean isSharpAccessor;

    public ASBeautifier() {
        this.headerStack = null;
        this.tempStacks = null;
        this.blockParenDepthStack = null;
        this.blockStatementStack = null;
        this.parenStatementStack = null;
        this.bracketBlockStateStack = null;
        this.inStatementIndentStack = null;
        this.inStatementIndentStackSizeStack = null;
        this.parenIndentStack = null;
        this.sourceIterator = null;
        this.isMinimalConditinalIndentSet = false;
        this.shouldForceTabIndentation = false;
        this.setSpaceIndentation(4);
        this.setMaxInStatementIndentLength(40);
        this.setClassIndent(false);
        this.setSwitchIndent(false);
        this.setCaseIndent(false);
        this.setBlockIndent(false);
        this.setBracketIndent(false);
        this.setNamespaceIndent(false);
        this.setLabelIndent(false);
        this.setEmptyLineFill(false);
        this.fileType = SourceMode.JAVA;
        this.setSourceStyle(SourceMode.JAVA);
        this.setPreprocessorIndent(false);
    }

    public ASBeautifier(ASBeautifier other) {
        this.headerStack = other.headerStack;
        this.tempStacks = new Stack();
        Iterator iter = other.tempStacks.iterator();
        while (iter.hasNext()) {
            this.tempStacks.push((Stack<String>)iter.next());
        }
        this.blockParenDepthStack = other.blockParenDepthStack;
        this.blockStatementStack = other.blockStatementStack;
        this.parenStatementStack = other.parenStatementStack;
        this.bracketBlockStateStack = other.bracketBlockStateStack;
        this.inStatementIndentStack = other.inStatementIndentStack;
        this.inStatementIndentStackSizeStack = other.inStatementIndentStackSizeStack;
        this.parenIndentStack = other.parenIndentStack;
        this.sourceIterator = other.sourceIterator;
        this.inLineNumber = other.inLineNumber;
        this.lineCommentNoBeautify = other.lineCommentNoBeautify;
        this.isNonInStatementArray = other.isNonInStatementArray;
        this.isSharpAccessor = other.isSharpAccessor;
        this.indentString = other.indentString;
        this.currentHeader = other.currentHeader;
        this.previousLastLineHeader = other.previousLastLineHeader;
        this.probationHeader = other.probationHeader;
        this.isInQuote = other.isInQuote;
        this.isInVerbatimQuote = other.isInVerbatimQuote;
        this.haveLineContinuationChar = other.haveLineContinuationChar;
        this.isInComment = other.isInComment;
        this.isInCase = other.isInCase;
        this.isInQuestion = other.isInQuestion;
        this.isInStatement = other.isInStatement;
        this.isInHeader = other.isInHeader;
        this.isInTemplate = other.isInTemplate;
        this.isInDefine = other.isInDefine;
        this.isInDefineDefinition = other.isInDefineDefinition;
        this.classIndent = other.classIndent;
        this.isInClassHeader = other.isInClassHeader;
        this.isInClassHeaderTab = other.isInClassHeaderTab;
        this.switchIndent = other.switchIndent;
        this.caseIndent = other.caseIndent;
        this.namespaceIndent = other.namespaceIndent;
        this.bracketIndent = other.bracketIndent;
        this.blockIndent = other.blockIndent;
        this.labelIndent = other.labelIndent;
        this.preprocessorIndent = other.preprocessorIndent;
        this.isInConditional = other.isInConditional;
        this.isMinimalConditinalIndentSet = other.isMinimalConditinalIndentSet;
        this.shouldForceTabIndentation = other.shouldForceTabIndentation;
        this.emptyLineFill = other.emptyLineFill;
        this.backslashEndsPrevLine = other.backslashEndsPrevLine;
        this.blockCommentNoIndent = other.blockCommentNoIndent;
        this.blockCommentNoBeautify = other.blockCommentNoBeautify;
        this.previousLineProbationTab = other.previousLineProbationTab;
        this.fileType = other.fileType;
        this.minConditionalIndent = other.minConditionalIndent;
        this.parenDepth = other.parenDepth;
        this.indentLength = other.indentLength;
        this.blockTabCount = other.blockTabCount;
        this.leadingWhiteSpaces = other.leadingWhiteSpaces;
        this.maxInStatementIndent = other.maxInStatementIndent;
        this.templateDepth = other.templateDepth;
        this.prevFinalLineSpaceTabCount = other.prevFinalLineSpaceTabCount;
        this.prevFinalLineTabCount = other.prevFinalLineTabCount;
        this.defineTabCount = other.defineTabCount;
        this.quoteChar = other.quoteChar;
        this.prevNonSpaceCh = other.prevNonSpaceCh;
        this.currentNonSpaceCh = other.currentNonSpaceCh;
        this.currentNonLegalCh = other.currentNonLegalCh;
        this.prevNonLegalCh = other.prevNonLegalCh;
    }

    private void initStatic() {
        if (this.fileType == this.beautifierFileType) {
            return;
        }
        this.beautifierFileType = this.fileType;
        this.headers = new ArrayList<String>();
        this.nonParenHeaders = new ArrayList<String>();
        this.assignmentOperators = new ArrayList<String>();
        this.nonAssignmentOperators = new ArrayList<String>();
        this.preBlockStatements = new ArrayList<String>();
        this.indentableHeaders = new ArrayList<String>();
        ASResource.buildHeaders(this.headers, this.fileType, true);
        ASResource.buildNonParenHeaders(this.nonParenHeaders, this.fileType, true);
        ASResource.buildAssignmentOperators(this.assignmentOperators);
        ASResource.buildNonAssignmentOperators(this.nonAssignmentOperators);
        ASResource.buildPreBlockStatements(this.preBlockStatements, this.fileType);
        ASResource.buildIndentableHeaders(this.indentableHeaders);
    }

    public void init(ASSourceIterator iter) {
        this.sourceIterator = iter;
        this.init();
    }

    void init() {
        this.initStatic();
        this.init(this.getFileType());
        this.waitingBeautifierStack = new Stack();
        this.activeBeautifierStack = new Stack();
        this.waitingBeautifierStackLengthStack = new Stack();
        this.activeBeautifierStackLengthStack = new Stack();
        this.headerStack = new Stack();
        this.tempStacks = new Stack();
        this.tempStacks.add(new Stack());
        this.blockParenDepthStack = new Stack();
        this.blockStatementStack = new Stack();
        this.parenStatementStack = new Stack();
        this.bracketBlockStateStack = new Stack();
        this.bracketBlockStateStack.push(true);
        this.inStatementIndentStack = new Stack();
        this.inStatementIndentStackSizeStack = new Stack();
        this.inStatementIndentStackSizeStack.push(0);
        this.parenIndentStack = new Stack();
        this.previousLastLineHeader = null;
        this.currentHeader = null;
        this.isInQuote = false;
        this.isInVerbatimQuote = false;
        this.haveLineContinuationChar = false;
        this.isInComment = false;
        this.isInStatement = false;
        this.isInCase = false;
        this.isInQuestion = false;
        this.isInClassHeader = false;
        this.isInClassHeaderTab = false;
        this.isInHeader = false;
        this.isInTemplate = false;
        this.isInConditional = false;
        this.templateDepth = 0;
        this.parenDepth = 0;
        this.blockTabCount = 0;
        this.leadingWhiteSpaces = 0;
        this.prevNonSpaceCh = (char)123;
        this.currentNonSpaceCh = (char)123;
        this.prevNonLegalCh = (char)123;
        this.currentNonLegalCh = (char)123;
        this.quoteChar = (char)32;
        this.prevFinalLineSpaceTabCount = 0;
        this.prevFinalLineTabCount = 0;
        this.probationHeader = null;
        this.backslashEndsPrevLine = false;
        this.isInDefine = false;
        this.isInDefineDefinition = false;
        this.defineTabCount = 0;
        this.lineCommentNoBeautify = false;
        this.blockCommentNoIndent = false;
        this.blockCommentNoBeautify = false;
        this.previousLineProbationTab = false;
        this.isNonInStatementArray = false;
        this.isSharpAccessor = false;
        this.inLineNumber = 0;
    }

    public void setSourceStyle(SourceMode mode) {
        this.fileType = mode;
    }

    public void setTabIndentation(int length) {
        this.setTabIndentation(length, false);
    }

    public void setTabIndentation(int length, boolean forceTabs) {
        this.indentString = "\t";
        this.indentLength = length;
        this.shouldForceTabIndentation = forceTabs;
        if (!this.isMinimalConditinalIndentSet) {
            this.minConditionalIndent = this.indentLength * 2;
        }
    }

    public void setSpaceIndentation(int length) {
        this.indentString = ASUtils.repeat(length, ' ');
        this.indentLength = length;
        if (!this.isMinimalConditinalIndentSet) {
            this.minConditionalIndent = this.indentLength * 2;
        }
    }

    public void setMaxInStatementIndentLength(int max) {
        this.maxInStatementIndent = max;
    }

    public void setMinConditionalIndentLength(int min) {
        this.minConditionalIndent = min;
        this.isMinimalConditinalIndentSet = true;
    }

    public void setBracketIndent(boolean state) {
        this.bracketIndent = state;
    }

    public void setBlockIndent(boolean state) {
        this.blockIndent = state;
    }

    public void setClassIndent(boolean state) {
        this.classIndent = state;
    }

    public void setSwitchIndent(boolean state) {
        this.switchIndent = state;
    }

    public void setCaseIndent(boolean state) {
        this.caseIndent = state;
    }

    public void setNamespaceIndent(boolean state) {
        this.namespaceIndent = state;
    }

    public void setLabelIndent(boolean state) {
        this.labelIndent = state;
    }

    public void setPreprocessorIndent(boolean state) {
        this.preprocessorIndent = state;
    }

    public void setEmptyLineFill(boolean state) {
        this.emptyLineFill = state;
    }

    public SourceMode getFileType() {
        return this.fileType;
    }

    public int getIndentLength() {
        return this.indentLength;
    }

    public String getIndentString() {
        return this.indentString;
    }

    public boolean isBlockIndent() {
        return this.blockIndent;
    }

    public boolean isBracketIndent() {
        return this.bracketIndent;
    }

    public boolean isCaseIndent() {
        return this.caseIndent;
    }

    public boolean isEmptyLineFill() {
        return this.emptyLineFill;
    }

    public boolean hasMoreLines() {
        return this.sourceIterator.hasMoreLines();
    }

    public StringBuilder nextLine() {
        return this.beautify(this.sourceIterator.nextLine());
    }

    public boolean isUseProperInnerClassIndenting() {
        return this.useProperInnerClassIndenting;
    }

    public void setUseProperInnerClassIndenting(boolean useProperInnerClassIndenting) {
        this.useProperInnerClassIndenting = useProperInnerClassIndenting;
    }

    protected StringBuilder beautify(StringBuilder originalLine) {
        int i;
        int j;
        StringBuilder line = null;
        boolean isInLineComment = false;
        boolean lineStartsInComment = false;
        boolean isInClass = false;
        boolean isInSwitch = false;
        boolean isInOperator = false;
        boolean isSpecialChar = false;
        boolean haveCaseIndent = false;
        boolean closingBracketReached = false;
        boolean shouldIndentBrackettedLine = true;
        boolean previousLineProbation = this.probationHeader != null;
        boolean isInQuoteContinuation = this.isInVerbatimQuote | this.haveLineContinuationChar;
        char ch = ' ';
        int tabCount = 0;
        int spaceTabCount = 0;
        int lineOpeningBlocksNum = 0;
        int lineClosingBlocksNum = 0;
        StringBuilder outBuffer = new StringBuilder();
        String lastLineHeader = "";
        this.currentHeader = null;
        lineStartsInComment = this.isInComment;
        this.blockCommentNoBeautify = this.blockCommentNoIndent;
        this.previousLineProbationTab = false;
        this.haveLineContinuationChar = false;
        if (isInQuoteContinuation) {
            if (originalLine.length() != 1 || originalLine.charAt(0) != ' ') {
                line = new StringBuilder(originalLine);
            }
        } else if (!this.isInComment) {
            int strlen = originalLine.length();
            this.leadingWhiteSpaces = 0;
            for (j = 0; j < strlen && Character.isWhitespace(originalLine.charAt(j)); ++j) {
                if (originalLine.charAt(j) == '\t') {
                    this.leadingWhiteSpaces += this.indentLength;
                    continue;
                }
                ++this.leadingWhiteSpaces;
            }
            line = new StringBuilder(originalLine.toString().trim());
        } else {
            int trimSize;
            StringBuilder spaceTabs = new StringBuilder();
            spaceTabs.append(ASUtils.repeat(this.indentLength, ' '));
            StringBuilder newLine = new StringBuilder(originalLine.length() + 16);
            newLine.append((CharSequence)originalLine);
            int strlen = newLine.length();
            for (int j2 = 0; j2 < this.leadingWhiteSpaces && j2 < strlen; ++j2) {
                if (newLine.charAt(j2) != '\t') continue;
                newLine.replace(j2, j2 + 1, spaceTabs.toString());
                strlen = newLine.length();
            }
            strlen = newLine.length();
            for (trimSize = 0; trimSize < strlen && trimSize < this.leadingWhiteSpaces && Character.isWhitespace(newLine.charAt(trimSize)); ++trimSize) {
            }
            while (trimSize < strlen && Character.isWhitespace(newLine.charAt(strlen - 1))) {
                --strlen;
            }
            line = new StringBuilder(newLine.substring(trimSize, strlen));
            int trimEnd = ASUtils.findLastNotOf(line, " \t");
            int spacesToDelete = trimEnd == -1 ? line.length() : line.length() - 1 - trimEnd;
            if (spacesToDelete > 0) {
                line.delete(trimEnd + 1, trimEnd + 1 + spacesToDelete);
            }
        }
        if (line.length() == 0) {
            if (this.backslashEndsPrevLine) {
                line.append(" ");
            } else {
                if (this.emptyLineFill && !isInQuoteContinuation && this.headerStack.size() > 0) {
                    return this.preLineWS(this.prevFinalLineSpaceTabCount, this.prevFinalLineTabCount);
                }
                return line;
            }
        }
        if (!this.isInComment && (line.charAt(0) == '#' || this.backslashEndsPrevLine) && line.indexOf("#region") != 0 && line.indexOf("#endregion") != 0) {
            if (line.charAt(0) == '#') {
                String preproc = line.toString().trim();
                if (this.preprocessorIndent && preproc.indexOf("define") == 0 && line.charAt(line.length() - 1) == '\\') {
                    if (!this.isInDefineDefinition) {
                        this.isInDefineDefinition = true;
                        ASBeautifier defineBeautifier = new ASBeautifier(this);
                        this.activeBeautifierStack.add(defineBeautifier);
                    } else {
                        this.isInDefine = true;
                    }
                } else if (preproc.startsWith("if")) {
                    this.waitingBeautifierStackLengthStack.add(this.waitingBeautifierStack.size());
                    this.activeBeautifierStackLengthStack.add(this.activeBeautifierStack.size());
                    this.waitingBeautifierStack.add(new ASBeautifier(this));
                } else if (preproc.indexOf("else") == 0) {
                    if (this.waitingBeautifierStack != null && !this.waitingBeautifierStack.empty()) {
                        this.activeBeautifierStack.add(this.waitingBeautifierStack.pop());
                    }
                } else if (preproc.indexOf("elif") == 0) {
                    if (this.waitingBeautifierStack != null && !this.waitingBeautifierStack.empty()) {
                        this.activeBeautifierStack.add(new ASBeautifier(this.waitingBeautifierStack.peek()));
                    }
                } else if (preproc.indexOf("endif") == 0) {
                    int stackLength;
                    if (this.waitingBeautifierStackLengthStack != null && !this.waitingBeautifierStackLengthStack.empty()) {
                        stackLength = this.waitingBeautifierStackLengthStack.pop();
                        while (this.waitingBeautifierStack.size() > stackLength) {
                            this.waitingBeautifierStack.pop();
                        }
                    }
                    if (!this.activeBeautifierStackLengthStack.empty()) {
                        stackLength = this.activeBeautifierStackLengthStack.pop();
                        while (this.activeBeautifierStack.size() > stackLength) {
                            this.activeBeautifierStack.pop();
                        }
                    }
                }
            }
            this.backslashEndsPrevLine = line.length() > 0 ? line.charAt(line.length() - 1) == '\\' : false;
            if (!this.backslashEndsPrevLine && this.isInDefineDefinition && !this.isInDefine) {
                this.isInDefineDefinition = false;
                ASBeautifier defineBeautifier = this.activeBeautifierStack.pop();
                return defineBeautifier.beautify(line);
            }
            if (!this.isInDefine && !this.isInDefineDefinition) {
                return originalLine;
            }
        }
        if (!this.isInDefine && this.activeBeautifierStack != null && !this.activeBeautifierStack.empty()) {
            this.activeBeautifierStack.peek().inLineNumber = this.inLineNumber;
            this.activeBeautifierStack.peek().lineCommentNoBeautify = this.lineCommentNoBeautify;
            this.activeBeautifierStack.peek().isNonInStatementArray = this.isNonInStatementArray;
            this.activeBeautifierStack.peek().isSharpAccessor = this.isSharpAccessor;
            return this.activeBeautifierStack.peek().beautify(originalLine);
        }
        if (!this.inStatementIndentStack.empty()) {
            spaceTabCount = this.inStatementIndentStack.peek();
        }
        for (i = 0; i < this.headerStack.size(); ++i) {
            isInClass = false;
            if (this.blockIndent) {
                if (!(((String)this.headerStack.get(i)).equals("namespace") || ((String)this.headerStack.get(i)).equals("class") || ((String)this.headerStack.get(i)).equals("struct") || ((String)this.headerStack.get(i)).equals("union") || ((String)this.headerStack.get(i)).equals("") || ((String)this.headerStack.get(i)).equals("interface") || ((String)this.headerStack.get(i)).equals("throws") || ((String)this.headerStack.get(i)).equals("static"))) {
                    ++tabCount;
                }
            } else if (!(i > 0 && !((String)this.headerStack.get(i - 1)).equals("{") && ((String)this.headerStack.get(i)).equals("{") || this.useProperInnerClassIndenting && ((String)this.headerStack.get(i)).equals("static"))) {
                ++tabCount;
            }
            if (!this.isJavaStyle() && !this.namespaceIndent && i >= 1 && ((String)this.headerStack.get(i - 1)).equals("namespace") && ((String)this.headerStack.get(i)).equals("{")) {
                --tabCount;
            }
            if (this.isCStyle() && i >= 1 && ((String)this.headerStack.get(i - 1)).equals("class") && ((String)this.headerStack.get(i)).equals("{")) {
                if (this.classIndent) {
                    ++tabCount;
                }
                isInClass = true;
            } else if (this.switchIndent && i > 1 && ((String)this.headerStack.get(i - 1)).equals("switch") && ((String)this.headerStack.get(i)).equals("{")) {
                ++tabCount;
                isInSwitch = true;
            }
            if (!this.isJavaStyle() || i <= 1 || !((String)this.headerStack.get(i)).equals("throws") || !((String)this.headerStack.get(i - 1)).equals("static")) continue;
            --tabCount;
        }
        if (!lineStartsInComment && this.isCStyle() && isInClass && this.classIndent && this.headerStack.size() >= 2 && ((String)this.headerStack.get(this.headerStack.size() - 2)).equals("class") && ((String)this.headerStack.get(this.headerStack.size() - 1)).equals("{") && line.charAt(0) == '}') {
            --tabCount;
        } else if (!lineStartsInComment && isInSwitch && this.switchIndent && this.headerStack.size() >= 2 && ((String)this.headerStack.get(this.headerStack.size() - 2)).equals("switch") && ((String)this.headerStack.get(this.headerStack.size() - 1)).equals("{") && line.charAt(0) == '}') {
            --tabCount;
        }
        if (this.isInClassHeader) {
            this.isInClassHeaderTab = true;
            tabCount += 2;
        }
        if (this.isInConditional) {
            --tabCount;
        }
        for (i = 0; i < line.length(); ++i) {
            outBuffer.append(line.charAt(i));
            char tempCh = line.charAt(i);
            char prevCh = ch;
            ch = tempCh;
            if (Character.isWhitespace(ch)) continue;
            if (this.isInQuote && !this.isInVerbatimQuote) {
                if (isSpecialChar) {
                    isSpecialChar = false;
                    continue;
                }
                if (line.indexOf("\\\\", i) == i) {
                    outBuffer.append('\\');
                    ++i;
                    continue;
                }
                if (ch == '\\') {
                    if (this.peekNextChar(line, i) == ' ') {
                        this.haveLineContinuationChar = true;
                        continue;
                    }
                    isSpecialChar = true;
                    continue;
                }
            } else if (this.isInDefine && ch == '\\') continue;
            if (!(this.isInComment || isInLineComment || ch != '\"' && ch != '\'')) {
                if (!this.isInQuote) {
                    this.quoteChar = ch;
                    this.isInQuote = true;
                    if (this.isSharpStyle() && prevCh == '@') {
                        this.isInVerbatimQuote = true;
                    }
                } else if (this.isInVerbatimQuote && ch == '\"') {
                    if (this.peekNextChar(line, i) == '\"') {
                        outBuffer.append('\"');
                        ++i;
                    } else {
                        this.isInQuote = false;
                        this.isInVerbatimQuote = false;
                    }
                } else if (this.quoteChar == ch) {
                    this.isInQuote = false;
                    this.isInStatement = true;
                    continue;
                }
            }
            if (this.isInQuote) continue;
            if (!this.isInComment && !isInLineComment && line.indexOf("//", i) == i) {
                isInLineComment = true;
                outBuffer.append('/');
                ++i;
                continue;
            }
            if (!this.isInComment && !isInLineComment && line.indexOf("/*", i) == i) {
                this.isInComment = true;
                outBuffer.append('*');
                ++i;
                j = ASUtils.findFirstNotOf(line, " \t", 0);
                if (line.indexOf("/*", j) == j) continue;
                this.blockCommentNoIndent = true;
                continue;
            }
            if ((this.isInComment || isInLineComment) && line.indexOf("*/", i) == i) {
                this.isInComment = false;
                outBuffer.append('/');
                ++i;
                this.blockCommentNoIndent = false;
                continue;
            }
            if (this.isSharpStyle() && (line.indexOf("#region", i) == i || line.indexOf("#endregion", i) == i)) {
                isInLineComment = true;
                continue;
            }
            if (this.isInComment || isInLineComment) continue;
            if (this.probationHeader != null) {
                if (this.probationHeader.equals("static") || this.probationHeader.equals("") && ch == '{' || this.probationHeader.equals("synchronized") && ch == '(') {
                    this.isInHeader = true;
                    this.headerStack.add(this.probationHeader);
                    this.isInConditional = this.probationHeader.equals("synchronized");
                    this.isInStatement = false;
                    if (previousLineProbation && ch == '{' && (!this.blockIndent || !this.probationHeader.equals("") && !this.probationHeader.equals("static"))) {
                        ++tabCount;
                        this.previousLineProbationTab = true;
                    }
                    previousLineProbation = false;
                }
                this.probationHeader = null;
            }
            this.prevNonSpaceCh = this.currentNonSpaceCh;
            this.currentNonSpaceCh = ch;
            if (!this.isLegalNameChar(ch) && ch != ',' && ch != ';') {
                this.prevNonLegalCh = this.currentNonLegalCh;
                this.currentNonLegalCh = ch;
            }
            if (this.isInHeader) {
                this.isInHeader = false;
                this.currentHeader = this.headerStack.peek();
            } else {
                this.currentHeader = null;
            }
            if (this.isCStyle() && this.isInTemplate && (ch == '<' || ch == '>') && this.findOperator(line.toString(), i, this.nonAssignmentOperators) == null) {
                if (ch == '<') {
                    ++this.templateDepth;
                } else if (ch == '>' && --this.templateDepth <= 0) {
                    ch = this.isInTemplate ? (char)';' : '\t';
                    this.isInTemplate = false;
                    this.templateDepth = 0;
                }
            }
            if (ch == '(' || ch == '[' || ch == ')' || ch == ']') {
                if (ch == '(' || ch == '[') {
                    isInOperator = false;
                    if (ch == '(' && (this.isInClassHeader || this.isInClassHeaderTab) && this.headerStack.size() > 0 && this.headerStack.peek().equals("struct")) {
                        this.headerStack.pop();
                        this.isInClassHeader = false;
                        if (this.isInClassHeaderTab) {
                            tabCount -= 3;
                            this.isInClassHeaderTab = false;
                        }
                        if (tabCount < 0) {
                            tabCount = 0;
                        }
                    }
                    if (this.parenDepth == 0) {
                        this.parenStatementStack.add(this.isInStatement);
                        this.isInStatement = true;
                    }
                    ++this.parenDepth;
                    this.inStatementIndentStackSizeStack.add(this.inStatementIndentStack.size());
                    if (this.currentHeader != null) {
                        this.registerInStatementIndent(line.toString(), i, spaceTabCount, this.minConditionalIndent, true);
                        continue;
                    }
                    this.registerInStatementIndent(line.toString(), i, spaceTabCount, 0, true);
                    continue;
                }
                if (ch != ')' && ch != ']') continue;
                --this.parenDepth;
                if (this.parenDepth == 0) {
                    if (!this.parenStatementStack.empty()) {
                        this.isInStatement = this.parenStatementStack.pop();
                    }
                    ch = ' ';
                    this.isInConditional = false;
                }
                if (this.inStatementIndentStackSizeStack.empty()) continue;
                int previousIndentStackSize = this.inStatementIndentStackSizeStack.peek();
                this.inStatementIndentStackSizeStack.pop();
                while (previousIndentStackSize < this.inStatementIndentStack.size()) {
                    this.inStatementIndentStack.pop();
                }
                if (this.parenIndentStack.empty()) continue;
                int poppedIndent = this.parenIndentStack.pop();
                if (i != 0) continue;
                spaceTabCount = poppedIndent;
                continue;
            }
            if (ch == '{') {
                boolean isBlockOpener = this.prevNonSpaceCh == '{' && this.bracketBlockStateStack.peek() != false || this.prevNonSpaceCh == '}' || this.prevNonSpaceCh == ')' || this.prevNonSpaceCh == ';' || this.peekNextChar(line, i) == '{' || this.isNonInStatementArray || this.isSharpAccessor || this.isInClassHeader || this.isInDefine && (this.prevNonSpaceCh == '(' || this.isLegalNameChar(this.prevNonSpaceCh));
                this.isInClassHeader = false;
                if (!isBlockOpener && this.currentHeader != null) {
                    for (int n = 0; n < this.nonParenHeaders.size(); ++n) {
                        if (!this.currentHeader.equals(this.nonParenHeaders.get(n))) continue;
                        isBlockOpener = true;
                        break;
                    }
                }
                if (isBlockOpener && this.isSharpStyle() && !this.parenIndentStack.empty()) {
                    isBlockOpener = false;
                }
                this.bracketBlockStateStack.push(isBlockOpener);
                if (!isBlockOpener) {
                    this.inStatementIndentStackSizeStack.push(this.inStatementIndentStack.size());
                    this.registerInStatementIndent(line.toString(), i, spaceTabCount, 0, true);
                    ++this.parenDepth;
                    if (i != 0) continue;
                    shouldIndentBrackettedLine = false;
                    continue;
                }
                ++lineOpeningBlocksNum;
                if (this.isInClassHeaderTab) {
                    this.isInClassHeaderTab = false;
                    int firstChar = ASUtils.findFirstNotOf(line, " \t", 0);
                    if (firstChar != -1 && line.charAt(firstChar) == '{' && firstChar == i) {
                        tabCount -= 2;
                    }
                }
                if (this.bracketIndent && !this.namespaceIndent && this.headerStack.size() > 0 && this.headerStack.peek().equals("namespace")) {
                    shouldIndentBrackettedLine = false;
                    --tabCount;
                }
                if (this.inStatementIndentStack.size() > 0) {
                    spaceTabCount = 0;
                    this.inStatementIndentStack.set(this.inStatementIndentStack.size() - 1, 0);
                }
                this.blockParenDepthStack.push(this.parenDepth);
                this.blockStatementStack.push(this.isInStatement);
                this.inStatementIndentStackSizeStack.push(this.inStatementIndentStack.size());
                if (this.inStatementIndentStack.size() > 0) {
                    this.inStatementIndentStack.set(this.inStatementIndentStack.size() - 1, 0);
                }
                this.blockTabCount += this.isInStatement ? 1 : 0;
                this.parenDepth = 0;
                this.isInStatement = false;
                this.tempStacks.push(new Stack());
                this.headerStack.push("{");
                lastLineHeader = "{";
                continue;
            }
            boolean isPotentialHeader = this.isCharPotentialHeader(line, i);
            if (isPotentialHeader) {
                String newHeader = this.findHeader(line, i, this.headers);
                if (newHeader != null) {
                    char peekChar = this.peekNextChar(line, i + newHeader.length() - 1);
                    if (peekChar == ',' || peekChar == ')') {
                        newHeader = null;
                    } else if ((newHeader.equals("get") || newHeader.equals("set") || newHeader.equals("default")) && (peekChar == ';' || peekChar == '(')) {
                        newHeader = null;
                    }
                }
                if (newHeader != null) {
                    int r;
                    int restackSize;
                    boolean isIndentableHeader = true;
                    this.isInHeader = true;
                    Stack<String> lastTempStack = this.tempStacks.empty() ? null : this.tempStacks.peek();
                    if (newHeader.equals("if") && lastLineHeader.equals("else")) {
                        this.headerStack.pop();
                    } else if (newHeader.equals("else")) {
                        int indexOfIf;
                        if (lastTempStack != null && (indexOfIf = lastTempStack.indexOf("if")) != -1) {
                            restackSize = lastTempStack.size() - indexOfIf - 1;
                            for (r = 0; r < restackSize; ++r) {
                                this.headerStack.add(lastTempStack.pop());
                            }
                            if (!closingBracketReached) {
                                tabCount += restackSize;
                            }
                        }
                    } else if (newHeader.equals("while")) {
                        int indexOfDo;
                        if (lastTempStack != null && (indexOfDo = lastTempStack.indexOf("do")) != -1) {
                            restackSize = lastTempStack.size() - indexOfDo - 1;
                            for (r = 0; r < restackSize; ++r) {
                                this.headerStack.add(lastTempStack.peek());
                                lastTempStack.pop();
                            }
                            if (!closingBracketReached) {
                                tabCount += restackSize;
                            }
                        }
                    } else if (newHeader.equals("catch") || newHeader.equals("finally")) {
                        if (lastTempStack != null) {
                            int indexOfTry = lastTempStack.indexOf("try");
                            if (indexOfTry == -1) {
                                indexOfTry = lastTempStack.indexOf("catch");
                            }
                            if (indexOfTry != -1) {
                                restackSize = lastTempStack.size() - indexOfTry - 1;
                                for (r = 0; r < restackSize; ++r) {
                                    this.headerStack.add(lastTempStack.pop());
                                }
                                if (!closingBracketReached) {
                                    tabCount += restackSize;
                                }
                            }
                        }
                    } else if (newHeader.equals("case")) {
                        this.isInCase = true;
                        if (!haveCaseIndent) {
                            haveCaseIndent = true;
                            --tabCount;
                        }
                    } else if (newHeader.equals("default")) {
                        this.isInCase = true;
                        --tabCount;
                    } else if (newHeader.equals("static") || newHeader.equals("synchronized") || newHeader.equals("") && this.isCStyle()) {
                        if (!this.headerStack.empty() && (this.headerStack.peek().equals("static") || this.headerStack.peek().equals("synchronized") || this.headerStack.peek().equals(""))) {
                            isIndentableHeader = false;
                        } else {
                            isIndentableHeader = false;
                            this.probationHeader = newHeader;
                        }
                    } else if (newHeader.equals("")) {
                        isIndentableHeader = false;
                    } else if (newHeader.equals("template")) {
                        if (this.isCStyle()) {
                            this.isInTemplate = true;
                        }
                        isIndentableHeader = false;
                    }
                    if (isIndentableHeader) {
                        this.headerStack.add(newHeader);
                        this.isInStatement = false;
                        if (this.nonParenHeaders.indexOf(newHeader) == -1) {
                            this.isInConditional = true;
                        }
                        lastLineHeader = newHeader;
                    } else {
                        this.isInHeader = false;
                    }
                    outBuffer.append(newHeader.substring(1));
                    i += newHeader.length() - 1;
                    continue;
                }
            }
            if (ch == '?') {
                this.isInQuestion = true;
            } else if (ch == ':') {
                if (line.length() > i + 1 && line.charAt(i + 1) == ':') {
                    ++i;
                    outBuffer.append(':');
                    ch = ' ';
                    continue;
                }
                if (this.isInQuestion) {
                    this.isInQuestion = false;
                } else if (this.isCStyle() && isInClass && this.prevNonSpaceCh != ')') {
                    --tabCount;
                } else if (this.isCStyle() && this.prevNonSpaceCh == ')' && !this.isInCase) {
                    this.isInClassHeader = true;
                    if (i == 0) {
                        tabCount += 2;
                    }
                } else {
                    this.currentNonSpaceCh = (char)59;
                    if (this.isInCase) {
                        this.isInCase = false;
                        ch = ';';
                    } else if (this.isCStyle() || this.isSharpStyle() && this.peekNextChar(line, i) == ';') {
                        tabCount = this.labelIndent ? --tabCount : 0;
                    }
                }
            }
            if ((ch == ';' || this.parenDepth > 0 && ch == ',') && !this.inStatementIndentStackSizeStack.empty()) {
                while (this.inStatementIndentStackSizeStack.peek() + (this.parenDepth > 0 ? 1 : 0) < this.inStatementIndentStack.size()) {
                    this.inStatementIndentStack.pop();
                }
            }
            if (ch == ';' && this.parenDepth == 0 || ch == '}') {
                if (ch == '}') {
                    boolean bracketBlockState;
                    if (!this.bracketBlockStateStack.empty() && !(bracketBlockState = this.bracketBlockStateStack.pop().booleanValue())) {
                        if (this.inStatementIndentStackSizeStack.empty()) continue;
                        int previousIndentStackSize = this.inStatementIndentStackSizeStack.pop();
                        while (previousIndentStackSize < this.inStatementIndentStack.size()) {
                            this.inStatementIndentStack.pop();
                        }
                        --this.parenDepth;
                        if (i == 0) {
                            shouldIndentBrackettedLine = false;
                        }
                        if (this.parenIndentStack.empty()) continue;
                        int poppedIndent = this.parenIndentStack.pop();
                        if (i != 0) continue;
                        spaceTabCount = poppedIndent;
                        continue;
                    }
                    ++lineClosingBlocksNum;
                    if (!this.inStatementIndentStackSizeStack.empty()) {
                        this.inStatementIndentStackSizeStack.pop();
                    }
                    if (!this.blockParenDepthStack.empty()) {
                        this.parenDepth = this.blockParenDepthStack.pop();
                        this.isInStatement = this.blockStatementStack.pop();
                        if (this.isInStatement) {
                            --this.blockTabCount;
                        }
                    }
                    closingBracketReached = true;
                    int headerPlace = this.headerStack.indexOf("{");
                    if (headerPlace != -1) {
                        String popped = this.headerStack.peek();
                        while (!popped.equals("{")) {
                            this.headerStack.pop();
                            popped = this.headerStack.peek();
                        }
                        this.headerStack.pop();
                        if (!this.namespaceIndent && this.headerStack.size() > 0 && this.headerStack.peek().equals("namespace")) {
                            shouldIndentBrackettedLine = false;
                        }
                        if (!this.tempStacks.empty()) {
                            this.tempStacks.pop();
                        }
                    }
                    ch = ' ';
                }
                if (!this.tempStacks.peek().empty()) {
                    while (!this.tempStacks.peek().empty()) {
                        this.tempStacks.peek().pop();
                    }
                }
                while (!this.headerStack.empty() && !this.headerStack.peek().equals("{")) {
                    this.tempStacks.peek().add(this.headerStack.pop());
                }
                if (this.parenDepth == 0 && ch == ';') {
                    this.isInStatement = false;
                }
                this.previousLastLineHeader = null;
                this.isInClassHeader = false;
                this.isInQuestion = false;
                continue;
            }
            if (isPotentialHeader) {
                String newHeader;
                if (!(this.isInTemplate || this.isCStyle() && this.parenDepth > 0 || (newHeader = this.findHeader(line, i, this.preBlockStatements)) == null)) {
                    this.isInClassHeader = true;
                    if (!this.isSharpStyle()) {
                        this.headerStack.add(newHeader);
                    } else if (!(newHeader.equals("where") || newHeader.equals("class") && this.headerStack.size() > 0 && this.headerStack.peek().equals("class"))) {
                        this.headerStack.add(newHeader);
                    }
                    outBuffer.append(newHeader.substring(1));
                    i += newHeader.length() - 1;
                    continue;
                }
                String foundIndentableHeader = this.findHeader(line, i, this.indentableHeaders);
                if (foundIndentableHeader != null) {
                    outBuffer.append(foundIndentableHeader.substring(1));
                    i += foundIndentableHeader.length() - 1;
                    if (isInOperator || this.isInTemplate || this.isNonInStatementArray) continue;
                    this.registerInStatementIndent(line.toString(), i, spaceTabCount, 0, false);
                    this.isInStatement = true;
                    continue;
                }
                if (this.isCStyle() && this.findKeyword(line, i, "operator")) {
                    isInOperator = true;
                }
                if (this.findKeyword(line, i, "new") && this.prevNonSpaceCh == '=' && this.isInStatement && !this.inStatementIndentStack.empty()) {
                    this.inStatementIndentStack.set(this.inStatementIndentStack.size() - 1, 0);
                }
                String name = this.getCurrentWord(line, i);
                outBuffer.append(name.substring(1));
                i += name.length() - 1;
                continue;
            }
            boolean isPotentialOperator = this.isCharPotentialOperator(ch);
            if (!isPotentialOperator) continue;
            String foundAssignmentOp = this.findOperator(line.toString(), i, this.assignmentOperators);
            String foundNonAssignmentOp = this.findOperator(line.toString(), i, this.nonAssignmentOperators);
            if (foundAssignmentOp != null && foundNonAssignmentOp != null) {
                if (foundAssignmentOp.length() < foundNonAssignmentOp.length()) {
                    foundAssignmentOp = null;
                } else {
                    foundNonAssignmentOp = null;
                }
            }
            if (foundNonAssignmentOp != null) {
                if (foundNonAssignmentOp.length() <= 1) continue;
                outBuffer.append(foundNonAssignmentOp.substring(1));
                i += foundNonAssignmentOp.length() - 1;
                continue;
            }
            if (foundAssignmentOp == null) continue;
            if (foundAssignmentOp.length() > 1) {
                outBuffer.append(foundAssignmentOp.substring(1));
                i += foundAssignmentOp.length() - 1;
            }
            if (isInOperator || this.isInTemplate || this.isNonInStatementArray) continue;
            this.registerInStatementIndent(line.toString(), i, spaceTabCount, 0, false);
            this.isInStatement = true;
        }
        if (!(lineStartsInComment || this.blockIndent || outBuffer.length() <= 0 || outBuffer.charAt(0) != '{' || lineOpeningBlocksNum > 0 && lineOpeningBlocksNum == lineClosingBlocksNum || this.headerStack.size() > 1 && ((String)this.headerStack.get(this.headerStack.size() - 2)).equals("{") || !shouldIndentBrackettedLine)) {
            --tabCount;
        } else if (!lineStartsInComment && outBuffer.length() > 0 && outBuffer.charAt(0) == '}' && shouldIndentBrackettedLine) {
            --tabCount;
        } else if (!lineStartsInComment && outBuffer.length() > 0 && lineOpeningBlocksNum > 0 && lineOpeningBlocksNum == lineClosingBlocksNum && this.previousLineProbationTab) {
            --tabCount;
        } else if (!lineStartsInComment && this.isInClassHeaderTab && !this.blockIndent && outBuffer.length() > 0 && lineOpeningBlocksNum == 0 && lineOpeningBlocksNum == lineClosingBlocksNum && this.headerStack.size() > 0 && this.headerStack.peek().equals("class")) {
            --tabCount;
        }
        if (tabCount < 0) {
            tabCount = 0;
        }
        if (!lineStartsInComment && this.bracketIndent && shouldIndentBrackettedLine && outBuffer.length() > 0 && (outBuffer.charAt(0) == '{' || outBuffer.charAt(0) == '}')) {
            ++tabCount;
        }
        if (this.isInDefine) {
            String preproc;
            if (outBuffer.charAt(0) == '#' && (preproc = outBuffer.toString().trim()).startsWith("define")) {
                if (!this.inStatementIndentStack.empty() && this.inStatementIndentStack.peek() > 0) {
                    this.defineTabCount = tabCount;
                } else {
                    this.defineTabCount = tabCount - 1;
                    --tabCount;
                }
            }
            tabCount -= this.defineTabCount;
        }
        if (tabCount < 0) {
            tabCount = 0;
        }
        if (this.lineCommentNoBeautify || this.blockCommentNoBeautify || isInQuoteContinuation) {
            spaceTabCount = 0;
            tabCount = 0;
        }
        this.prevFinalLineSpaceTabCount = spaceTabCount;
        this.prevFinalLineTabCount = tabCount;
        if (this.shouldForceTabIndentation) {
            tabCount += spaceTabCount / this.indentLength;
            spaceTabCount %= this.indentLength;
        }
        outBuffer = new StringBuilder(this.preLineWS(spaceTabCount, tabCount).append((CharSequence)outBuffer));
        if (lastLineHeader != null) {
            this.previousLastLineHeader = lastLineHeader;
        }
        return outBuffer;
    }

    private StringBuilder preLineWS(int spaceTabCount, int tabCount) {
        int stc = spaceTabCount;
        StringBuilder ws = new StringBuilder();
        for (int i = 0; i < tabCount; ++i) {
            ws.append(this.indentString);
        }
        while (stc-- > 0) {
            ws.append(" ");
        }
        return ws;
    }

    private void registerInStatementIndent(String line, int i, int spaceTabCount, int minIndent, boolean updateParenStack) {
        int remainingCharNum = line.length() - i;
        int nextNonWSChar = this.getNextProgramCharDistance(line, i);
        if (nextNonWSChar == remainingCharNum) {
            int previousIndent = spaceTabCount;
            if (!this.inStatementIndentStack.empty()) {
                previousIndent = this.inStatementIndentStack.peek();
            }
            this.inStatementIndentStack.add(this.indentLength + previousIndent);
            if (updateParenStack) {
                this.parenIndentStack.add(previousIndent);
            }
            return;
        }
        if (updateParenStack) {
            this.parenIndentStack.add(i + spaceTabCount);
        }
        int inStatementIndent = i + nextNonWSChar + spaceTabCount;
        if (i + nextNonWSChar < minIndent) {
            inStatementIndent = minIndent + spaceTabCount;
        }
        if (i + nextNonWSChar > this.maxInStatementIndent) {
            inStatementIndent = this.indentLength * 2 + spaceTabCount;
        }
        if (!this.inStatementIndentStack.empty() && inStatementIndent < this.inStatementIndentStack.peek()) {
            inStatementIndent = this.inStatementIndentStack.peek();
        }
        if (this.isNonInStatementArray) {
            inStatementIndent = 0;
        }
        this.inStatementIndentStack.add(inStatementIndent);
    }

    private int getNextProgramCharDistance(String line, int i) {
        int charDistance;
        boolean inComment = false;
        int remainingCharNum = line.length() - i;
        for (charDistance = 1; charDistance < remainingCharNum; ++charDistance) {
            char ch = line.charAt(i + charDistance);
            if (inComment) {
                if (line.indexOf("*/", i + charDistance) != i + charDistance) continue;
                ++charDistance;
                inComment = false;
                continue;
            }
            if (Character.isWhitespace(ch)) continue;
            if (ch == '/') {
                if (line.indexOf("//", i + charDistance) == i + charDistance) {
                    return remainingCharNum;
                }
                if (line.indexOf("/*", i + charDistance) != i + charDistance) continue;
                ++charDistance;
                inComment = true;
                continue;
            }
            return charDistance;
        }
        return charDistance;
    }

    protected String findHeader(StringBuilder line, int i, List<String> possibleHeaders) {
        assert (this.isCharPotentialHeader(line, i)) : line + " is not a potential header";
        int maxHeaders = possibleHeaders.size();
        for (int p = 0; p < maxHeaders; ++p) {
            int result;
            String header = possibleHeaders.get(p);
            int end = i + header.length();
            if (end > line.length() || (result = line.substring(i, end).compareTo(header)) > 0) continue;
            if (result < 0) break;
            int wordEnd = i + header.length();
            if (wordEnd == line.length()) {
                return header;
            }
            if (this.isLegalNameChar(line.charAt(wordEnd))) continue;
            char peekChar = this.peekNextChar(line, wordEnd - 1);
            if (peekChar == ',' || peekChar == ')') break;
            return header;
        }
        return null;
    }

    protected String findOperator(String line, int i, List<String> possibleOperators) {
        assert (this.isCharPotentialOperator(line.charAt(i))) : line.charAt(i) + " is not a potential header";
        int maxOperators = possibleOperators.size();
        for (int p = 0; p < maxOperators; ++p) {
            if (line.indexOf(possibleOperators.get(p), i) != i) continue;
            return possibleOperators.get(p);
        }
        return null;
    }

    @Override
    public char peekNextChar(StringBuilder line, int i) {
        char ch = ' ';
        int peekNum = ASUtils.findFirstNotOf(line, " \t", i + 1);
        if (peekNum == -1) {
            return ch;
        }
        ch = line.charAt(peekNum);
        return ch;
    }
}

