/*
 * Decompiled with CFR 0.152.
 */
package com.github.abrarsyed.jastyle;

import com.github.abrarsyed.jastyle.ASFormatter;
import com.github.abrarsyed.jastyle.FileWildcardFilter;
import com.github.abrarsyed.jastyle.OptParser;
import com.github.abrarsyed.jastyle.exceptions.MalformedOptionException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;

public class Main {
    private static final int EXIT_SUCCESS = 0;
    private static final int EXIT_FAILURE = -1;
    private static final String JASTYLE_VERSION = Main.findVersion("version.txt");
    private static boolean recursive = false;
    private static File optionsFile = null;
    public static ArrayList<String> errors = new ArrayList();

    private static final void printVersion() {
        System.out.println("\n                                 jAstyle " + JASTYLE_VERSION);
        System.out.println("                         Maintained by: AbrarSyed\n");
    }

    private static final void printHelp() {
        Main.printVersion();
        Main.printText("help.txt", new PrintWriter(System.out));
    }

    private static final String findVersion(String filename) {
        StringWriter writer = new StringWriter();
        Main.printText(filename, new PrintWriter(writer));
        return writer.toString();
    }

    private static final void printText(String filename, PrintWriter out) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(Main.class.getResourceAsStream(filename)));
        try {
            String line;
            do {
                if ((line = reader.readLine()) == null) continue;
                out.println(line);
            } while (line != null);
            out.flush();
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] cliArgs) throws IOException {
        if (cliArgs.length < 1) {
            Main.printHelp();
            System.exit(0);
        }
        System.out.println("Parsing options...");
        errors.clear();
        ArrayList<String> args = Main.convertList(cliArgs);
        ArrayList<String> filenames = Main.parseConsoleOptions(args);
        ASFormatter formatter = new ASFormatter();
        OptParser parser = new OptParser(formatter);
        if (optionsFile != null) {
            ArrayList<String> parsedErrors = parser.parseOptionFile(optionsFile);
            if (parsedErrors == null) {
                errors.add("something went wrong reading options file : " + optionsFile);
            }
            Iterator iterator = parsedErrors.iterator();
            while (iterator.hasNext()) {
                String e = (String)iterator.next();
                System.err.println(e + " is not a supported config file option, continuing...");
            }
        }
        for (String opt : args) {
            try {
                parser.parseOption(opt);
            }
            catch (MalformedOptionException e) {
                errors.add("option " + opt + " is not a valid option");
            }
        }
        if (errors.size() > 0) {
            for (String error : errors) {
                System.err.println(error);
            }
            System.exit(-1);
        }
        formatter.fixOptionVariableConflicts();
        System.out.println("Parsing file names...");
        ArrayList<File> files = Main.parseFileNames(filenames, recursive);
        System.out.println("Formatting files.");
        for (File currFile : files) {
            System.out.println("Converting " + currFile.getAbsolutePath() + " ...\n");
            boolean worked = formatter.formatFile(currFile);
            if (worked) continue;
            System.out.println("Error formatting file " + currFile.getAbsolutePath() + " ...\n");
        }
        System.out.println("Complete");
        System.exit(0);
    }

    public static ArrayList<String> parseConsoleOptions(ArrayList<String> args) {
        ArrayList<String> filenames = new ArrayList<String>();
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String arg : args) {
            if (arg.startsWith("--")) {
                String temp = arg.substring(2);
                if (temp.equals("recursive")) {
                    recursive = true;
                } else if (temp.equals("version")) {
                    Main.printVersion();
                    System.exit(0);
                } else if (temp.equals("help")) {
                    Main.printHelp();
                    System.exit(0);
                } else {
                    if (!temp.startsWith("options=")) continue;
                    if ((temp = temp.substring(8)).equals("none")) {
                        optionsFile = null;
                    } else {
                        optionsFile = new File(temp);
                        if (!optionsFile.exists()) {
                            errors.add("the file " + temp + " could not be found.");
                        }
                    }
                }
                toRemove.add(arg);
                continue;
            }
            if (arg.startsWith("-")) {
                if (arg.length() > 2) continue;
                switch (arg.charAt(1)) {
                    case 'R': 
                    case 'r': {
                        recursive = true;
                        toRemove.add(arg);
                        break;
                    }
                    case 'V': {
                        Main.printVersion();
                        System.exit(0);
                    }
                    case '?': 
                    case 'h': {
                        Main.printHelp();
                        System.exit(0);
                    }
                }
                continue;
            }
            filenames.add(arg);
            toRemove.add(arg);
        }
        args.removeAll(toRemove);
        return filenames;
    }

    private static ArrayList<File> parseFileNames(ArrayList<String> filenames, boolean recursive) {
        ArrayList<File> files = new ArrayList<File>();
        FileWildcardFilter filter = null;
        for (String filepath : filenames) {
            File temp;
            String name;
            String dir;
            int index = filepath.lastIndexOf(File.separatorChar);
            if (index < 0) {
                dir = ".";
                name = filepath;
            } else {
                if (index >= filepath.length()) {
                    System.err.println("The filename " + filepath + " is invalid");
                    System.exit(-1);
                }
                dir = filepath.substring(0, index);
                name = filepath.substring(index + 1);
            }
            if (name.indexOf(42) != -1 || name.indexOf(63) != -1) {
                filter = new FileWildcardFilter(name);
                temp = new File(dir);
            } else {
                temp = name.isEmpty() ? new File(dir) : new File(dir, name);
            }
            files.addAll(Main.collectFiles(temp, filter, recursive));
            filter = null;
        }
        return files;
    }

    private static <T> ArrayList<T> convertList(T[] array) {
        ArrayList<T> list = new ArrayList<T>();
        for (T obj : array) {
            list.add(obj);
        }
        return list;
    }

    public static ArrayList<File> collectFiles(File dir, FilenameFilter filter, boolean recurse) {
        ArrayList<File> files = new ArrayList<File>();
        if (dir.isFile() && (filter == null || filter.accept(dir, dir.getName()))) {
            files.add(dir);
            return files;
        }
        for (File file : dir.listFiles()) {
            if (file.isFile() && (filter == null || filter.accept(dir, file.getName()))) {
                files.add(file);
            }
            if (!file.isDirectory() || !recurse) continue;
            files.addAll(Main.collectFiles(file, filter, recurse));
        }
        return files;
    }
}

