/*
 * Decompiled with CFR 0.152.
 */
package com.github.abrarsyed.jastyle.reader;

import java.io.IOException;
import java.io.Reader;

public class ExtendedReader
extends Reader {
    private Reader _reader;
    private boolean _hasBufferedChar = false;
    private char _bufferedChar;
    private char _bufferedCharSaved;
    private boolean _hasBufferedCharSaved = false;

    public ExtendedReader(Reader in) {
        super((Object)in);
        this._reader = in;
    }

    public synchronized int peek() throws IOException {
        if (!this._hasBufferedChar) {
            int bufferedChar = this.read();
            if (bufferedChar < 0) {
                return bufferedChar;
            }
            this._bufferedChar = (char)bufferedChar;
            this._hasBufferedChar = true;
        }
        return this._bufferedChar;
    }

    public synchronized boolean isEndOfStream() throws IOException {
        return this.peek() < 0;
    }

    @Override
    public synchronized int read(char[] cbuf, int off, int len) throws IOException {
        int offset = off;
        if (len <= 0) {
            return 0;
        }
        int readLength = len;
        boolean extraChar = this._hasBufferedChar;
        if (this._hasBufferedChar) {
            this._hasBufferedChar = false;
            cbuf[offset++] = this._bufferedChar;
            --readLength;
        }
        int read = this._reader.read(cbuf, offset, readLength);
        if (extraChar) {
            ++read;
        }
        return read;
    }

    @Override
    public synchronized boolean ready() throws IOException {
        if (this._hasBufferedChar) {
            return true;
        }
        return this._reader.ready();
    }

    @Override
    public synchronized boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        if (this._hasBufferedChar) {
            this._bufferedCharSaved = this._bufferedChar;
            this._hasBufferedCharSaved = true;
        }
        this._reader.mark(readAheadLimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this._hasBufferedCharSaved) {
            this._bufferedChar = this._bufferedCharSaved;
            this._hasBufferedChar = true;
            this._hasBufferedCharSaved = false;
        } else {
            this._hasBufferedChar = false;
        }
        this._reader.reset();
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        long skipChars = n;
        if (this._hasBufferedChar && skipChars > 0L) {
            this._hasBufferedChar = false;
            --skipChars;
        }
        return this._reader.skip(skipChars);
    }

    @Override
    public synchronized void close() throws IOException {
        this._hasBufferedChar = false;
        this._hasBufferedCharSaved = true;
        this._reader.close();
    }
}

